/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.Util;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.LinkActionBeanConfig;
import com.install4j.runtime.installer.config.LinkBeanConfig;
import com.install4j.runtime.installer.config.LinkGroupBeanConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractBeanConfig
extends AbstractConfig {
    private static final String ELEMENT_STRING = "string";
    private static List<AbstractBeanConfig> batch = new LinkedList<AbstractBeanConfig>();
    private static WeakHashMap<Bean, String> allBeans = new WeakHashMap();
    private static Map<String, List<AbstractBeanConfig>> actionsLists = new HashMap<String, List<AbstractBeanConfig>>();
    protected String id;
    protected String customizedId = "";
    protected String idNamespace = "";
    private Element javaElement;
    private String conditionClassName = "";
    private boolean rollbackBarrier = false;

    public static void finishBatch() {
        final XMLDecoder xmlDecoder = AbstractBeanConfig.createBatchXmlDecoder();
        if (xmlDecoder == null) {
            return;
        }
        if (Util.isAix()) {
            xmlDecoder.setExceptionListener(new ExceptionListener(){

                @Override
                public void exceptionThrown(Exception e) {
                }
            });
        }
        for (AbstractBeanConfig beanConfig : batch) {
            try {
                Bean bean = GUIHelper.invokeOnEDT(new Callable<Bean>(){

                    @Override
                    public Bean call() throws Exception {
                        return (Bean)xmlDecoder.readObject();
                    }
                });
                allBeans.put(bean, beanConfig.getDisplayedId());
                beanConfig.setBean(bean);
            }
            catch (Throwable e) {
                Logger.getInstance().error(null, "Exception during instantiation of bean ID " + beanConfig.id);
                InstallerUtil.reportException(e);
                InstallerUtil.exit(1);
            }
        }
        batch.clear();
    }

    private static XMLDecoder createBatchXmlDecoder() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<java class=\"java.beans.XMLDecoder\">");
        Iterator<AbstractBeanConfig> it = batch.iterator();
        while (it.hasNext()) {
            AbstractBeanConfig beanConfig = it.next();
            if (!beanConfig.isInstantiated()) {
                String javaElementString;
                try {
                    beanConfig.replaceRuntimeVariables();
                    javaElementString = XmlHelper.getString(XmlHelper.findChild(beanConfig.javaElement, null));
                }
                catch (IOException e) {
                    Logger.getInstance().error(null, "Exception during instantiation of bean ID " + beanConfig.id);
                    InstallerUtil.reportException(e);
                    InstallerUtil.exit(1);
                    return null;
                }
                javaElementString = InstallerVariables.replaceVariables(javaElementString, ReplacementMode.I18N_ONLY);
                buffer.append(javaElementString);
                continue;
            }
            it.remove();
        }
        buffer.append("</java>");
        try {
            return AbstractBeanConfig.createXMLDecoder(new ByteArrayInputStream(buffer.toString().getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            Logger.getInstance().error(null, "Exception during bean instantiation ");
            InstallerUtil.reportException(e);
            InstallerUtil.exit(1);
            return null;
        }
    }

    private static XMLDecoder createXMLDecoder(InputStream in) {
        return new XMLDecoder(in, null, null, (ClassLoader)Install4jClassLoader.getInstance());
    }

    public static void clearBeans() {
        batch.clear();
        allBeans.clear();
    }

    public static List<AbstractBeanConfig> getActionListBeans(String id) {
        return actionsLists.get(id);
    }

    public static AbstractBeanConfig readNestedBeanConfig(Element beanElement) {
        AbstractBeanConfig beanConfig = AbstractBeanConfig.createNestedBeanConfig(beanElement);
        if (beanConfig != null) {
            beanConfig.read(beanElement);
        }
        return beanConfig;
    }

    private static AbstractBeanConfig createNestedBeanConfig(Element beanElement) {
        String beanElementName = beanElement.getTagName();
        if (beanElementName.equalsIgnoreCase("action")) {
            return new ActionBeanConfig();
        }
        if (beanElementName.equalsIgnoreCase("group")) {
            return new GroupBeanConfig(false);
        }
        if (beanElementName.equalsIgnoreCase("link")) {
            if (AbstractBeanConfig.readAttribute(beanElement, "group", false)) {
                return new LinkGroupBeanConfig(false);
            }
            return new LinkActionBeanConfig();
        }
        return null;
    }

    public static String getId(Bean bean) {
        return allBeans.get(bean);
    }

    public String getId() {
        return this.id;
    }

    public String getCustomizedId() {
        return this.customizedId;
    }

    public String getDisplayedId() {
        return this.customizedId.length() == 0 ? this.id : this.customizedId;
    }

    public String getIdNamespace() {
        return this.idNamespace;
    }

    public String getConditionClassName() {
        return this.conditionClassName;
    }

    public boolean isRollbackBarrier() {
        return this.rollbackBarrier;
    }

    public abstract boolean isInstantiated();

    protected void setBean(Bean bean) {
    }

    public void batchInstantiate() {
        AbstractBeanConfig actualBeanConfig = null;
        if (this instanceof LinkBeanConfig) {
            actualBeanConfig = ((LinkBeanConfig)((Object)this)).getDelegate();
        } else if (!this.isInstantiated()) {
            actualBeanConfig = this;
        }
        if (actualBeanConfig != null) {
            batch.add(actualBeanConfig);
        }
    }

    public String getClassName() {
        return XmlHelper.readAttribute(XmlHelper.findChild(this.javaElement, "object"), "class", "");
    }

    protected Bean instantiateBean(boolean suppressErrors) {
        try {
            this.replaceRuntimeVariables();
            String javaElementString = XmlHelper.getString(this.javaElement);
            XMLDecoder xmlDecoder = AbstractBeanConfig.createXMLDecoder(new ByteArrayInputStream(javaElementString.getBytes("UTF-8")));
            Bean bean = (Bean)xmlDecoder.readObject();
            allBeans.put(bean, this.getDisplayedId());
            return bean;
        }
        catch (Throwable e) {
            if (!suppressErrors) {
                Logger.getInstance().error(null, "Exception during instantiation of bean ID " + this.getDisplayedId());
                InstallerUtil.reportException(e);
                InstallerUtil.exit(1);
            }
            return null;
        }
    }

    private void replaceRuntimeVariables() {
        this.replaceRuntimeVariables(this.javaElement);
    }

    private void replaceRuntimeVariables(Element javaElement) {
        if (javaElement.getTagName().equals(ELEMENT_STRING)) {
            Node textNode = javaElement.getFirstChild();
            if (textNode != null) {
                String content = InstallerVariables.replaceVariables(textNode.getNodeValue(), ReplacementMode.I18N_ONLY);
                textNode.setNodeValue(content);
            }
        } else {
            for (Element childElement : AbstractBeanConfig.childElements(javaElement)) {
                this.replaceRuntimeVariables(childElement);
            }
        }
    }

    @Override
    protected void read(Element element) {
        this.id = AbstractBeanConfig.readAttribute(element, "id", this.id);
        this.customizedId = AbstractBeanConfig.readAttribute(element, "customizedId", this.customizedId);
        this.idNamespace = AbstractBeanConfig.readAttribute(element, "idNamespace", this.idNamespace);
        this.rollbackBarrier = AbstractBeanConfig.readAttribute(element, "rollbackBarrier", this.rollbackBarrier);
        this.conditionClassName = AbstractBeanConfig.readAttribute(element, "conditionClass", this.conditionClassName);
        this.javaElement = AbstractBeanConfig.findChild(element, "java");
        this.readActionLists(element);
    }

    private void readActionLists(Element element) {
        Element actionListsElement = AbstractBeanConfig.findChild(element, "actionLists");
        if (actionListsElement != null) {
            for (Element actionListElement : AbstractBeanConfig.childElements(actionListsElement)) {
                String id = AbstractBeanConfig.readAttribute(actionListElement, "id", "");
                ArrayList<AbstractBeanConfig> actionBeanConfigs = new ArrayList<AbstractBeanConfig>();
                for (Element actionElement : AbstractBeanConfig.childElements(actionListElement)) {
                    AbstractBeanConfig beanConfig = AbstractBeanConfig.readNestedBeanConfig(actionElement);
                    if (beanConfig == null) continue;
                    actionBeanConfigs.add(beanConfig);
                }
                actionsLists.put(id, actionBeanConfigs);
            }
        }
    }

    public void addAllTo(Map<String, AbstractBeanConfig> id2BeanConfig) {
        String qualifiedId = this.id;
        String qualifiedDisplayedId = this.getDisplayedId();
        if (this.idNamespace.length() > 0) {
            qualifiedId = this.idNamespace + ":" + qualifiedId;
            qualifiedDisplayedId = this.idNamespace + ":" + qualifiedDisplayedId;
        }
        id2BeanConfig.put(qualifiedId, this);
        if (!qualifiedDisplayedId.equals(qualifiedId)) {
            id2BeanConfig.put(qualifiedDisplayedId, this);
        }
    }

    protected String getIdInNamespace(String id) {
        if (this.idNamespace.length() > 0) {
            return this.idNamespace + ":" + id;
        }
        return id;
    }
}

