/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.components;

import com.install4j.api.SystemInfo;
import com.install4j.api.Util;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.DirectorySelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.MissingResourceException;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InstallationDirectorySelector
extends JPanel
implements DirectorySelector.InternalValidator,
FileValidator {
    private JLabel lblSpace;
    private JLabel lblFreeSpace;
    private boolean showRequiredDiskSpace = true;
    private boolean showFreeDiskSpace = true;
    private boolean checkFreeSpace = true;
    private boolean suggestAppDir = true;
    private boolean existingDirWarning = true;
    private boolean validateApplicationId = true;
    private boolean checkWritable = true;
    private boolean allowSpacesOnUnix = false;
    private boolean manualEntryAllowed = true;
    private boolean allowNewFolderCreation = false;
    private ScriptProperty validationScript;
    private boolean compact = false;
    private boolean standardValidation = true;
    private DirectorySelector directorySelector;
    private boolean initialized;
    private Context context;
    private FormEnvironment formEnvironment;
    private Bean bean;
    private boolean designTime;

    public InstallationDirectorySelector(Bean bean) {
        this.bean = bean;
    }

    public void setDesignTime(boolean designTime) {
        this.designTime = designTime;
    }

    public void createComponent() {
        this.removeAll();
        this.setupControls();
        this.setupComponent();
    }

    public boolean isShowRequiredDiskSpace() {
        return this.showRequiredDiskSpace;
    }

    public void setShowRequiredDiskSpace(boolean showRequiredDiskSpace) {
        this.showRequiredDiskSpace = showRequiredDiskSpace;
    }

    public boolean isShowFreeDiskSpace() {
        return this.showFreeDiskSpace;
    }

    public void setShowFreeDiskSpace(boolean showFreeDiskSpace) {
        this.showFreeDiskSpace = showFreeDiskSpace;
    }

    public boolean isCheckFreeSpace() {
        return this.checkFreeSpace;
    }

    public void setCheckFreeSpace(boolean checkFreeSpace) {
        this.checkFreeSpace = checkFreeSpace;
    }

    public boolean isSuggestAppDir() {
        return this.suggestAppDir;
    }

    public void setSuggestAppDir(boolean suggestAppDir) {
        this.suggestAppDir = suggestAppDir;
    }

    public boolean isExistingDirWarning() {
        return this.existingDirWarning;
    }

    public void setExistingDirWarning(boolean existingDirWarning) {
        this.existingDirWarning = existingDirWarning;
    }

    public boolean isValidateApplicationId() {
        return this.validateApplicationId;
    }

    public void setValidateApplicationId(boolean validateApplicationId) {
        this.validateApplicationId = validateApplicationId;
    }

    public boolean isAllowSpacesOnUnix() {
        return this.allowSpacesOnUnix;
    }

    public void setAllowSpacesOnUnix(boolean allowSpacesOnUnix) {
        this.allowSpacesOnUnix = allowSpacesOnUnix;
    }

    public ScriptProperty getValidationScript() {
        return this.validationScript;
    }

    public void setValidationScript(ScriptProperty validationScript) {
        this.validationScript = validationScript;
    }

    public boolean isAllowNewFolderCreation() {
        return this.allowNewFolderCreation;
    }

    public void setAllowNewFolderCreation(boolean allowNewFolderCreation) {
        this.allowNewFolderCreation = allowNewFolderCreation;
    }

    public boolean isManualEntryAllowed() {
        return this.manualEntryAllowed;
    }

    public void setManualEntryAllowed(boolean manualEntryAllowed) {
        this.manualEntryAllowed = manualEntryAllowed;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public void setStandardValidation(boolean standardValidation) {
        this.standardValidation = standardValidation;
    }

    public boolean isStandardValidation() {
        return this.standardValidation;
    }

    public boolean isCheckWritable() {
        return this.checkWritable;
    }

    public void setCheckWritable(boolean checkWritable) {
        this.checkWritable = checkWritable;
    }

    public void update() {
        this.init();
        if (this.lblSpace != null) {
            long minSize = this.designTime ? 0L : (long)((double)ContentInstaller.getInstance().getMinSize() * 1.1);
            String spaceText = this.getSizeText(minSize);
            this.lblSpace.setText(spaceText);
        }
        if (this.lblFreeSpace != null) {
            long freeSize = this.designTime ? 0L : SystemInfo.getFreeDiskSpace(this.directorySelector.getSelectedFile());
            String freeSpaceText = this.getSizeText(freeSize);
            this.lblFreeSpace.setText(freeSpaceText);
        }
    }

    private String getSizeText(long bytes) {
        if (bytes > 0x280000000L) {
            return Messages.format(this.getMessage("ComponentSize3"), this.getGB(bytes));
        }
        return Messages.format(this.getMessage("ComponentSize2"), this.getMB(bytes));
    }

    private void init() {
        if (!this.initialized && !this.designTime) {
            String standardDirectoryName;
            File initialParentFile;
            File defaultDirectory = this.context.getInstallationDirectory();
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            if (!(!this.suggestAppDir || config.isAddOnInstaller() || Util.isMacosInstaller() && config.getMacSpecificConfig().isSingleBundle())) {
                initialParentFile = defaultDirectory.getParentFile();
                standardDirectoryName = defaultDirectory.getName();
            } else {
                initialParentFile = defaultDirectory;
                standardDirectoryName = null;
            }
            if (initialParentFile == null) {
                initialParentFile = defaultDirectory;
                standardDirectoryName = config.getApplicationName();
            }
            this.directorySelector.initDirectory(initialParentFile, standardDirectoryName);
            this.directorySelector.setNoStandardDirectoryNameForUpdate(true);
            this.directorySelector.setAllowSpacesOnUnix(this.allowSpacesOnUnix);
            this.directorySelector.setAllowNewFolderCreation(this.allowNewFolderCreation);
            this.directorySelector.setManualEntryAllowed(this.manualEntryAllowed);
            this.directorySelector.setStandardValidation(this.standardValidation);
            this.initialized = true;
        }
    }

    private void setupControls() {
        this.ensureDirectorySelectorCreated();
        this.directorySelector.activateNextScreenOnEnter(this.context.getWizardContext());
        this.directorySelector.addPropertyChangeListener("selectedPath", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                InstallationDirectorySelector.this.update();
            }
        });
    }

    private void ensureDirectorySelectorCreated() {
        if (this.directorySelector == null) {
            this.directorySelector = new DirectorySelector(this.compact ? null : this.getMessage("ReadyMemoDir").replace(':', ' ').trim(), this.designTime);
            this.directorySelector.setInternalValidator(this);
            this.directorySelector.setValidator(this);
        }
    }

    private void setupComponent() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        if (this.showRequiredDiskSpace || this.showFreeDiskSpace) {
            gc.insets.bottom = 5;
        }
        gc.anchor = 21;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 3;
        this.add((Component)this.directorySelector, gc);
        ++gc.gridy;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        if (this.showRequiredDiskSpace) {
            this.lblSpace = this.addLabel("RequiredDiskSpaceLabel", gc);
        }
        if (this.showFreeDiskSpace && (Util.isWindows() || Util.isMacOS() || Util.isLinux())) {
            this.lblFreeSpace = this.addLabel("FreeDiskSpaceLabel", gc);
        }
        this.update();
    }

    private JLabel addLabel(String messageKey, GridBagConstraints gc) {
        JLabel valueLabel = new JLabel();
        gc.insets.right = 5;
        this.add((Component)new JLabel(this.getMessage(messageKey)), gc);
        gc.insets.right = 0;
        gc.gridx = 1;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 22;
        this.add((Component)valueLabel, gc);
        gc.anchor = 21;
        gc.fill = 2;
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        return valueLabel;
    }

    private String getMB(long sizeBytes) {
        return this.getFormattedSize(sizeBytes, 0x100000L);
    }

    private String getGB(long sizeBytes) {
        return this.getFormattedSize(sizeBytes, 0x40000000L);
    }

    private String getFormattedSize(double sizeBytes, long factor) {
        double size = sizeBytes / (double)factor;
        if (size < 0.0) {
            size = 0.0;
        }
        DecimalFormat decimalFormat = size < 10.0 ? new DecimalFormat("#,###,##0.0") : new DecimalFormat("#,###,##0");
        return decimalFormat.format(size);
    }

    private String getMessage(String key) throws MissingResourceException {
        return Messages.getMessages().getString(key);
    }

    public void setContext(Context context) {
        this.context = context;
        context.addInstallerEventListener(new InstallerEventListener(){

            @Override
            public void installerEvent(InstallerEvent event) {
                if (!InstallationDirectorySelector.this.context.isConsole() && !InstallationDirectorySelector.this.context.isUnattended() && event instanceof InstallerVariableEvent && ((InstallerVariableEvent)event).getVariableName().equals("sys.installationDir")) {
                    InstallationDirectorySelector.this.init();
                    InstallationDirectorySelector.this.directorySelector.setDirectory(InstallationDirectorySelector.this.context.getInstallationDirectory());
                }
            }
        });
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        this.formEnvironment = formEnvironment;
    }

    @Override
    public File validateInternally(File dir) {
        return ContentInstaller.validateInstallationDir(dir, this.validateApplicationId, this.checkFreeSpace, this.existingDirWarning, this.context.isUnattended(), false);
    }

    @Override
    public boolean isValidFile(File file) {
        if (this.validationScript != null) {
            Object[] arguments = this.formEnvironment != null ? new Object[]{file, this.formEnvironment} : new Object[]{file};
            return ContextImpl.getContextInt(this.context).runBooleanScript(this.validationScript.getValue(), this.bean, arguments);
        }
        return true;
    }

    private File getSelectedDir() {
        this.init();
        return this.directorySelector.getSelectedFile();
    }

    public boolean handleUnattended() {
        File selectedDir = this.validateInternally(this.context.getInstallationDirectory());
        if (selectedDir == null || !InstallerUtil.checkWritableInstallationDirectory(selectedDir, true)) {
            Util.showMessage(Messages.getMessages().getString("DestinationDirHelp"), 1);
            return false;
        }
        if (!Boolean.getBoolean("install4j.extraSilent")) {
            Util.showMessage(Messages.format(Messages.getMessages().getString("UnattendedInstallationDir"), selectedDir), 1);
        }
        if (this.context instanceof InstallerContext) {
            ((InstallerContext)this.context).setInstallationDirectory(selectedDir);
        }
        return true;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        this.ensureDirectorySelectorCreated();
        this.init();
        while (true) {
            String defaultDirectory = this.context.getInstallationDirectory().getAbsolutePath();
            String answer = console.askString(Messages.format(this.getMessage("SelectDirDesc"), InstallerConfig.getCurrentInstance().getApplicationName()), defaultDirectory);
            try {
                File selectedDir = new File(answer).getCanonicalFile();
                this.directorySelector.setSelectedFile(selectedDir);
                if (!new File(answer).isAbsolute() || selectedDir.exists() && !selectedDir.isDirectory()) {
                    console.println(Messages.format(this.getMessage("InvalidDirectory"), answer));
                    continue;
                }
                if (!this.directorySelector.checkSelectedFile() || (selectedDir = this.directorySelector.getSelectedFile()) == null || !InstallerUtil.checkWritableInstallationDirectory(selectedDir, true)) continue;
                if (this.context instanceof InstallerContext) {
                    ((InstallerContext)this.context).setInstallationDirectory(selectedDir);
                }
                return true;
            }
            catch (IOException e) {
                console.println(Messages.format(this.getMessage("InvalidDirectory"), answer));
                continue;
            }
            break;
        }
    }

    public DirectorySelector getDirectorySelector() {
        return this.directorySelector;
    }

    public void focusTextField() {
        this.directorySelector.focusTextField();
    }

    public boolean checkCompleted() {
        if (this.directorySelector.checkSelectedFile()) {
            File destDir = this.getSelectedDir();
            if (this.context instanceof InstallerContext) {
                ((InstallerContext)this.context).setInstallationDirectory(destDir);
            }
            return !this.checkWritable || InstallerUtil.checkWritableInstallationDirectory(destDir, true);
        }
        return false;
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.directorySelector.getBaseline(width, height);
    }
}

