/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.runtime.beans.screens.BannerScreen;
import com.install4j.runtime.beans.screens.UpdatePanel;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.HorizontalShrinkWrapper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JPanel;

public class WelcomeScreen
extends BannerScreen
implements FormPanelContainer {
    private boolean updateCheck = true;
    private UpdatePanel updatePanel;
    private DisplayTextArea welcomeTextArea;
    private JPanel formPanel;
    private FormEnvironment formEnvironment;

    public boolean isUpdateCheck() {
        return this.updateCheck;
    }

    public void setUpdateCheck(boolean updateCheck) {
        this.updateCheck = updateCheck;
    }

    @Override
    public boolean isPreviousVisible() {
        return false;
    }

    @Override
    public void activated() {
        InstallerContext installerContext = this.getInstallerContext();
        if (installerContext != null && this.updateCheck && installerContext.isUpdateInstallation()) {
            this.updatePanel.update(this.getContext());
            boolean writableInstallationDirectory = InstallerUtil.checkWritableInstallationDirectory(this.getContext().getInstallationDirectory(), false);
            this.updatePanel.setVisible(writableInstallationDirectory);
        } else {
            this.updatePanel.setVisible(false);
        }
        this.welcomeTextArea.setText(Messages.format(WelcomeScreen.replaceVariables(this.getMessage(this.isAskForUpdate() ? "ConsoleWelcomeLabel" : "WelcomeLabel3")), this.getApplicationName()));
        super.activated();
        try {
            Logger.getInstance().log(this, "thread name " + Thread.currentThread().getName(), true);
        }
        catch (Throwable t) {
            Logger.getInstance().log(t);
        }
    }

    private boolean isAskForUpdate() {
        return this.updatePanel != null && this.updatePanel.isVisible();
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        this.welcomeTextArea = this.addDisplayTextArea("", panel, gc);
        gc.insets.top = 0;
        this.updatePanel = new UpdatePanel(this.getInstallerContext());
        gc.fill = 2;
        panel.add((Component)this.updatePanel, gc);
        ++gc.gridy;
        gc.weightx = 1.0;
        gc.fill = 2;
        panel.add((Component)new HorizontalShrinkWrapper(this.formPanel), gc);
        ++gc.gridy;
        this.addDisplayTextArea("\n" + this.getMessage("ClickNext"), panel, gc);
        String extraMessage = this.getExtraMessage();
        if (!extraMessage.isEmpty()) {
            DisplayTextArea dtxa = this.addDisplayTextArea("\n" + extraMessage, panel, gc);
            dtxa.setFont(dtxa.getFont().deriveFont(1));
        }
    }

    @Override
    protected boolean checkCompleted() {
        if (this.isAskForUpdate()) {
            this.getContext().setVariable("sys.confirmedUpdateInstallation", this.updatePanel.isUpdate());
        }
        return super.checkCompleted();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        if (!console.askOkCancel(Messages.format(WelcomeScreen.replaceVariables(this.getMessage("ConsoleWelcomeLabel")) + this.getExtraMessage(), this.getApplicationName()), true)) {
            return false;
        }
        InstallerContext installerContext = this.getInstallerContext();
        if (this.updateCheck && installerContext != null && installerContext.isUpdateInstallation()) {
            int result = console.askOption(this.getMessage("PreviousInstallationLabel"), new String[]{this.getMessage("RadioUpdateInstallation"), this.getMessage("RadioNewInstallation")}, null, 0, false, true);
            this.getContext().setVariable("sys.confirmedUpdateInstallation", result == 0);
        }
        return this.formEnvironment.handleConsole(console);
    }

    @Override
    public String getTitle() {
        return Messages.format(this.getMessage("WelcomeLabel1"), this.getApplicationName());
    }

    @Override
    public String getSubTitle() {
        return "";
    }

    private String getExtraMessage() {
        String status = InstallerConfig.getCurrentInstance().getStatus();
        if (status == null || !status.equals("LCOK")) {
            return "This installer was created with an evaluation version of install4j";
        }
        return "";
    }

    @Override
    public void setFormPanel(JPanel formPanel, FormEnvironment formEnvironment) {
        this.formPanel = formPanel;
        this.formEnvironment = formEnvironment;
    }

    @Override
    public boolean isScrollFormPanel() {
        return true;
    }

    @Override
    public FormEnvironment getFormEnvironment() {
        return this.formEnvironment;
    }

    @Override
    public boolean isFillVertical() {
        return false;
    }
}

