/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.InfoScreen;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LicenseScreen
extends InfoScreen
implements ActionListener {
    private JRadioButton rdoLicenseAccept;
    private JRadioButton rdoLicenseRefuse;
    private boolean acceptInitiallySelected = false;
    private boolean readAllRequired = false;

    public boolean isAcceptInitiallySelected() {
        return this.acceptInitiallySelected;
    }

    public void setAcceptInitiallySelected(boolean acceptInitiallySelected) {
        this.acceptInitiallySelected = acceptInitiallySelected;
    }

    public boolean isReadAllRequired() {
        return this.readAllRequired;
    }

    public void setReadAllRequired(boolean readAllRequired) {
        this.readAllRequired = readAllRequired;
    }

    @Override
    public void activated() {
        super.activated();
        this.getContext().getWizardContext().setNextButtonEnabled(!this.rdoLicenseRefuse.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.rdoLicenseAccept && !this.acceptInitiallySelected && this.readAllRequired && !this.isAllRead()) {
            Util.showMessage(this.getMessage("ReadLicenseFirst"), 1);
            this.rdoLicenseRefuse.setSelected(true);
        }
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.rdoLicenseAccept = new JRadioButton(this.getMessage("LicenseAccepted"), this.acceptInitiallySelected);
        this.rdoLicenseRefuse = new JRadioButton(this.getMessage("LicenseNotAccepted"), !this.acceptInitiallySelected);
        ButtonGroup bgrLicense = new ButtonGroup();
        bgrLicense.add(this.rdoLicenseAccept);
        bgrLicense.add(this.rdoLicenseRefuse);
    }

    @Override
    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.rdoLicenseAccept.addActionListener(this);
        this.rdoLicenseRefuse.addActionListener(this);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LicenseScreen.this.getContext().getWizardContext().setNextButtonEnabled(LicenseScreen.this.rdoLicenseAccept.isSelected());
            }
        };
        this.rdoLicenseAccept.addItemListener(itemListener);
        this.rdoLicenseRefuse.addItemListener(itemListener);
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        super.addScreenContent(panel, gc);
        gc.fill = 2;
        gc.weighty = 0.0;
        gc.insets.bottom = 0;
        panel.add((Component)this.rdoLicenseAccept, gc);
        ++gc.gridy;
        gc.insets.top = 0;
        gc.insets.bottom = 10;
        panel.add((Component)this.rdoLicenseRefuse, gc);
        gc.insets.top = 3;
    }

    @Override
    protected boolean handleConsoleQuestion(Console console) throws UserCanceledException {
        return console.askOption(this.getMessage("LicenseAccepted"), new String[]{this.getMessage("ButtonYes"), this.getMessage("ButtonNo")}, null, -1) == 0;
    }

    @Override
    protected String getHeaderText() {
        return this.getMessage("LicenseLabel3");
    }

    @Override
    protected String getConsoleText() {
        return this.getHeaderText();
    }

    @Override
    public String getTitle() {
        return this.getMessage("WizardLicense");
    }

    @Override
    public String getSubTitle() {
        return this.getMessage("LicenseLabel");
    }
}

