/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallationComponentSetup;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.DescriptionScreen;
import com.install4j.runtime.beans.screens.components.InstallationDirectorySelector;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.installationcomponents.InstallationComponentTree;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ComponentsScreen
extends DescriptionScreen {
    private boolean showInstallationDirectoryChooser = false;
    private ScriptProperty selectionChangedScript;
    private JLabel destinationLabel;
    private InstallationDirectorySelector installationDirectorySelector = new InstallationDirectorySelector(this);
    private InstallationComponentTree tree;
    private JScrollPane scpTree;

    public ComponentsScreen() {
        this.installationDirectorySelector.setCompact(true);
        this.setBoldDescription(true);
    }

    public ScriptProperty getSelectionChangedScript() {
        return this.selectionChangedScript;
    }

    public void setSelectionChangedScript(ScriptProperty selectionChangedScript) {
        this.selectionChangedScript = selectionChangedScript;
    }

    public boolean isShowInstallationDirectoryChooser() {
        Boolean confirmedUpdateInstallation;
        Context context = this.getContext();
        Boolean bl = confirmedUpdateInstallation = context == null ? null : (Boolean)context.getVariable("sys.confirmedUpdateInstallation");
        if (confirmedUpdateInstallation != null) {
            return this.showInstallationDirectoryChooser && confirmedUpdateInstallation == false;
        }
        return this.showInstallationDirectoryChooser;
    }

    public void setShowInstallationDirectoryChooser(boolean showInstallationDirectoryChooser) {
        this.showInstallationDirectoryChooser = showInstallationDirectoryChooser;
    }

    public boolean isShowRequiredDiskSpace() {
        return this.installationDirectorySelector.isShowRequiredDiskSpace();
    }

    public void setShowRequiredDiskSpace(boolean showRequiredDiskSpace) {
        this.installationDirectorySelector.setShowRequiredDiskSpace(showRequiredDiskSpace);
    }

    public boolean isShowFreeDiskSpace() {
        return this.installationDirectorySelector.isShowFreeDiskSpace();
    }

    public void setShowFreeDiskSpace(boolean showFreeDiskSpace) {
        this.installationDirectorySelector.setShowFreeDiskSpace(showFreeDiskSpace);
    }

    public boolean isCheckFreeSpace() {
        return this.installationDirectorySelector.isCheckFreeSpace();
    }

    public void setCheckFreeSpace(boolean checkFreeSpace) {
        this.installationDirectorySelector.setCheckFreeSpace(checkFreeSpace);
    }

    public boolean isSuggestAppDir() {
        return this.installationDirectorySelector.isSuggestAppDir();
    }

    public void setSuggestAppDir(boolean suggestAppDir) {
        this.installationDirectorySelector.setSuggestAppDir(suggestAppDir);
    }

    public boolean isExistingDirWarning() {
        return this.installationDirectorySelector.isExistingDirWarning();
    }

    public void setExistingDirWarning(boolean existingDirWarning) {
        this.installationDirectorySelector.setExistingDirWarning(existingDirWarning);
    }

    public boolean isValidateApplicationId() {
        return this.installationDirectorySelector.isValidateApplicationId();
    }

    public void setValidateApplicationId(boolean validateApplicationId) {
        this.installationDirectorySelector.setValidateApplicationId(validateApplicationId);
    }

    public boolean isAllowSpacesOnUnix() {
        return this.installationDirectorySelector.isAllowSpacesOnUnix();
    }

    public void setAllowSpacesOnUnix(boolean allowSpacesOnUnix) {
        this.installationDirectorySelector.setAllowSpacesOnUnix(allowSpacesOnUnix);
    }

    public boolean isAllowNewFolderCreation() {
        return this.installationDirectorySelector.isAllowNewFolderCreation();
    }

    public void setAllowNewFolderCreation(boolean allowNewFolderCreation) {
        this.installationDirectorySelector.setAllowNewFolderCreation(allowNewFolderCreation);
    }

    public boolean isManualEntryAllowed() {
        return this.installationDirectorySelector.isManualEntryAllowed();
    }

    public void setManualEntryAllowed(boolean manualEntryAllowed) {
        this.installationDirectorySelector.setManualEntryAllowed(manualEntryAllowed);
    }

    public ScriptProperty getValidationScript() {
        return this.installationDirectorySelector.getValidationScript();
    }

    public void setValidationScript(ScriptProperty validationScript) {
        this.installationDirectorySelector.setValidationScript(validationScript);
    }

    public boolean isStandardValidation() {
        return this.installationDirectorySelector.isStandardValidation();
    }

    public void setStandardValidation(boolean standardValidation) {
        this.installationDirectorySelector.setStandardValidation(standardValidation);
    }

    public boolean isCheckWritable() {
        return this.installationDirectorySelector.isCheckWritable();
    }

    public void setCheckWritable(boolean standardValidation) {
        this.installationDirectorySelector.setCheckWritable(standardValidation);
    }

    @Override
    public void setInstallerContext(InstallerContext context) {
        super.setInstallerContext(context);
        if (this.showInstallationDirectoryChooser) {
            this.installationDirectorySelector.setContext(context);
        }
    }

    @Override
    public boolean isHidden() {
        return InstallerConfig.getCurrentInstance().getComponents().size() == 0 || this.getContext().getBooleanVariable("sys.preventComponentCustomization");
    }

    @Override
    public String getTitle() {
        return this.getMessage("WizardSelectComponents");
    }

    @Override
    public String getSubTitle() {
        return this.getMessage("SelectComponentsDesc");
    }

    @Override
    public void willActivate() {
        super.willActivate();
        boolean showInstallationDirectoryChooser = this.isShowInstallationDirectoryChooser();
        this.installationDirectorySelector.setVisible(showInstallationDirectoryChooser);
        this.destinationLabel.setVisible(showInstallationDirectoryChooser);
        if (showInstallationDirectoryChooser) {
            this.installationDirectorySelector.update();
        }
    }

    @Override
    public void activated() {
        super.activated();
        this.tree.updateAllNodes();
        this.tree.checkFolders();
    }

    @Override
    protected boolean checkCompleted() {
        return super.checkCompleted() && (!this.isShowInstallationDirectoryChooser() || this.installationDirectorySelector.checkCompleted());
    }

    @Override
    public boolean handleUnattended() {
        return !this.isShowInstallationDirectoryChooser() || this.installationDirectorySelector.handleUnattended();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        if (this.isShowInstallationDirectoryChooser() && !this.installationDirectorySelector.handleConsole(console)) {
            return false;
        }
        console.println(this.getMessage("SelectComponentsDesc"));
        ComponentFolderConfig componentRoot = InstallerConfig.getCurrentInstance().getComponentRoot();
        ComponentConsoleState componentConsoleState = new ComponentConsoleState();
        this.printFolder(console, componentRoot, componentConsoleState, "");
        while (true) {
            if (!componentConsoleState.helpIndexToComponentNodeConfig.isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                for (Integer index : componentConsoleState.helpIndexToComponentNodeConfig.keySet()) {
                    if (buffer.length() > 0) {
                        buffer.append(", ");
                    }
                    buffer.append("*");
                    buffer.append(index);
                }
                console.println(Messages.format(this.getMessage("ConsoleComponentHelpLabel"), buffer.toString()));
            }
            String answer = console.askString(this.getMessage("ConsoleMultipleSelectionLabel"), componentConsoleState.defaultConsoleSelection);
            try {
                if (answer.startsWith("*")) {
                    ComponentNodeConfig config = this.getConfigForIndex(answer.substring(1), componentConsoleState.helpIndexToComponentNodeConfig);
                    console.println();
                    console.println(config.getName() + ": " + config.getDescription());
                    console.println();
                    continue;
                }
                if (answer.equals("\"\"")) {
                    answer = "";
                }
                HashSet<ComponentNodeConfig> selectedComponents = new HashSet<ComponentNodeConfig>();
                StringTokenizer stringTokenizer = new StringTokenizer(answer, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    ComponentNodeConfig config = this.getConfigForIndex(stringTokenizer.nextToken().trim(), componentConsoleState.indexToComponentNodeConfig);
                    selectedComponents.add(config);
                }
                selectedComponents.addAll(componentConsoleState.mandatoryComponents);
                componentRoot.setSelected(false);
                this.updateTree(selectedComponents, componentRoot);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    private ComponentNodeConfig getConfigForIndex(String numberString, Map<Integer, ComponentNodeConfig> indexToComponentNodeConfig) throws NumberFormatException {
        int number = Integer.parseInt(numberString);
        ComponentNodeConfig config = indexToComponentNodeConfig.get(number);
        if (config == null) {
            throw new NumberFormatException("not available");
        }
        return config;
    }

    private void updateTree(Set<ComponentNodeConfig> selectedComponents, ComponentFolderConfig folderConfig) {
        for (int i = 0; i < folderConfig.getComponents().size(); ++i) {
            ComponentNodeConfig childConfig;
            childConfig.setSelected(selectedComponents.contains(childConfig = folderConfig.getComponents().get(i)) || folderConfig.isIncluded());
            if (!(childConfig instanceof ComponentFolderConfig)) continue;
            this.updateTree(selectedComponents, (ComponentFolderConfig)childConfig);
        }
    }

    private void printFolder(Console console, ComponentFolderConfig folderConfig, ComponentConsoleState componentConsoleState, String prefix) {
        for (int i = 0; i < folderConfig.getComponents().size(); ++i) {
            ComponentNodeConfig childConfig = folderConfig.getComponents().get(i);
            this.printNode(componentConsoleState, childConfig, console, prefix);
            if (!(childConfig instanceof ComponentFolderConfig)) continue;
            this.printFolder(console, (ComponentFolderConfig)childConfig, componentConsoleState, prefix + "      ");
        }
    }

    private void printNode(ComponentConsoleState componentConsoleState, ComponentNodeConfig nodeConfig, Console console, String prefix) {
        boolean unchangeableNode;
        if (nodeConfig.isHidden()) {
            if (nodeConfig.isSelected()) {
                componentConsoleState.mandatoryComponents.add(nodeConfig);
            }
            return;
        }
        boolean bl = unchangeableNode = nodeConfig instanceof ComponentConfig && !((ComponentConfig)nodeConfig).isChangeable();
        if (!unchangeableNode || nodeConfig.isSelected()) {
            console.print(prefix + (unchangeableNode ? "*" : String.valueOf(componentConsoleState.index)) + ": " + nodeConfig.getName());
            if (!nodeConfig.getDescription().isEmpty()) {
                console.print(" [*" + componentConsoleState.index + "]");
                componentConsoleState.helpIndexToComponentNodeConfig.put(componentConsoleState.index, nodeConfig);
            }
            console.println();
            if (nodeConfig instanceof ComponentFolderConfig) {
                nodeConfig.setSelected(false);
            }
            if (unchangeableNode) {
                componentConsoleState.mandatoryComponents.add(nodeConfig);
            } else {
                if (nodeConfig.isSelected()) {
                    componentConsoleState.defaultConsoleSelection = componentConsoleState.defaultConsoleSelection == null ? "" : componentConsoleState.defaultConsoleSelection + ",";
                    componentConsoleState.defaultConsoleSelection = componentConsoleState.defaultConsoleSelection + componentConsoleState.index;
                }
                componentConsoleState.indexToComponentNodeConfig.put(componentConsoleState.index, nodeConfig);
            }
            ++componentConsoleState.index;
        }
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        String headerMessage = this.getMessage("SelectComponentsLabel2");
        if (headerMessage.trim().length() > 0) {
            this.addDisplayTextArea(Messages.format(headerMessage, this.getApplicationName()), panel, gc);
        }
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.fill = 1;
        panel.add((Component)this.scpTree, gc);
        ++gc.gridy;
        gc.weighty = 0.0;
        if (this.showInstallationDirectoryChooser) {
            gc.gridwidth = 1;
            gc.gridx = 0;
            gc.weightx = 0.0;
            gc.anchor = 512;
            gc.insets.right = 5;
            panel.add((Component)this.destinationLabel, gc);
            gc.insets.right = 0;
            gc.gridx = 1;
            gc.weightx = 1.0;
            panel.add((Component)this.installationDirectorySelector, gc);
        }
    }

    @Override
    protected int getMaxGridWidth() {
        return 2;
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.tree = new InstallationComponentTree(this);
        this.scpTree = new JScrollPane(this.tree);
        this.destinationLabel = new JLabel(this.getMessage("ReadyMemoDir"));
        if (this.showInstallationDirectoryChooser) {
            this.installationDirectorySelector.createComponent();
        }
    }

    public void nodeToggled() {
        if (this.isShowInstallationDirectoryChooser()) {
            this.installationDirectorySelector.update();
        }
    }

    public void selectionChanged(ComponentNode componentNode, boolean dependency) {
        ComponentNodeConfig componentNodeConfig = componentNode.getComponentNodeConfig();
        if (componentNodeConfig instanceof ComponentConfig) {
            ComponentConfig componentConfig = (ComponentConfig)componentNodeConfig;
            Context context = this.getContext();
            InstallationComponentSetup installationComponentSetup = context.getInstallationComponentById(componentConfig.getId());
            try {
                context.runScript(this.selectionChangedScript, this, new Object[]{installationComponentSetup, dependency});
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
            }
        }
    }

    private class ComponentConsoleState {
        public int index = 1;
        public String defaultConsoleSelection;
        public Map<Integer, ComponentNodeConfig> indexToComponentNodeConfig = new LinkedHashMap<Integer, ComponentNodeConfig>();
        public Map<Integer, ComponentNodeConfig> helpIndexToComponentNodeConfig = new LinkedHashMap<Integer, ComponentNodeConfig>();
        public Set<ComponentNodeConfig> mandatoryComponents = new HashSet<ComponentNodeConfig>();

        private ComponentConsoleState() {
        }
    }
}

