/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.FileAssociationsScreen;
import com.install4j.runtime.beans.screens.SystemScreen;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public abstract class ChecklistScreen
extends SystemScreen {
    private JScrollPane scpChecklist;
    protected JPanel checklistPanel;
    protected List<FileAssociationsScreen.SingleAssociationPanel> singleCheckPanels = new ArrayList<FileAssociationsScreen.SingleAssociationPanel>();
    private boolean checkListPanelFilled = false;

    protected void save() {
        for (FileAssociationsScreen.SingleAssociationPanel singleCheckPanel : this.singleCheckPanels) {
            singleCheckPanel.save();
        }
    }

    @Override
    public boolean next() {
        this.save();
        return super.next();
    }

    @Override
    public void willActivate() {
        super.willActivate();
        if (!this.checkListPanelFilled) {
            this.checkListPanelFilled = true;
            this.fillChecklistPanel();
        }
    }

    @Override
    public boolean handleUnattended() {
        this.setupControls();
        this.fillChecklistPanel();
        this.save();
        return true;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        this.setupControls();
        this.fillChecklistPanel();
        console.println(this.getSubTitle());
        for (FileAssociationsScreen.SingleAssociationPanel singleCheckPanel : this.singleCheckPanels) {
            singleCheckPanel.handleConsole(console);
        }
        this.save();
        return true;
    }

    protected void printDescription(Console console) {
        console.println(this.getSubTitle());
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.checklistPanel = new JPanel();
        this.scpChecklist = new JScrollPane(this.checklistPanel);
        JScrollBar verticalScrollBar = this.scpChecklist.getVerticalScrollBar();
        verticalScrollBar.setUnitIncrement(10);
        verticalScrollBar.setBlockIncrement(50);
        JScrollBar horizontalScrollBar = this.scpChecklist.getHorizontalScrollBar();
        horizontalScrollBar.setUnitIncrement(10);
        horizontalScrollBar.setBlockIncrement(50);
        this.scpChecklist.setBorder(null);
        this.scpChecklist.setViewportBorder(null);
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        panel.add((Component)this.scpChecklist, gc);
    }

    private void fillChecklistPanel() {
        this.checklistPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 21;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.insets = new Insets(3, 0, 3, 0);
        this.addSingleChecks(gc);
        gc.weighty = 1.0;
        gc.fill = 1;
        this.checklistPanel.add((Component)new JPanel(), gc);
    }

    protected abstract void addSingleChecks(GridBagConstraints var1);

    protected abstract class SingleCheckPanel
    extends JPanel {
        protected JCheckBox chkSingle;

        protected SingleCheckPanel() {
        }

        public void save() {
        }

        public void handleConsole(Console console) throws UserCanceledException {
            if (this.chkSingle != null) {
                this.chkSingle.setSelected(console.askYesNo(this.chkSingle.getText(), this.chkSingle.isSelected()));
            }
        }
    }
}

