/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.splash;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.splash.TextLineConfig;
import com.exe4j.runtime.util.ArgumentStack;

public class SplashScreenConfig {
    private boolean legacySplashScreen;
    private boolean show;
    private String bitmapName;
    private boolean alwaysOnTop;
    private boolean autoOff;
    private int width;
    private int height;
    private TextLineConfig statusLineConfig;
    private TextLineConfig versionLineConfig;
    private int splashVersion;
    private boolean eval;
    private boolean textOverlay;

    public SplashScreenConfig init(ArgumentStack argStack, boolean eval) {
        this.legacySplashScreen = argStack.popBoolean();
        if (this.legacySplashScreen) {
            this.show = argStack.popBoolean();
            this.bitmapName = argStack.popString();
            this.alwaysOnTop = argStack.popBoolean();
            this.autoOff = argStack.popBoolean();
            this.width = argStack.popInt();
            this.height = argStack.popInt();
            this.statusLineConfig = new TextLineConfig(argStack);
            this.versionLineConfig = new TextLineConfig(argStack);
            this.textOverlay = this.show;
        }
        this.eval = eval;
        return this;
    }

    public SplashScreenConfig initFromLauncherEngine() {
        this.show = LauncherEngine.getBooleanProperty(108);
        this.bitmapName = LauncherEngine.getProperty(10002);
        this.alwaysOnTop = LauncherEngine.getBooleanProperty(147);
        this.autoOff = LauncherEngine.getBooleanProperty(145);
        this.width = LauncherEngine.getIntProperty(141);
        this.height = LauncherEngine.getIntProperty(142);
        this.statusLineConfig = new TextLineConfig(10109);
        this.versionLineConfig = new TextLineConfig(10116);
        this.splashVersion = LauncherEngine.getIntProperty(164);
        this.eval = LauncherEngine.getBooleanProperty(148);
        this.legacySplashScreen = this.splashVersion == 0 && !LauncherEngine.getBooleanProperty(10123);
        this.textOverlay = this.legacySplashScreen || LauncherEngine.getBooleanProperty(163);
        return this;
    }

    public SplashScreenConfig init(boolean eval, boolean textOverlay, TextLineConfig statusLineConfig, TextLineConfig versionLineConfig) {
        this.show = true;
        this.eval = eval;
        this.textOverlay = textOverlay;
        this.statusLineConfig = statusLineConfig;
        this.versionLineConfig = versionLineConfig;
        return this;
    }

    public boolean isTextOverlay() {
        return this.textOverlay;
    }

    public boolean isLegacySplashScreen() {
        return this.legacySplashScreen;
    }

    public boolean isShow() {
        return this.show;
    }

    public String getBitmapName() {
        return this.bitmapName;
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public boolean isAutoOff() {
        return this.autoOff;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public TextLineConfig getStatusLineConfig() {
        return this.statusLineConfig;
    }

    public TextLineConfig getVersionLineConfig() {
        return this.versionLineConfig;
    }

    public int getSplashVersion() {
        return this.splashVersion;
    }

    public boolean isEval() {
        return this.eval;
    }
}

