/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.NoSuchElementException;

public final class SocketUtil {
    public static final int MIN_PORT_NUMBER = 1100;
    public static final int MAX_PORT_NUMBER = 49151;

    public static synchronized int getNextAvailablePort(int fromPort) {
        int n2;
        if (fromPort < 1100 || fromPort > 49151) {
            throw new IllegalArgumentException("The fromPort parameter value is not in the (MIN_PORT_NUMBER <= fromPort <= MAX_PORT_NUMBER) range. Value: " + fromPort);
        }
        for (int i2 = fromPort + 1; i2 < 49151; ++i2) {
            if (!SocketUtil.available(i2)) continue;
            return i2;
        }
        throw new NoSuchElementException("Could not find an available port above " + n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean available(int port) {
        if (port < 1100) throw new IllegalArgumentException("Invalid start port: " + port);
        if (port > 49151) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket serverSocket = null;
        DatagramSocket datagramSocket = null;
        try {
            int n2;
            InetAddress inetAddress = InetAddress.getByName("127.0.0.1");
            serverSocket = new ServerSocket(port, 0, inetAddress);
            serverSocket.setReuseAddress(true);
            datagramSocket = new DatagramSocket(n2, inetAddress);
            datagramSocket.setReuseAddress(true);
            datagramSocket.close();
        }
        catch (SocketException socketException) {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (serverSocket == null) return false;
            try {
                serverSocket.close();
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        catch (IOException iOException) {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (serverSocket == null) return false;
            try {
                serverSocket.close();
                return false;
            }
            catch (IOException iOException2) {
                return false;
            }
        }
        catch (Throwable throwable) {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (serverSocket == null) throw throwable;
            try {
                serverSocket.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            serverSocket.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
    }
}

