/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.ColorModel;
import com.teamdev.jxbrowser.chromium.DuplexMode;
import com.teamdev.jxbrowser.chromium.PageMargins;
import com.teamdev.jxbrowser.chromium.PageRange;
import com.teamdev.jxbrowser.chromium.PaperSize;
import com.teamdev.jxbrowser.chromium.PrintSettings;
import java.util.ArrayList;
import java.util.List;

public class PrintDialogModel {
    public static final String SAVE_AS_PDF = "Save as PDF";
    public static final String LAYOUT_PORTRAIT = "Portrait";
    public static final String LAYOUT_LANDSCAPE = "Landscape";
    public static final String COLOR_MODE_COLOR = "Color";
    public static final String COLOR_MODE_BLACK_AND_WHITE = "Black and White";
    public static final String MARGIN_TYPE_DEFAULT = "Default";
    public static final String MARGIN_TYPE_CUSTOM = "Custom";
    private CloseStatus a;
    private final PrintSettings b;

    /*
     * WARNING - void declaration
     */
    public PrintDialogModel(PrintSettings settings) {
        void var1_1;
        this.b = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void printHeadersAndFooters(boolean print) {
        void var1_1;
        this.b.setDisplayHeaderFooter((boolean)var1_1);
    }

    public boolean isPrintHeadersAndFooters() {
        return this.b.isDisplayHeaderFooter();
    }

    /*
     * WARNING - void declaration
     */
    public void printBackgroundGraphics(boolean print) {
        void var1_1;
        this.b.setPrintBackgrounds((boolean)var1_1);
    }

    public boolean isPrintBackgroundGraphics() {
        return this.b.isPrintBackgrounds();
    }

    /*
     * WARNING - void declaration
     */
    public void printSelectionOnly(boolean print) {
        void var1_1;
        this.b.setPrintSelectionOnly((boolean)var1_1);
    }

    public void printTwoSided(boolean print) {
        if (print) {
            this.b.setDuplexMode(this.b.isLandscape() ? DuplexMode.SHORT_EDGE : DuplexMode.LONG_EDGE);
            return;
        }
        this.b.setDuplexMode(DuplexMode.SIMPLEX);
    }

    public boolean isPrintTwoSided() {
        return this.b.getDuplexMode() == DuplexMode.SHORT_EDGE;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrinterName(String printerName) {
        void var1_1;
        if (SAVE_AS_PDF.equals(printerName)) {
            this.b.setPrintToPDF(true);
            return;
        }
        this.b.setPrinterName((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPDFFilePath(String path) {
        void var1_1;
        this.b.setPDFFilePath((String)var1_1);
    }

    public String getPrinterName() {
        return this.b.getPrinterName();
    }

    public boolean isPrintToPDF() {
        return this.b.isPrintToPDF();
    }

    /*
     * WARNING - void declaration
     */
    public void setLandscape(boolean landscape) {
        void var1_1;
        this.b.setLandscape((boolean)var1_1);
        DuplexMode duplexMode = this.b.getDuplexMode();
        this.printTwoSided(duplexMode == DuplexMode.SHORT_EDGE || duplexMode == DuplexMode.LONG_EDGE);
    }

    public boolean isLandscape() {
        return this.b.isLandscape();
    }

    /*
     * WARNING - void declaration
     */
    public void setPaperSize(PaperSize paperSize) {
        void var1_1;
        this.b.setPaperSize((PaperSize)var1_1);
    }

    public PaperSize getPaperSize() {
        return this.b.getPaperSize();
    }

    /*
     * WARNING - void declaration
     */
    public void setCopies(int copies) {
        void var1_1;
        this.b.setCopies((int)var1_1);
    }

    public int getCopies() {
        return this.b.getCopies();
    }

    /*
     * WARNING - void declaration
     */
    public void setColorMode(boolean colorMode) {
        void var1_1;
        this.b.setColorModel(var1_1 != false ? ColorModel.COLOR : ColorModel.GRAY);
    }

    public boolean isColorMode() {
        return this.b.getColorModel() == ColorModel.COLOR;
    }

    public boolean isCustomMarginsEnabled() {
        return this.b.getPageMargins() != null;
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomMargins(int top, int right, int bottom, int left) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.b.setPageMargins(new PageMargins(0, 0, (int)var1_1, left, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomMargins(PageMargins margins) {
        void var1_1;
        this.b.setPageMargins((PageMargins)var1_1);
    }

    public PageMargins getCustomMargins() {
        return this.b.getPageMargins();
    }

    public void printAllPages() {
        this.b.setPageRanges(new ArrayList<PageRange>());
    }

    public boolean isPrintAllPages() {
        return this.b.getPageRanges() == null || this.b.getPageRanges().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public void printPageRanges(int from, int to) {
        if (to >= from) {
            void var2_2;
            void var1_1;
            ArrayList<PageRange> arrayList = new ArrayList<PageRange>();
            arrayList.add(new PageRange((int)(var1_1 - true), (int)(var2_2 - true)));
            this.b.setPageRanges(arrayList);
        }
    }

    public PageRange getPrintPageRange() {
        List<PageRange> list = this.b.getPageRanges();
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setCloseStatus(CloseStatus status) {
        void var1_1;
        this.a = var1_1;
    }

    public CloseStatus getCloseStatus() {
        return this.a;
    }

    public static enum CloseStatus {
        PRINT,
        CANCEL;

    }
}

