/*
 * Decompiled with CFR 0.152.
 */
package com.vp.plugin.model.property;

import com.vp.plugin.model.IModelElement;

public abstract class IModelProperty {
    public static final char TYPE_BOOLEAN = 'a';
    public static final char TYPE_INT = 'b';
    public static final char TYPE_MODEL_COLLECTION = 'c';
    public static final char TYPE_COMPOSITE_MODEL_COLLECTION = 'd';
    public static final char TYPE_MODEL = 'e';
    public static final char TYPE_COMPOSITE_MODEL = 'f';
    public static final char TYPE_STRING = 'g';
    public static final char TYPE_STRING_SELECTION = 'h';
    public static final char TYPE_HTML_STRING = 'i';
    public static final char TYPE_TEXT_MODEL = 'j';
    public static final char TYPE_TRANSIT_FROM = 'k';
    public static final char TYPE_TRANSIT_TO = 'l';
    public static final char TYPE_RELATIONSHIP_END = 'm';
    public static final char TYPE_END_RELATIONSHIP = 'n';
    public static final char TYPE_PARENT_MODEL = 'o';
    public static final char TYPE_CODE_SIGNATURE = 'p';
    public static final char TYPE_STRING_ARRAY = 'q';
    private final String _name;
    private final char _type;
    private final IModelElement _owner;

    public IModelProperty(String string, char c, IModelElement iModelElement) {
        this._name = string;
        this._type = c;
        this._owner = iModelElement;
    }

    public String getName() {
        return this._name;
    }

    public char getType() {
        return this._type;
    }

    public IModelElement getOwner() {
        return this._owner;
    }

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public boolean getValueAsBoolean() {
        return (Boolean)this.getValue();
    }

    public int getValueAsInt() {
        return (Integer)this.getValue();
    }

    public String getValueAsString() {
        return (String)this.getValue();
    }

    public IModelElement getValueAsModel() {
        return (IModelElement)this.getValue();
    }

    public IModelElement[] getValueAsModelCollection() {
        return (IModelElement[])this.getValue();
    }

    public String[] getValueAsStringArray() {
        return (String[])this.getValue();
    }

    public void setValue(boolean bl) {
        this.setValue(new Boolean(bl));
    }

    public void setValue(int n) {
        this.setValue(new Integer(n));
    }

    public void setValue(long l) {
        this.setValue(new Long(l));
    }

    public void setValue(double d) {
        this.setValue(new Double(d));
    }

    public void setValue(String[] stringArray) {
        this.setValue(stringArray);
    }

    public abstract boolean isAllowModify();

    protected final void checkAllowModify() {
        if (!this.isAllowModify()) {
            throw new UnsupportedOperationException("Does not allow modifying this property.");
        }
    }
}

