/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.ImageSource;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;

public abstract class AbstractImageSessionContext
implements ImageSessionContext {
    private static Log log;
    private static boolean noSourceReuse;
    private SoftMapCache sessionSources = new SoftMapCache(false);
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract Source resolveURI(String var1);

    public Source newSource(String uri) {
        URL url;
        Source source = this.resolveURI(uri);
        if (source == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("URI could not be resolved: " + uri));
            }
            return null;
        }
        if (!(source instanceof StreamSource) && !(source instanceof SAXSource)) {
            return source;
        }
        ImageSource imageSource = null;
        String resolvedURI = source.getSystemId();
        try {
            url = new URL(resolvedURI);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        File f = AbstractImageSessionContext.toFile(url);
        if (f != null) {
            boolean directFileAccess = true;
            if (!($assertionsDisabled || source instanceof StreamSource || source instanceof SAXSource)) {
                throw new AssertionError();
            }
            InputStream in = ImageUtil.getInputStream(source);
            if (in == null) {
                try {
                    in = new FileInputStream(f);
                }
                catch (FileNotFoundException fnfe) {
                    log.error((Object)("Error while opening file. Could not load image from system identifier '" + source.getSystemId() + "' (" + fnfe.getMessage() + ")"));
                    return null;
                }
            }
            if (in != null) {
                in = ImageUtil.decorateMarkSupported(in);
                try {
                    if (ImageUtil.isGZIPCompressed(in)) {
                        directFileAccess = false;
                    }
                }
                catch (IOException ioe) {
                    log.error((Object)("Error while checking the InputStream for GZIP compression. Could not load image from system identifier '" + source.getSystemId() + "' (" + ioe.getMessage() + ")"));
                    return null;
                }
            }
            if (directFileAccess) {
                IOUtils.closeQuietly(in);
                try {
                    imageSource = new ImageSource(ImageIO.createImageInputStream(f), resolvedURI, true);
                }
                catch (IOException ioe) {
                    log.error((Object)("Unable to create ImageInputStream for local file from system identifier '" + source.getSystemId() + "' (" + ioe.getMessage() + ")"));
                }
            }
        }
        if (imageSource == null) {
            if (ImageUtil.hasReader(source) && !ImageUtil.hasInputStream(source)) {
                return source;
            }
            InputStream in = ImageUtil.getInputStream(source);
            if (in == null && url != null) {
                try {
                    in = url.openStream();
                }
                catch (Exception ex) {
                    log.error((Object)("Unable to obtain stream from system identifier '" + source.getSystemId() + "'"));
                }
            }
            if (in == null) {
                log.error((Object)("The Source that was returned from URI resolution didn't contain an InputStream for URI: " + uri));
                return null;
            }
            try {
                in = ImageUtil.autoDecorateInputStream(in);
                imageSource = new ImageSource(ImageIO.createImageInputStream(in), source.getSystemId(), false);
            }
            catch (IOException ioe) {
                log.error((Object)("Unable to create ImageInputStream for InputStream from system identifier '" + source.getSystemId() + "' (" + ioe.getMessage() + ")"));
            }
        }
        return imageSource;
    }

    public static File toFile(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = "";
        if (url.getHost() != null) {
            filename = filename + Character.toString(File.separatorChar) + Character.toString(File.separatorChar) + url.getHost();
        }
        filename = filename + url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    public Source getSource(String uri) {
        return (Source)this.sessionSources.remove(uri);
    }

    public Source needSource(String uri) throws FileNotFoundException {
        Source src = this.getSource(uri);
        if (src == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating new Source for " + uri));
            }
            if ((src = this.newSource(uri)) == null) {
                throw new FileNotFoundException("Image not found: " + uri);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Reusing Source for " + uri));
        }
        return src;
    }

    public void returnSource(String uri, Source src) {
        ImageInputStream in = ImageUtil.getImageInputStream(src);
        try {
            if (in != null && in.getStreamPosition() != 0L) {
                throw new IllegalStateException("ImageInputStream is not reset for: " + uri);
            }
        }
        catch (IOException ioe) {
            ImageUtil.closeQuietly(src);
        }
        if (this.isReusable(src)) {
            log.debug((Object)("Returning Source for " + uri));
            this.sessionSources.put(uri, src);
        } else {
            ImageUtil.closeQuietly(src);
        }
    }

    protected boolean isReusable(Source src) {
        ImageSource is;
        if (noSourceReuse) {
            return false;
        }
        if (src instanceof ImageSource && (is = (ImageSource)src).getImageInputStream() != null) {
            return true;
        }
        return src instanceof DOMSource;
    }

    static {
        $assertionsDisabled = !AbstractImageSessionContext.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)AbstractImageSessionContext.class);
        noSourceReuse = false;
        String v = System.getProperty(AbstractImageSessionContext.class.getName() + ".no-source-reuse");
        noSourceReuse = Boolean.valueOf(v);
    }
}

