/*
 * Decompiled with CFR 0.152.
 */
package org.orm.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.Getter;
import org.orm.util.comparator.DefaultComparator;

public class ArraySorter
implements Comparator {
    private final String _propertyName;
    private Method _getter;
    private Comparator _comparator;
    private boolean _ascending = true;
    private static Object[] EMPTY_VALUE = new Object[0];

    public ArraySorter(String string) {
        this._propertyName = string;
    }

    public ArraySorter(String string, boolean bl) {
        this(string);
        this._ascending = bl;
    }

    protected ArraySorter(Class clazz, String string) {
        this(string);
        this.prepareGetter(clazz);
    }

    protected ArraySorter(Class clazz, String string, boolean bl) {
        this(string);
        this._ascending = bl;
        this.prepareGetter(clazz);
    }

    public void prepareGetter(Class clazz) {
        Method method;
        Getter getter = ReflectHelper.getGetter(clazz, this._propertyName);
        this._getter = method = getter.getMethod();
        Class<Comparable> clazz2 = Comparable.class;
        Class clazz3 = method.getReturnType();
        if (clazz3.isPrimitive()) {
            clazz3 = this.getWrapperClass(clazz3);
        }
        if (clazz2.isAssignableFrom(clazz3)) {
            this._comparator = new DefaultComparator(this._ascending);
        }
    }

    private Class getWrapperClass(Class clazz) {
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.class;
        }
        throw new RuntimeException("No wrapper class found from " + clazz.getName());
    }

    public int compare(Object object, Object object2) {
        if (this._getter == null) {
            this.prepareGetter(object.getClass());
        } else if (this._comparator == null) {
            throw new RuntimeException("Missing Comparator for type: " + object.getClass().getName());
        }
        try {
            Object object3 = this._getter.invoke(object, EMPTY_VALUE);
            Object object4 = this._getter.invoke(object2, EMPTY_VALUE);
            return this._comparator.compare(object3, object4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getMessage());
        }
    }

    public static void main(String[] stringArray) throws SecurityException, NoSuchMethodException {
        ArrayList<TestObject> arrayList = new ArrayList<TestObject>();
        arrayList.add(new TestObject(500));
        arrayList.add(new TestObject(4));
        arrayList.add(new TestObject(8));
        arrayList.add(new TestObject(2));
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray, new ArraySorter(TestObject.class, "value", false));
        for (int i = 0; i < objectArray.length; ++i) {
            System.out.println("e: " + objectArray[i]);
        }
    }

    private static class TestObject {
        int _value;

        public TestObject(int n) {
            this._value = n;
        }

        public int getValue() {
            return this._value;
        }

        public String toString() {
            return "Value: " + this._value;
        }
    }
}

