/*
 * Decompiled with CFR 0.152.
 */
package org.orm.util;

import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.orm.PersistentException;
import org.orm.PersistentSession;
import org.orm.util.ORMSessionFactory;
import org.orm.util.SessionController;

public class AppBaseSessionController
implements SessionController {
    private ORMSessionFactory _sessionFactory = null;
    private PersistentSession _session = null;
    private CloseSessionThread _closeSessionThread;

    public AppBaseSessionController(Configuration configuration, int n) throws PersistentException {
        try {
            this._sessionFactory = new ORMSessionFactory(configuration);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException("Failed to create AppBaseSessionController", hibernateException);
        }
        this._closeSessionThread = new CloseSessionThread(n);
        this._closeSessionThread.start();
    }

    public synchronized PersistentSession getSession() throws PersistentException {
        return this.getSession(true);
    }

    public synchronized PersistentSession getSession(boolean bl) throws PersistentException {
        this._closeSessionThread.reset();
        if ((this._session == null || !this._session.isOpen()) && bl) {
            try {
                this._session = new PersistentSession(this._sessionFactory.createSession(), this._sessionFactory.getCfg());
            }
            catch (HibernateException hibernateException) {
                throw new PersistentException("Failed to create PersistentSession", hibernateException);
            }
        }
        return this._session;
    }

    public void disposeSession() throws PersistentException {
        if (this._session != null) {
            this._session.close();
            this._session = null;
        }
        this._sessionFactory.close();
    }

    private class CloseSessionThread
    extends Thread {
        private long startTime;
        private final int ttl;

        public CloseSessionThread(int n) {
            this.ttl = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (System.currentTimeMillis() - this.startTime > (long)this.ttl) {
                            AppBaseSessionController appBaseSessionController = AppBaseSessionController.this;
                            synchronized (appBaseSessionController) {
                                PersistentSession persistentSession = AppBaseSessionController.this.getSession(false);
                                if (persistentSession != null) {
                                    persistentSession.close();
                                }
                            }
                        }
                        Thread.sleep((long)this.ttl - (System.currentTimeMillis() - this.startTime));
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        public synchronized void start() {
            this.reset();
            super.start();
        }

        public void reset() {
            this.startTime = System.currentTimeMillis();
        }
    }
}

