/*
 * Decompiled with CFR 0.152.
 */
package org.orm.util;

import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.orm.PersistentException;
import org.orm.PersistentSession;
import org.orm.util.ORMSessionFactory;
import org.orm.util.SessionController;

public class AdvancedAppBaseSessionController
implements SessionController {
    private ORMSessionFactory _sessionFactory = null;
    private PersistentSession _session = null;

    public AdvancedAppBaseSessionController(Configuration configuration) throws PersistentException {
        try {
            this._sessionFactory = new ORMSessionFactory(configuration);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException("Failed to create AdvancedAppBaseSessionController", hibernateException);
        }
    }

    public synchronized PersistentSession getSession() throws PersistentException {
        return this.getSession(true);
    }

    public synchronized PersistentSession getSession(boolean bl) throws PersistentException {
        if ((this._session == null || !this._session.isOpen()) && bl) {
            try {
                this._session = new PersistentSession(this._sessionFactory.createSession(), this._sessionFactory.getCfg());
            }
            catch (HibernateException hibernateException) {
                throw new PersistentException("Failed to create PersistentSession", hibernateException);
            }
        }
        return this._session;
    }

    public void disposeSession() throws PersistentException {
        if (this._session != null) {
            this._session.close();
            this._session = null;
        }
        this._sessionFactory.close();
    }
}

