/*
 * Decompiled with CFR 0.152.
 */
package org.orm.http;

import java.util.Collection;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.hibernate.LockMode;
import org.orm.PersistentException;
import org.orm.PersistentManager;

public class ORMHttpSession
implements HttpSession {
    private HttpSession _httpSession;
    private final PersistentManager _persistentManager;

    public ORMHttpSession(PersistentManager persistentManager, HttpSession httpSession) {
        this._persistentManager = persistentManager;
        this._httpSession = httpSession;
    }

    private Object lockObject(Object object) {
        if (this._persistentManager.isObjectPersistable(object)) {
            try {
                this._persistentManager.getSession().lock(object, LockMode.NONE);
            }
            catch (PersistentException persistentException) {}
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!this._persistentManager.isObjectPersistable(objectArray[i])) continue;
                    this._persistentManager.getSession().lock(objectArray[i], LockMode.NONE);
                }
            }
            catch (PersistentException persistentException) {}
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            try {
                for (Object e : collection) {
                    if (!this._persistentManager.isObjectPersistable(e)) continue;
                    this._persistentManager.getSession().lock(e, LockMode.NONE);
                }
            }
            catch (PersistentException persistentException) {
                // empty catch block
            }
        }
        return object;
    }

    public Object getAttribute(String string) {
        return this.lockObject(this._httpSession.getAttribute(string));
    }

    public Enumeration getAttributeNames() {
        return this._httpSession.getAttributeNames();
    }

    public long getCreationTime() {
        return this._httpSession.getCreationTime();
    }

    public String getId() {
        return this._httpSession.getId();
    }

    public long getLastAccessedTime() {
        return this._httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this._httpSession.getMaxInactiveInterval();
    }

    public ServletContext getServletContext() {
        return this._httpSession.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return this._httpSession.getSessionContext();
    }

    public Object getValue(String string) {
        return this.lockObject(this._httpSession.getValue(string));
    }

    public String[] getValueNames() {
        return this._httpSession.getValueNames();
    }

    public void invalidate() {
        this._httpSession.invalidate();
    }

    public boolean isNew() {
        return this._httpSession.isNew();
    }

    public void putValue(String string, Object object) {
        this._httpSession.putValue(string, object);
    }

    public void removeAttribute(String string) {
        this._httpSession.removeAttribute(string);
    }

    public void removeValue(String string) {
        this._httpSession.removeValue(string);
    }

    public void setAttribute(String string, Object object) {
        this._httpSession.setAttribute(string, object);
    }

    public void setMaxInactiveInterval(int n) {
        this._httpSession.setMaxInactiveInterval(n);
    }
}

