/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SybaseDialect;
import org.jboss.logging.Logger;
import org.orm.ertodb.DialectDBTypeMapper;
import org.orm.ertodb.metadata.ColumnMetadata;
import org.orm.ertodb.metadata.ForeignKeyMetadata;
import org.orm.ertodb.metadata.IndexMetadata;
import org.orm.ertodb.metadata.UniqueConstraintMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMetadata {
    private static final Logger LOG = Logger.getLogger(TableMetadata.class.getName());
    private String catalog;
    private final String schema;
    private final String name;
    private String remarks;
    protected final Map<String, ColumnMetadata> columns = new HashMap<String, ColumnMetadata>();
    private final Map<String, ForeignKeyMetadata> foreignKeys = new HashMap<String, ForeignKeyMetadata>();
    private final Map<String, ForeignKeyMetadata> exportedForeignKeys = new HashMap<String, ForeignKeyMetadata>();
    private final Map<String, IndexMetadata> indexes = new HashMap<String, IndexMetadata>();
    private final List<String> indexNames = new ArrayList<String>();
    private String pkConstraint = null;
    private final List<String> primaryKeyColumns = new ArrayList<String>();
    private final Dialect _dialect;
    private final Connection _connection;
    private boolean _canGetIndex = true;
    private boolean _hasFullTextIndex = false;

    TableMetadata(ResultSet resultSet, DatabaseMetaData databaseMetaData, Connection connection, Dialect dialect) throws SQLException {
        this._connection = connection;
        this._dialect = dialect;
        this.catalog = resultSet.getString("TABLE_CAT");
        this.schema = resultSet.getString("TABLE_SCHEM");
        this.name = resultSet.getString("TABLE_NAME");
        this.remarks = resultSet.getString("REMARKS");
        this.initColumns(databaseMetaData);
        try {
            this.initPrimaryKeys(databaseMetaData);
        }
        catch (SQLException sQLException) {
            this._canGetIndex = false;
            LOG.warn("Cannot get primary key");
        }
        try {
            this.initIndexes(databaseMetaData);
        }
        catch (SQLException sQLException) {
            this._canGetIndex = false;
            LOG.warn("Cannot get index");
        }
        try {
            this.initForeignKeys(databaseMetaData);
        }
        catch (SQLException sQLException) {
            LOG.warn("Cannot resolve foreign key contents");
        }
    }

    public boolean isCanGetIndex() {
        return this._canGetIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPrimaryKeys(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getPrimaryKeys(null, this.schema, this.name);
            while (resultSet.next()) {
                String string = resultSet.getString("COLUMN_NAME");
                this.primaryKeyColumns.add(string.toLowerCase());
                this.pkConstraint = resultSet.getString("PK_NAME");
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initForeignKeys(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getImportedKeys(null, this.schema, this.name);
            while (resultSet.next()) {
                this.addForeignKey(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        try {
            resultSet = databaseMetaData.getExportedKeys(null, this.schema, this.name);
            while (resultSet.next()) {
                this.addExportedForeignKey(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public ColumnMetadata getColumnMetadata(String string) {
        return this.columns.get(string.toLowerCase());
    }

    public String[] getAllColumnsName() {
        return this.columns.keySet().toArray(new String[this.columns.size()]);
    }

    public void addColumn(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("COLUMN_NAME");
        if (string == null) {
            return;
        }
        if (this.getColumnMetadata(string) == null) {
            ColumnMetadata columnMetadata = new ColumnMetadata(resultSet);
            this.columns.put(columnMetadata.getName().toLowerCase(), columnMetadata);
        }
    }

    public ForeignKeyMetadata getForeignKeyMetadata(String string) {
        return this.foreignKeys.get(string.toUpperCase());
    }

    public String[] getForeignKeys() {
        return this.foreignKeys.keySet().toArray(new String[this.foreignKeys.size()]);
    }

    public ForeignKeyMetadata getExportedForeignKeyMetadata(String string) {
        return this.exportedForeignKeys.get(string.toUpperCase());
    }

    public String[] getExportedForeignKeys() {
        return this.exportedForeignKeys.keySet().toArray(new String[this.exportedForeignKeys.size()]);
    }

    public String getPkConstraint() {
        return this.pkConstraint;
    }

    public String[] getPrimaryKeyColumns() {
        return this.primaryKeyColumns.toArray(new String[this.primaryKeyColumns.size()]);
    }

    public IndexMetadata getIndexMetadata(String string) {
        return this.indexes.get(string.toLowerCase());
    }

    private void addForeignKey(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("PKTABLE_NAME");
        String string2 = resultSet.getString("PKTABLE_SCHEM");
        String string3 = resultSet.getString("FKTABLE_NAME");
        String string4 = resultSet.getString("FKTABLE_SCHEM");
        String string5 = this.getFKName(resultSet);
        if (string5 == null) {
            return;
        }
        ForeignKeyMetadata foreignKeyMetadata = this.getForeignKeyMetadata(string5);
        if (foreignKeyMetadata == null) {
            foreignKeyMetadata = new ForeignKeyMetadata(string5, string, string2, string3, string4);
            this.foreignKeys.put(foreignKeyMetadata.getName().toUpperCase(), foreignKeyMetadata);
        }
        foreignKeyMetadata.addColumn(this.getColumnMetadata(resultSet.getString("FKCOLUMN_NAME")));
    }

    private String getFKName(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("FK_NAME");
        if (string == null && this._dialect instanceof SybaseDialect) {
            PreparedStatement preparedStatement = this._connection.prepareStatement("select o.name as FK_NAME from sysreferences r left join syscolumns c on c.id = r.tableid and c.colid = r.fokey1 left join sysobjects o on r.constrid = o.id left join sysobjects o2 on r.tableid = o2.id where c.name = ? and o2.name = ?");
            preparedStatement.setString(1, resultSet.getString("FKCOLUMN_NAME"));
            preparedStatement.setString(2, this.name);
            ResultSet resultSet2 = preparedStatement.executeQuery();
            if (resultSet2.next()) {
                string = resultSet2.getString("FK_NAME");
            }
            resultSet2.close();
            preparedStatement.close();
        }
        return string;
    }

    private void addExportedForeignKey(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("PKTABLE_NAME");
        String string2 = resultSet.getString("PKTABLE_SCHEM");
        String string3 = resultSet.getString("FKTABLE_NAME");
        String string4 = resultSet.getString("FKTABLE_SCHEM");
        String string5 = this.getFKName(resultSet);
        if (string5 == null) {
            return;
        }
        ForeignKeyMetadata foreignKeyMetadata = this.getExportedForeignKeyMetadata(string5);
        if (foreignKeyMetadata == null) {
            foreignKeyMetadata = new ForeignKeyMetadata(string5, string, string2, string3, string4);
            this.exportedForeignKeys.put(foreignKeyMetadata.getName().toUpperCase(), foreignKeyMetadata);
        }
        foreignKeyMetadata.addColumn(this.getColumnMetadata(resultSet.getString("FKCOLUMN_NAME")));
    }

    private void addIndex(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("INDEX_NAME");
        if (string == null) {
            return;
        }
        IndexMetadata indexMetadata = this.getIndexMetadata(string);
        if (indexMetadata == null) {
            indexMetadata = new IndexMetadata(resultSet);
            this.indexes.put(indexMetadata.getName().toLowerCase(), indexMetadata);
            this.indexNames.add(indexMetadata.getName());
        }
        indexMetadata.addColumn(this.getColumnMetadata(resultSet.getString("COLUMN_NAME")));
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getColumns(null, this.getSchema(), this.getName(), "%");
            while (resultSet.next()) {
                this.addColumn(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndexes(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getIndexInfo(this.catalog, this.schema, this.name, false, true);
            while (resultSet.next()) {
                if (resultSet.getShort("TYPE") == 0) continue;
                this.addIndex(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        int n = DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName());
        if (n == 8 || n == 0x200000) {
            String string = "select unique_index_id from sys.fulltext_indexes ftidx where ftidx.object_id = object_id(?)";
            PreparedStatement preparedStatement = this._connection.prepareStatement(string);
            try {
                preparedStatement.setString(1, this.schema == null || this.schema.length() == 0 ? this.name : this.schema + "." + this.name);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    this._hasFullTextIndex = true;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                preparedStatement.close();
            }
        }
    }

    public List<String> getIndexNames() {
        return new ArrayList<String>(this.indexNames);
    }

    public List<String> getUniqueConstraintNames() {
        int n = DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName());
        if (n == 8 || n == 0x200000) {
            try {
                PreparedStatement preparedStatement = this._connection.prepareStatement("select CONSTRAINT_NAME from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where CONSTRAINT_TYPE = 'UNIQUE' and TABLE_NAME = ?");
                preparedStatement.setString(1, this.name);
                ResultSet resultSet = preparedStatement.executeQuery();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("CONSTRAINT_NAME"));
                }
                resultSet.close();
                preparedStatement.close();
                return arrayList;
            }
            catch (Exception exception) {
                LOG.warn(exception);
            }
        } else if (n == 16) {
            try {
                PreparedStatement preparedStatement = this._connection.prepareStatement("select constraint_name from user_constraints where constraint_type = 'U' and table_name = ?");
                preparedStatement.setString(1, this.name);
                ResultSet resultSet = preparedStatement.executeQuery();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("constraint_name"));
                }
                resultSet.close();
                preparedStatement.close();
                return arrayList;
            }
            catch (Exception exception) {
                LOG.warn(exception);
            }
        } else if (n == 2 || n == 0x100000 || n == 0x1000000) {
            List<String> list = this.getIndexNames();
            if (!list.isEmpty()) {
                String[] stringArray = this.getForeignKeys();
                block6: for (int i = 0; i < stringArray.length; ++i) {
                    for (int j = 0; j < list.size(); ++j) {
                        if (!list.get(j).equalsIgnoreCase(stringArray[i])) continue;
                        list.remove(j);
                        continue block6;
                    }
                }
            }
            list.remove("PRIMARY");
            return list;
        }
        return new ArrayList<String>();
    }

    public UniqueConstraintMetadata getUniqueConstraintMetadata(String string) {
        int n = DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName());
        if (n == 8 || n == 0x200000) {
            try {
                PreparedStatement preparedStatement = this._connection.prepareStatement("select COLUMN_NAME from INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE where TABLE_NAME = ? and CONSTRAINT_NAME = ?");
                preparedStatement.setString(1, this.name);
                preparedStatement.setString(2, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                UniqueConstraintMetadata uniqueConstraintMetadata = new UniqueConstraintMetadata(string);
                while (resultSet.next()) {
                    uniqueConstraintMetadata.addColumn(this.getColumnMetadata(resultSet.getString("COLUMN_NAME")));
                }
                resultSet.close();
                preparedStatement.close();
                return uniqueConstraintMetadata;
            }
            catch (Exception exception) {
                LOG.warn(exception);
            }
        } else if (n == 16) {
            try {
                PreparedStatement preparedStatement = this._connection.prepareStatement("select column_name from user_cons_columns where table_name = ? and constraint_name = ? order by position");
                preparedStatement.setString(1, this.name);
                preparedStatement.setString(2, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                UniqueConstraintMetadata uniqueConstraintMetadata = new UniqueConstraintMetadata(string);
                while (resultSet.next()) {
                    uniqueConstraintMetadata.addColumn(this.getColumnMetadata(resultSet.getString("column_name")));
                }
                resultSet.close();
                preparedStatement.close();
                return uniqueConstraintMetadata;
            }
            catch (Exception exception) {
                LOG.warn(exception);
            }
        } else if (n == 2 || n == 0x100000 || n == 0x1000000) {
            IndexMetadata indexMetadata = this.getIndexMetadata(string);
            UniqueConstraintMetadata uniqueConstraintMetadata = new UniqueConstraintMetadata(indexMetadata.getName());
            ColumnMetadata[] columnMetadataArray = indexMetadata.getColumns();
            for (int i = 0; i < columnMetadataArray.length; ++i) {
                uniqueConstraintMetadata.addColumn(columnMetadataArray[i]);
            }
        }
        return null;
    }

    public boolean hasFullTextIndex() {
        return this._hasFullTextIndex;
    }

    public ForeignKeyMetadata[] getForeignKeyMetadataByColumn(ColumnMetadata columnMetadata) {
        ArrayList<ForeignKeyMetadata> arrayList = null;
        Collection<ForeignKeyMetadata> collection = this.foreignKeys.values();
        block0: for (ForeignKeyMetadata foreignKeyMetadata : collection) {
            ColumnMetadata[] columnMetadataArray;
            for (ColumnMetadata columnMetadata2 : columnMetadataArray = foreignKeyMetadata.getColumns()) {
                if (columnMetadata2 != columnMetadata) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<ForeignKeyMetadata>();
                }
                arrayList.add(foreignKeyMetadata);
                continue block0;
            }
        }
        return arrayList == null ? null : collection.toArray(new ForeignKeyMetadata[collection.size()]);
    }
}

