/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.orm.ertodb.DialectDBTypeMapper;
import org.orm.ertodb.metadata.DB2TableMetadata;
import org.orm.ertodb.metadata.MySQLTableMetadata;
import org.orm.ertodb.metadata.OracleTableMetadata;
import org.orm.ertodb.metadata.TableMetadata;

public class MetadataFactory {
    public static TableMetadata createTableMetadata(ResultSet resultSet, DatabaseMetaData databaseMetaData, Connection connection, Dialect dialect) throws SQLException {
        int n = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
        if (n == 2 || n == 0x100000 || n == 0x1000000) {
            return new MySQLTableMetadata(resultSet, databaseMetaData, connection, dialect);
        }
        if (n == 16) {
            return new OracleTableMetadata(resultSet, databaseMetaData, connection, dialect);
        }
        if (n == 1024) {
            return new DB2TableMetadata(resultSet, databaseMetaData, connection, dialect);
        }
        return new TableMetadata(resultSet, databaseMetaData, connection, dialect);
    }
}

