/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.RedshiftDialect;
import org.hibernate.internal.util.StringHelper;
import org.orm.ertodb.SQLReservedWordChecker;
import org.orm.ertodb.metadata.MetadataFactory;
import org.orm.ertodb.metadata.TableMetadata;

public class DatabaseMetadata {
    private final Map tables = new HashMap();
    private final Set sequences = new HashSet();
    private DatabaseMetaData meta;
    private final Dialect _dialect;
    private final Connection _connection;

    public DatabaseMetadata(Connection connection, Dialect dialect) throws SQLException {
        this._connection = connection;
        this._dialect = dialect;
        this.meta = connection.getMetaData();
        this.initSequences(connection, dialect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMetadata getTableMetadata(String string, String string2, boolean bl) throws SQLException {
        TableMetadata tableMetadata = null;
        if (string2 != null && (tableMetadata = (TableMetadata)this.tables.get((string == null ? "" : string.toUpperCase() + ".") + string2.toUpperCase())) == null) {
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = null;
            try {
                String string3 = string;
                if (this.meta.storesUpperCaseIdentifiers()) {
                    string3 = StringHelper.toUpperCase(string);
                } else if (this.storesLowerCaseIdentifiers()) {
                    string3 = StringHelper.toLowerCase(string);
                }
                resultSet = SQLReservedWordChecker.getInstance().isReservedWord(string2) || bl ? this.meta.getTables(null, string3, string2, stringArray) : (this.meta.storesUpperCaseIdentifiers() ? this.meta.getTables(null, string3, StringHelper.toUpperCase(string2), stringArray) : (this.storesLowerCaseIdentifiers() ? this.meta.getTables(null, string3, StringHelper.toLowerCase(string2), stringArray) : this.meta.getTables(null, string3, string2, stringArray)));
                while (resultSet.next()) {
                    if (!string2.equalsIgnoreCase(resultSet.getString("TABLE_NAME"))) continue;
                    tableMetadata = MetadataFactory.createTableMetadata(resultSet, this.meta, this._connection, this._dialect);
                    this.tables.put((string == null ? "" : string.toUpperCase() + ".") + string2.toUpperCase(), tableMetadata);
                    break;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        return tableMetadata;
    }

    private boolean storesLowerCaseIdentifiers() throws SQLException {
        if (this._dialect instanceof RedshiftDialect) {
            return true;
        }
        return this.meta.storesLowerCaseIdentifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMetadata getViewMetadata(String string) throws SQLException {
        TableMetadata tableMetadata = null;
        if (string != null && (tableMetadata = (TableMetadata)this.tables.get(string.toUpperCase())) == null) {
            String[] stringArray = new String[]{"VIEW"};
            ResultSet resultSet = null;
            try {
                resultSet = this.meta.getTables(null, null, null, stringArray);
                while (resultSet.next()) {
                    if (!string.equalsIgnoreCase(resultSet.getString("TABLE_NAME"))) continue;
                    tableMetadata = MetadataFactory.createTableMetadata(resultSet, this.meta, this._connection, this._dialect);
                    this.tables.put(string.toUpperCase(), tableMetadata);
                    break;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        return tableMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSequences(Connection connection, Dialect dialect) throws SQLException {
        String string = dialect.getQuerySequencesString();
        if (string == null) {
            return;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                this.sequences.add(resultSet.getString(1).trim().toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public boolean isSequence(Object object) {
        return object instanceof String && this.sequences.contains(((String)object).toUpperCase());
    }

    public boolean isTable(Object object) throws SQLException {
        return object instanceof String && this.getTableMetadata(null, (String)object, false) != null;
    }

    public TableMetadata[] getAllTables() {
        return this.getAllTables(null);
    }

    public TableMetadata[] getAllTables(String string) {
        ArrayList<TableMetadata> arrayList = new ArrayList<TableMetadata>();
        try {
            ResultSet resultSet = this.meta.getTables(null, string, null, new String[]{"TABLE"});
            while (resultSet.next()) {
                String string2 = resultSet.getString("TABLE_NAME");
                TableMetadata tableMetadata = MetadataFactory.createTableMetadata(resultSet, this.meta, this._connection, this._dialect);
                arrayList.add(tableMetadata);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return arrayList.toArray(new TableMetadata[arrayList.size()]);
    }

    public DatabaseMetaData getMeta() {
        return this.meta;
    }
}

