/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb.decorator;

import java.util.Vector;
import org.hibernate.dialect.Dialect;
import org.orm.ermodel.ERProcedure;
import org.orm.ermodel.ERTrigger;
import org.orm.ertodb.DDLGeneratorUtil;
import org.orm.ertodb.decorator.Decorator;

public class StandardDecorator
implements Decorator {
    private final boolean _upperCaseSQL;

    public StandardDecorator(boolean bl) {
        this._upperCaseSQL = bl;
    }

    public String[] decorateCreateSQL(ERProcedure[] eRProcedureArray, Dialect dialect, int n) {
        Vector<String> vector = new Vector<String>(eRProcedureArray.length);
        for (int i = 0; i < eRProcedureArray.length; ++i) {
            vector.add(eRProcedureArray[i].getStatements());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] decorateDropSQL(ERProcedure[] eRProcedureArray, Dialect dialect, int n) {
        Vector<String> vector = new Vector<String>(eRProcedureArray.length);
        for (int i = 0; i < eRProcedureArray.length; ++i) {
            vector.add(this.convertKeywordCase("drop ") + this.convertKeywordCase(eRProcedureArray[i].isFunction() ? "function" : "procedure") + " " + DDLGeneratorUtil.getQualifiedName(eRProcedureArray[i].getSchema(), eRProcedureArray[i].getName(), dialect, n));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] decorateAlterSQL(ERProcedure[] eRProcedureArray, Dialect dialect, int n) {
        return this.decorateCreateSQL(eRProcedureArray, dialect, n);
    }

    public String[] decorateAlterSQL(ERTrigger[] eRTriggerArray, Dialect dialect, int n) {
        return this.decorateCreateSQL(eRTriggerArray, dialect, n);
    }

    public String[] decorateCreateSQL(ERTrigger[] eRTriggerArray, Dialect dialect, int n) {
        Vector<String> vector = new Vector<String>(eRTriggerArray.length);
        for (int i = 0; i < eRTriggerArray.length; ++i) {
            vector.add(eRTriggerArray[i].getStatements());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] decorateDropSQL(ERTrigger[] eRTriggerArray, Dialect dialect, int n) {
        Vector<String> vector = new Vector<String>(eRTriggerArray.length);
        for (int i = 0; i < eRTriggerArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("drop trigger "));
            if (dialect.supportsIfExistsBeforeTableName()) {
                stringBuffer.append(this.convertKeywordCase("if exists "));
            }
            stringBuffer.append(DDLGeneratorUtil.getQualifiedName(eRTriggerArray[i].getSchema(), eRTriggerArray[i].getName(), dialect, n));
            if (dialect.supportsIfExistsAfterTableName()) {
                stringBuffer.append(this.convertKeywordCase(" if exists"));
            }
            vector.add(stringBuffer.toString());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String convertKeywordCase(String string) {
        if (this._upperCaseSQL) {
            return string.toUpperCase();
        }
        return string.toLowerCase();
    }
}

