/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb.decorator;

import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.dialect.Dialect;
import org.orm.ermodel.ERProcedure;
import org.orm.ermodel.ERProcedureParameter;
import org.orm.ermodel.ERTrigger;
import org.orm.ertodb.DDLGeneratorUtil;
import org.orm.ertodb.decorator.StandardDecorator;

public class PostgreSQLDecorator
extends StandardDecorator {
    public PostgreSQLDecorator(boolean bl) {
        super(bl);
    }

    public String[] decorateCreateSQL(ERProcedure[] eRProcedureArray, Dialect dialect, int n) {
        Vector<String> vector = new Vector<String>(eRProcedureArray.length * 2);
        for (int i = 0; i < eRProcedureArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("DROP FUNCTION IF EXISTS "));
            stringBuffer.append(DDLGeneratorUtil.getQualifiedName(eRProcedureArray[i].getSchema(), eRProcedureArray[i].getName(), dialect, n));
            stringBuffer.append("(");
            Iterator<ERProcedureParameter> iterator = eRProcedureArray[i].parameterIterator();
            if (iterator != null) {
                boolean bl = true;
                while (iterator.hasNext()) {
                    ERProcedureParameter eRProcedureParameter = iterator.next();
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(",");
                    }
                    if ("out".equals(eRProcedureParameter.getDirection())) {
                        stringBuffer.append(eRProcedureParameter.getDirection()).append(' ');
                    }
                    stringBuffer.append(eRProcedureParameter.getType());
                }
            }
            stringBuffer.append(")");
            stringBuffer.append(this.convertKeywordCase(" CASCADE"));
            vector.add(stringBuffer.toString());
            vector.add(eRProcedureArray[i].getStatements());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] decorateDropSQL(ERProcedure[] eRProcedureArray, Dialect dialect, int n) {
        Vector<String> vector = new Vector<String>(eRProcedureArray.length);
        for (int i = 0; i < eRProcedureArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("DROP FUNCTION IF EXISTS ") + DDLGeneratorUtil.getQualifiedName(eRProcedureArray[i].getSchema(), eRProcedureArray[i].getName(), dialect, n));
            stringBuffer.append("(");
            Iterator<ERProcedureParameter> iterator = eRProcedureArray[i].parameterIterator();
            if (iterator != null) {
                boolean bl = true;
                while (iterator.hasNext()) {
                    ERProcedureParameter eRProcedureParameter = iterator.next();
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(",");
                    }
                    if ("out".equals(eRProcedureParameter.getDirection())) {
                        stringBuffer.append(eRProcedureParameter.getDirection()).append(' ');
                    }
                    stringBuffer.append(eRProcedureParameter.getType());
                }
            }
            stringBuffer.append(")");
            stringBuffer.append(this.convertKeywordCase(" CASCADE"));
            vector.add(stringBuffer.toString());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] decorateCreateSQL(ERTrigger[] eRTriggerArray, Dialect dialect, int n) {
        Vector<String> vector = new Vector<String>(eRTriggerArray.length * 2);
        for (int i = 0; i < eRTriggerArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("DROP TRIGGER IF EXISTS "));
            stringBuffer.append(DDLGeneratorUtil.getQualifiedName(eRTriggerArray[i].getSchema(), eRTriggerArray[i].getName(), dialect, n));
            stringBuffer.append(this.convertKeywordCase(" ON "));
            stringBuffer.append(DDLGeneratorUtil.quoteName(PostgreSQLDecorator.extraTableNameFromCreateStatement(eRTriggerArray[i].getStatements()), dialect, n));
            stringBuffer.append(this.convertKeywordCase(" CASCADE"));
            vector.add(stringBuffer.toString());
            vector.add(eRTriggerArray[i].getStatements());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] decorateDropSQL(ERTrigger[] eRTriggerArray, Dialect dialect, int n) {
        Vector<String> vector = new Vector<String>(eRTriggerArray.length);
        for (int i = 0; i < eRTriggerArray.length; ++i) {
            vector.add(this.convertKeywordCase("DROP TRIGGER IF EXISTS ") + DDLGeneratorUtil.getQualifiedName(eRTriggerArray[i].getSchema(), eRTriggerArray[i].getName(), dialect, n) + this.convertKeywordCase(" ON ") + DDLGeneratorUtil.quoteName(PostgreSQLDecorator.extraTableNameFromCreateStatement(eRTriggerArray[i].getStatements()), dialect, n) + this.convertKeywordCase(" CASCADE"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public static String extraTableNameFromCreateStatement(String string) {
        Pattern pattern = Pattern.compile("\\son\\s(.+?)\\s", 10);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

