/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.hibernate.MappingException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SQLiteDialect;
import org.hibernate.dialect.SybaseDialect;
import org.orm.ermodel.ERColumn;
import org.orm.ermodel.ERElement;
import org.orm.ermodel.EREntity;
import org.orm.ermodel.ERForeignKey;
import org.orm.ertodb.DDLGenerator;
import org.orm.ertodb.DDLGeneratorUtil;
import org.orm.ertodb.DDLStatementCollection;
import org.orm.ertodb.DialectDBTypeMapper;
import org.orm.ertodb.DropSchemaContext;
import org.orm.ertodb.ForeignKeyDDLGenerator;
import org.orm.ertodb.metadata.ColumnMetadata;
import org.orm.ertodb.metadata.ForeignKeyMetadata;
import org.orm.ertodb.metadata.MySQLTableMetadata;
import org.orm.ertodb.metadata.TableMetadata;
import org.orm.ormtypemapper.DBType;
import org.orm.ormtypemapper.DBTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDDLGenerator {
    private final DDLGenerator _ddlGenerator;

    public TableDDLGenerator(DDLGenerator dDLGenerator) {
        this._ddlGenerator = dDLGenerator;
    }

    public String[] generateAlterDDL(EREntity eREntity, TableMetadata tableMetadata, boolean bl, Dialect dialect, DropSchemaContext dropSchemaContext) {
        String string;
        Object object;
        Object object2;
        ERElement eRElement;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        int n = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
        int n2 = eREntity.getModel().getQuoteSQLIdentifier();
        String[] stringArray = tableMetadata.getPrimaryKeyColumns();
        Serializable serializable = new HashSet<String>(Arrays.asList(stringArray));
        Object object3 = eREntity.elementIterator();
        while (object3.hasNext()) {
            eRElement = object3.next();
            if (!(eRElement instanceof ERColumn) || !((ERColumn)eRElement).isPrimaryKey() || serializable.remove(eRElement.getName().toLowerCase())) continue;
            bl2 = true;
            break;
        }
        if (!serializable.isEmpty()) {
            bl2 = true;
        }
        if (bl2 && (object3 = this.generateDropPrimaryKey(tableMetadata, eREntity, dialect, n2, dropSchemaContext)) != null) {
            arrayList.addAll(Arrays.asList(object3));
        }
        int n3 = this.getPKCount(eREntity);
        serializable = new StringBuffer(this._ddlGenerator.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, n2)).append(' ');
        if (this._ddlGenerator.isFormattedSQL()) {
            ((StringBuffer)serializable).append("\n  ");
        }
        object3 = eREntity.elementIterator();
        while (object3.hasNext()) {
            int n4;
            String string2;
            int n5;
            Object object4;
            Object object5;
            CharSequence charSequence;
            eRElement = (ERElement)object3.next();
            if (!(eRElement instanceof ERColumn)) continue;
            object2 = (ERColumn)eRElement;
            object = tableMetadata.getColumnMetadata(((ERElement)object2).getName());
            if (object == null) {
                string = DDLGeneratorUtil.quoteName(((ERElement)object2).getName(), dialect, n2);
                charSequence = new StringBuffer(((StringBuffer)serializable).toString()).append(this._ddlGenerator.convertKeywordCase(dialect.getAddColumnString())).append(' ').append(string).append(' ').append(this.getColumnDefinition((ERColumn)object2, string, n, dialect, n3, false, (ColumnMetadata)object));
                arrayList.add(((StringBuffer)charSequence).toString());
                continue;
            }
            boolean bl3 = false;
            if (((ERColumn)object2).getUserType(n) == null && DBTypeUtil.hasLengthSpecifier(n, DBTypeUtil.getDBTypeByID(((ERColumn)object2).getType()))) {
                if (((ColumnMetadata)object).getColumnSize() != ((ERColumn)object2).getLength()) {
                    if (!(dialect instanceof SQLServerDialect) || ((ColumnMetadata)object).getColumnSize() != 0x3FFFFFFF && ((ColumnMetadata)object).getColumnSize() != Integer.MAX_VALUE || ((ERColumn)object2).getLength() != -1) {
                        if (n == 16) {
                            charSequence = DBTypeUtil.getDBTypeByID(((ERColumn)object2).getType()).getDBTypeName(n);
                            if (!"timestamp".equals(charSequence) && !"timestamp with local time zone".equals(charSequence) || (((ColumnMetadata)object).getDecimalDigits() != 6 || ((ERColumn)object2).getLength() != 0) && ((ColumnMetadata)object).getDecimalDigits() != ((ERColumn)object2).getLength()) {
                                bl3 = true;
                            }
                        } else if (n == 256) {
                            charSequence = DBTypeUtil.getDBTypeByID(((ERColumn)object2).getType()).getDBTypeName(n);
                            if (!"timestamp".equals(charSequence) && !"timestamp with time zone".equals(charSequence) && !"time".equals(charSequence) || (((ColumnMetadata)object).getDecimalDigits() != 6 || ((ERColumn)object2).getLength() != 0) && ((ColumnMetadata)object).getDecimalDigits() != ((ERColumn)object2).getLength()) {
                                bl3 = true;
                            }
                        } else if (n == 1024) {
                            charSequence = DBTypeUtil.getDBTypeByID(((ERColumn)object2).getType()).getDBTypeName(n);
                            if (!"blob".equals(charSequence) && !"clob".equals(charSequence) || (((ColumnMetadata)object).getColumnSize() != 0x100000 || ((ERColumn)object2).getLength() != 0) && (((ERColumn)object2).getLength() == 0 || ((ColumnMetadata)object).getColumnSize() < ((ERColumn)object2).getLength())) {
                                bl3 = true;
                            }
                        } else if (n == 2 || n == 0x100000 || n == 0x1000000) {
                            boolean bl4 = false;
                            if (((ERColumn)object2).getLength() == 0) {
                                object5 = DBTypeUtil.getDBTypeByID(((ERColumn)object2).getType()).getDBTypeName(n);
                                if ("int".equals(object5)) {
                                    bl4 = ((ColumnMetadata)object).getColumnSize() == 11;
                                } else if ("smallint".equals(object5)) {
                                    bl4 = ((ColumnMetadata)object).getColumnSize() == 6;
                                } else if ("bigint".equals(object5)) {
                                    bl4 = ((ColumnMetadata)object).getColumnSize() == 20;
                                } else if ("bit".equals(object5)) {
                                    bl4 = ((ColumnMetadata)object).getColumnSize() == 1;
                                }
                            } else if (((ERColumn)object2).getLength() == 1 && ((ColumnMetadata)object).getColumnSize() == 0 && ((ColumnMetadata)object).getTypeName().toLowerCase().equals("bit")) {
                                bl4 = true;
                            } else if (((ColumnMetadata)object).getColumnSize() == 3 && ((ColumnMetadata)object).getTypeName().toLowerCase().equals("tinyint") && ((ERColumn)object2).getLength() != 1) {
                                bl4 = true;
                            }
                            if (!bl4) {
                                bl3 = true;
                            }
                        } else if (n == 8 || n == 0x200000) {
                            charSequence = DBTypeUtil.getDBTypeByID(((ERColumn)object2).getType()).getDBTypeName(n);
                            if ("datetime2".equals(charSequence)) {
                                int n6 = ((ColumnMetadata)object).getColumnSize();
                                if (n6 >= 19) {
                                    n6 = n6 == 19 ? 0 : (n6 -= 20);
                                }
                                bl3 = n6 != ((ERColumn)object2).getLength();
                            } else {
                                bl3 = true;
                            }
                        } else {
                            bl3 = true;
                        }
                    }
                } else if (DBTypeUtil.getDBTypeByID(((ERColumn)object2).getType()).isDecimal() && ((ColumnMetadata)object).getDecimalDigits() != ((ERColumn)object2).getScale()) {
                    bl3 = true;
                }
            }
            if (bl3 && n == 1024) {
                boolean bl5 = true;
                object5 = DBTypeUtil.getDBTypeByID(((ERColumn)object2).getType()).getDBTypeName(n);
                if (object5.toLowerCase().equals("float")) {
                    if (((ERColumn)object2).getLength() <= 24 && ((ColumnMetadata)object).getTypeName().toLowerCase().equals("real")) {
                        bl5 = false;
                    } else if (((ERColumn)object2).getLength() > 24 && ((ColumnMetadata)object).getTypeName().toLowerCase().equals("double")) {
                        bl5 = false;
                    }
                }
                if (bl5) {
                    Object[] objectArray;
                    if (((ERColumn)object2).isPrimaryKey() && !bl2) {
                        bl2 = true;
                        objectArray = this.generateDropPrimaryKey(tableMetadata, eREntity, dialect, n2, dropSchemaContext);
                        if (objectArray != null) {
                            arrayList.addAll(Arrays.asList(objectArray));
                        }
                    }
                    if ((objectArray = tableMetadata.getForeignKeyMetadataByColumn((ColumnMetadata)object)) != null) {
                        object4 = objectArray;
                        n5 = ((ForeignKeyMetadata[])object4).length;
                        for (int i = 0; i < n5; ++i) {
                            ForeignKeyMetadata foreignKeyMetadata = object4[i];
                            this.generateDropForeignKey(dialect, n2, dropSchemaContext, arrayList, foreignKeyMetadata);
                        }
                    }
                    arrayList.add(new StringBuffer(((StringBuffer)serializable).toString()).append(this._ddlGenerator.convertKeywordCase("alter column ")).append(DDLGeneratorUtil.quoteName(((ERElement)object2).getName(), dialect, n2)).append(this._ddlGenerator.convertKeywordCase(" set data type ")).append(this.getColumnTypeStringWithCollation((ERColumn)object2, n, dialect)).toString());
                }
                bl3 = false;
            } else if (bl3 && n == 256) {
                ForeignKeyMetadata[] foreignKeyMetadataArray;
                if (((ERColumn)object2).isPrimaryKey() && !bl2) {
                    bl2 = true;
                    String[] stringArray2 = this.generateDropPrimaryKey(tableMetadata, eREntity, dialect, n2, dropSchemaContext);
                    if (stringArray2 != null) {
                        arrayList.addAll(Arrays.asList(stringArray2));
                    }
                }
                if ((foreignKeyMetadataArray = tableMetadata.getForeignKeyMetadataByColumn((ColumnMetadata)object)) != null) {
                    object5 = foreignKeyMetadataArray;
                    int n7 = ((ForeignKeyMetadata[])object5).length;
                    for (int i = 0; i < n7; ++i) {
                        ForeignKeyMetadata foreignKeyMetadata = object5[i];
                        this.generateDropForeignKey(dialect, n2, dropSchemaContext, arrayList, foreignKeyMetadata);
                    }
                }
                arrayList.add(new StringBuffer(((StringBuffer)serializable).toString()).append(this._ddlGenerator.convertKeywordCase("alter column ")).append(DDLGeneratorUtil.quoteName(((ERElement)object2).getName(), dialect, n2)).append(this._ddlGenerator.convertKeywordCase(" set data type ")).append(this.getColumnTypeStringWithCollation((ERColumn)object2, n, dialect)).toString());
                bl3 = false;
            } else if (bl3 && (n == 8 || n == 0x200000) && (string2 = DBTypeUtil.getDBTypeByID(((ERColumn)object2).getType()).getDBTypeName(n)).toLowerCase().equals("float")) {
                if (((ERColumn)object2).getLength() <= 24 && ((ColumnMetadata)object).getTypeName().toLowerCase().equals("real")) {
                    bl3 = false;
                } else if (((ERColumn)object2).getLength() > 24 && ((ColumnMetadata)object).getTypeName().toLowerCase().equals("float")) {
                    bl3 = false;
                }
            }
            if (!(bl3 && n != 32 || ((ColumnMetadata)object).getNullable().length() <= 0)) {
                boolean bl6 = ((ERColumn)object2).isNullable();
                if (((ColumnMetadata)object).isNullable() != bl6) {
                    object5 = DDLGeneratorUtil.quoteName(((ERElement)object2).getName(), dialect, n2);
                    String string3 = dialect.getAlterColumnNullableString((String)object5, bl6);
                    if (string3 == null) {
                        bl3 = true;
                    } else {
                        arrayList.add(((StringBuffer)serializable).toString() + string3);
                    }
                }
            }
            if (bl3) {
                charSequence = DDLGeneratorUtil.quoteName(((ERElement)object2).getName(), dialect, n2);
                try {
                    if (((ERColumn)object2).isPrimaryKey() && !bl2) {
                        bl2 = true;
                        object5 = this.generateDropPrimaryKey(tableMetadata, eREntity, dialect, n2, dropSchemaContext);
                        if (object5 != null) {
                            arrayList.addAll(Arrays.asList(object5));
                        }
                    }
                    if ((object5 = tableMetadata.getForeignKeyMetadataByColumn((ColumnMetadata)object)) != null) {
                        Object object6 = object5;
                        int n8 = ((ForeignKeyMetadata[])object6).length;
                        for (n5 = 0; n5 < n8; ++n5) {
                            ForeignKeyMetadata foreignKeyMetadata = object6[n5];
                            this.generateDropForeignKey(dialect, n2, dropSchemaContext, arrayList, foreignKeyMetadata);
                        }
                    }
                    StringBuffer stringBuffer = new StringBuffer(((StringBuffer)serializable).toString()).append(dialect.getAlterColumnDefinitionString((String)charSequence, this.getColumnDefinition((ERColumn)object2, (String)charSequence, n, dialect, n3, true, (ColumnMetadata)object)));
                    arrayList.add(stringBuffer.toString());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                continue;
            }
            charSequence = ((ERColumn)object2).getDefaultValue();
            if (charSequence != null && ((String)charSequence).length() > 0 && dialect instanceof MySQLDialect && (n4 = ((String)charSequence).toLowerCase().indexOf(" on update ")) >= 0) {
                charSequence = ((String)charSequence).substring(0, n4);
            }
            object5 = this.removeExtraCharFromDBDefaultValue(((ColumnMetadata)object).getDefaultValue(), dialect);
            int n9 = DBTypeUtil.getDBTypeByID(((ERColumn)object2).getType()).getSqlType();
            if ("".equals(object5) && (n9 == 1 || n9 == 12)) {
                object5 = "''";
            }
            if (((ERColumn)object2).isPrimaryKey() || charSequence == null || ((String)charSequence).length() <= 0 || this.defaultValueEquals(n, n9, (String)charSequence, (String)object5)) continue;
            object4 = this.convertDefaultValue((ERColumn)object2, n, dialect);
            if (dialect instanceof MySQLDialect && (n5 = ((String)object4).toLowerCase().indexOf(" on update ")) >= 0) {
                object4 = ((String)object4).substring(0, n5);
            }
            String string4 = DDLGeneratorUtil.quoteName(((ERElement)object2).getName(), dialect, n2);
            try {
                StringBuffer stringBuffer = new StringBuffer(((StringBuffer)serializable).toString()).append(dialect.getAlterColumnDefaultValueString(string4, (String)object4));
                arrayList.add(stringBuffer.toString());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        if (bl2) {
            object3 = new ArrayList();
            eRElement = null;
            object2 = eREntity.elementIterator();
            while (object2.hasNext()) {
                object = (ERElement)object2.next();
                if (!(object instanceof ERColumn) || !((ERColumn)object).isPrimaryKey()) continue;
                object3.add(DDLGeneratorUtil.quoteName(((ERElement)object).getName(), dialect, n2));
                eRElement = (ERColumn)object;
            }
            if (!object3.isEmpty() && (object2 = dialect.getAddPrimaryKeyString(object3.toArray(new String[object3.size()]))) != null) {
                object = new StringBuffer((CharSequence)((Object)serializable));
                string = "add primary key";
                if (dialect instanceof SQLServerDialect) {
                    int n10 = eREntity.getPkClustered();
                    switch (n10) {
                        case 1: {
                            string = string + " clustered";
                            break;
                        }
                        case 2: {
                            string = string + " nonclustered";
                        }
                    }
                }
                ((StringBuffer)object).append(((String)object2).replaceAll("add primary key", this._ddlGenerator.convertKeywordCase(string)));
                arrayList.add(((StringBuffer)object).toString());
                if ((n == 2 || n == 0x100000 || n == 0x1000000) && object3.size() == 1 && eRElement != null && this.isIdentityColumn((ERColumn)eRElement, dialect) && !((ERColumn)eRElement).isForeignKey()) {
                    StringBuffer stringBuffer = new StringBuffer(((StringBuffer)serializable).toString()).append(dialect.getAlterColumnDefinitionString(eRElement.getName(), this.getColumnDefinition((ERColumn)eRElement, eRElement.getName(), n, dialect, n3, true, null) + this._ddlGenerator.convertKeywordCase(" auto_increment")));
                    arrayList.add(stringBuffer.toString());
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] generateDropPrimaryKey(TableMetadata tableMetadata, EREntity eREntity, Dialect dialect, int n, DropSchemaContext dropSchemaContext) {
        String string = DropSchemaContext.getPKKey(tableMetadata);
        if (tableMetadata.getPkConstraint() != null && !dropSchemaContext.isPKDropped(string)) {
            try {
                String string2 = dialect.getDropPrimaryKeyString(tableMetadata.getPkConstraint());
                if (string2 != null) {
                    String string3;
                    Object object;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String[] stringArray = tableMetadata.getExportedForeignKeys();
                    for (String object2 : stringArray) {
                        object = tableMetadata.getExportedForeignKeyMetadata(object2);
                        this.generateDropForeignKey(dialect, n, dropSchemaContext, arrayList, (ForeignKeyMetadata)object);
                    }
                    StringBuffer stringBuffer = new StringBuffer(this._ddlGenerator.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(tableMetadata.getSchema(), tableMetadata.getName(), dialect, n)).append(' ');
                    if (this._ddlGenerator.isFormattedSQL()) {
                        stringBuffer.append("\n  ");
                    }
                    if (tableMetadata instanceof MySQLTableMetadata && (string3 = ((MySQLTableMetadata)tableMetadata).getAutoIncrementColumn()) != null) {
                        ERColumn eRColumn = null;
                        Iterator<ERElement> iterator = eREntity.elementIterator();
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            if (!(object instanceof ERColumn) || !((ERElement)object).getName().toLowerCase().equals(string3.toLowerCase())) continue;
                            eRColumn = (ERColumn)object;
                            break;
                        }
                        object = tableMetadata.getColumnMetadata(string3);
                        int n2 = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
                        if (eRColumn != null) {
                            StringBuffer string4 = new StringBuffer(stringBuffer.toString()).append(dialect.getAlterColumnDefinitionString(((ColumnMetadata)object).getName(), this.getColumnDefinition(eRColumn, ((ColumnMetadata)object).getName(), n2, dialect, tableMetadata.getPrimaryKeyColumns().length, true, (ColumnMetadata)object)));
                            arrayList.add(string4.toString());
                        } else {
                            CharSequence charSequence;
                            String string4 = ((ColumnMetadata)object).getTypeName();
                            DBType dBType = DBTypeUtil.getDBTypeByDB(n2, string4, ((ColumnMetadata)object).getColumnSize(), ((ColumnMetadata)object).getDecimalDigits());
                            if (dBType != null) {
                                string4 = dBType.getDBType(n2);
                                if (DBTypeUtil.hasLengthSpecifier(n2, dBType)) {
                                    if (((ColumnMetadata)object).getColumnSize() != 0) {
                                        charSequence = "(";
                                        charSequence = (String)charSequence + ((ColumnMetadata)object).getColumnSize();
                                        charSequence = (String)charSequence + ")";
                                        string4 = string4.indexOf("($l)") > 0 ? string4.replaceFirst("\\(\\$l\\)", (String)charSequence) : string4 + (String)charSequence;
                                    } else {
                                        string4 = string4.replaceFirst("\\(\\$l\\)", "");
                                    }
                                }
                            }
                            charSequence = new StringBuffer(string4);
                            if (!((ColumnMetadata)object).isNullable()) {
                                ((StringBuffer)charSequence).append(this._ddlGenerator.convertKeywordCase(" not null"));
                            }
                            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString()).append(dialect.getAlterColumnDefinitionString(((ColumnMetadata)object).getName(), ((StringBuffer)charSequence).toString()));
                            arrayList.add(stringBuffer2.toString());
                        }
                    }
                    StringBuffer stringBuffer4 = new StringBuffer(stringBuffer);
                    stringBuffer4.append(string2.replaceAll("drop constraint", this._ddlGenerator.convertKeywordCase("drop constraint")).replaceAll("drop primary key", this._ddlGenerator.convertKeywordCase("drop primary key")));
                    arrayList.add(stringBuffer4.toString());
                    String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                    return stringArray2;
                }
            }
            finally {
                dropSchemaContext.droppedPK(string);
            }
        }
        return null;
    }

    private void generateDropForeignKey(Dialect dialect, int n, DropSchemaContext dropSchemaContext, List<String> list, ForeignKeyMetadata foreignKeyMetadata) {
        String string = DropSchemaContext.getFKKey(foreignKeyMetadata);
        if (!dropSchemaContext.isFKDropped(string)) {
            if (dialect.getDropForeignKeyString() != null) {
                StringBuffer stringBuffer = new StringBuffer(this._ddlGenerator.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(foreignKeyMetadata.getFkTableSchema(), foreignKeyMetadata.getFkTable(), dialect, n));
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
                stringBuffer2.append(this._ddlGenerator.convertKeywordCase(dialect.getDropForeignKeyString())).append(DDLGeneratorUtil.quoteName(foreignKeyMetadata.getName(), dialect, n));
                list.add(stringBuffer2.toString());
                if (dialect instanceof MySQLDialect) {
                    StringBuffer stringBuffer3 = new StringBuffer(stringBuffer);
                    stringBuffer3.append(this._ddlGenerator.convertKeywordCase(" drop index ")).append(DDLGeneratorUtil.quoteName(foreignKeyMetadata.getName(), dialect, n));
                    list.add(stringBuffer3.toString());
                }
            }
            dropSchemaContext.droppedFK(string);
            dropSchemaContext.markRecreateFK(string);
        }
    }

    private boolean defaultValueEquals(int n, int n2, String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (n == 2 || n == 0x100000 || n == 0x1000000) {
            if (n2 == -7) {
                if ("true".equalsIgnoreCase(string) || "B'1'".equals(string)) {
                    return "b'1'".equals(string2) || "1".equals(string2);
                }
                if ("false".equalsIgnoreCase(string) || "B'0'".equals(string)) {
                    return "b'0'".equals(string2) || "0".equals(string2);
                }
            } else if (n2 == 1) {
                return string.equals("'" + string2 + "'");
            }
        } else if (n == 256 && "current_timestamp".equals(string) && "now()".equals(string2)) {
            return true;
        }
        return false;
    }

    private String getColumnDefinition(ERColumn eRColumn, String string, int n, Dialect dialect, int n2, boolean bl, ColumnMetadata columnMetadata) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(this.getColumnTypeStringWithCollation(eRColumn, n, dialect));
        if (!(bl && dialect instanceof SQLServerDialect || (string2 = this.convertDefaultValue(eRColumn, n, dialect)) == null || string2.length() <= 0)) {
            stringBuffer.append(this._ddlGenerator.convertKeywordCase(" default ")).append(string2);
        }
        if (eRColumn.isNullable()) {
            if (bl && (dialect instanceof Oracle9Dialect || dialect instanceof Oracle8iDialect) && !columnMetadata.isNullable()) {
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" null"));
            } else {
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(dialect.getNullColumnString()));
            }
        } else {
            boolean bl2 = true;
            if (bl && n == 16 && columnMetadata != null && !columnMetadata.isNullable()) {
                bl2 = false;
            } else if (bl && n == 32) {
                bl2 = false;
            }
            if (bl2) {
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" not null"));
            }
        }
        if (!bl) {
            if (eRColumn.isUnique() && !eRColumn.isIndex() && dialect.supportsUnique() && (n2 != 1 || !eRColumn.isPrimaryKey())) {
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" unique"));
            }
            if (eRColumn.hasCheckConstraint() && dialect.supportsColumnCheck()) {
                string2 = eRColumn.getCheckConstraint();
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" check(")).append(string2.replaceAll(Pattern.quote("${name}"), string)).append(")");
            }
        }
        if (this._ddlGenerator.getDdlOption().isGenerateCommment() && (string2 = eRColumn.getComment()) != null && string2.length() > 0) {
            stringBuffer.append(dialect.getColumnComment(string2.replaceAll("'", "''")));
        }
        return stringBuffer.toString();
    }

    public void generateCreateDDL(DDLStatementCollection dDLStatementCollection, EREntity eREntity, Dialect dialect, ERForeignKey[] eRForeignKeyArray) throws MappingException {
        String string;
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = this._ddlGenerator.getDdlOption().isSplitDDL();
        if (bl && dialect instanceof SQLiteDialect) {
            bl = false;
        }
        int n = this.getPKCount(eREntity);
        StringBuffer stringBuffer = new StringBuffer();
        if (eREntity.isUnlogged() && dialect instanceof PostgreSQL81Dialect) {
            stringBuffer.append(this._ddlGenerator.convertKeywordCase("create unlogged table "));
        } else {
            stringBuffer.append(n > 0 ? this._ddlGenerator.convertKeywordCase(dialect.getCreateTableString()) : this._ddlGenerator.convertKeywordCase(dialect.getCreateMultisetTableString())).append(' ');
        }
        int n2 = eREntity.getModel().getQuoteSQLIdentifier();
        String string2 = DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, n2);
        stringBuffer.append(string2);
        stringBuffer.append(" (");
        if (this._ddlGenerator.isFormattedSQL()) {
            stringBuffer.append("\n  ");
        }
        HashMap<Object, Iterator<ERElement>> hashMap = new HashMap<Object, Iterator<ERElement>>();
        int n3 = 0;
        Iterator<ERElement> iterator = eREntity.elementIterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            if (!(object4 instanceof ERColumn)) continue;
            object3 = (ERColumn)object4;
            object2 = DDLGeneratorUtil.quoteName(((ERElement)object3).getName(), dialect, n2);
            hashMap.put(object3, (Iterator<ERElement>)object2);
            if (((String)object2).length() <= n3) continue;
            n3 = ((String)object2).length();
        }
        boolean bl2 = false;
        object4 = new ArrayList();
        object3 = eREntity.elementIterator();
        while (object3.hasNext()) {
            Object object5;
            int n4;
            object2 = (ERElement)object3.next();
            if (!(object2 instanceof ERColumn)) continue;
            object = (ERColumn)object2;
            stringArray = (String)hashMap.get(object);
            stringBuffer.append((String)stringArray);
            if (this._ddlGenerator.isFormattedSQL()) {
                for (n4 = stringArray.length(); n4 < n3; ++n4) {
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append(' ');
            n4 = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
            if (((ERColumn)object).isPrimaryKey() && this.isIdentityColumn((ERColumn)object, dialect) && !((ERColumn)object).isForeignKey()) {
                if (dialect instanceof MySQLDialect) {
                    bl = false;
                }
                if (dialect.hasDataTypeInIdentityColumn()) {
                    stringBuffer.append(this.getColumnTypeStringWithCollation((ERColumn)object, n4, dialect));
                    stringBuffer.append(' ');
                }
                object5 = DBTypeUtil.getDBTypeByID(((ERColumn)object).getType());
                String string3 = dialect.getIdentityColumnString(((DBType)object5).getSqlType(), ((ERColumn)object).getIdentitySeed(), ((ERColumn)object).getIdentityIncrement());
                if (bl && dialect instanceof H2Dialect) {
                    string3 = "auto_increment";
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(string3));
                if (dialect instanceof SQLiteDialect && ((ERColumn)object).isPrimaryKey()) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase(" not null"));
                    boolean bl3 = false;
                    Iterator<ERElement> iterator2 = eREntity.elementIterator();
                    while (iterator2.hasNext()) {
                        ERElement eRElement = iterator2.next();
                        if (eRElement == object2 || !(eRElement instanceof ERColumn) || !((ERColumn)eRElement).isPrimaryKey()) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3 && !bl) {
                        bl2 = true;
                        stringBuffer.append(this._ddlGenerator.convertKeywordCase(" primary key"));
                    }
                }
            } else {
                boolean bl4;
                stringBuffer.append(this.getColumnTypeStringWithCollation((ERColumn)object, n4, dialect));
                object5 = this.convertDefaultValue((ERColumn)object, n4, dialect);
                if (object5 != null && ((String)object5).length() > 0) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase(" default ")).append((String)object5);
                }
                boolean bl5 = bl4 = ((ERColumn)object).isNullable() && !((ERColumn)object).isPrimaryKey();
                if ((n4 == 8 || n4 == 0x200000) && ((ERColumn)object).getUserType(n4) != null && ((ERColumn)object).getUserType(n4).toLowerCase().startsWith("as ")) {
                    if (((ERColumn)object).getUserType(n4).toLowerCase().endsWith(" persisted") && !bl4) {
                        stringBuffer.append(this._ddlGenerator.convertKeywordCase(" not null"));
                    }
                } else if (bl4) {
                    if (dialect instanceof MySQLDialect) {
                        DBType dBType = DBTypeUtil.getDBTypeByID(((ERColumn)object).getType());
                        if (dBType.getSqlType() == 93) {
                            stringBuffer.append(this._ddlGenerator.convertKeywordCase(" null"));
                        }
                    } else {
                        stringBuffer.append(this._ddlGenerator.convertKeywordCase(dialect.getNullColumnString()));
                    }
                } else {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase(" not null"));
                }
            }
            if (!(!((ERColumn)object).isUnique() || ((ERColumn)object).isIndex() || n == 1 && ((ERColumn)object).isPrimaryKey())) {
                if (dialect.supportsUnique()) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase(" unique"));
                } else {
                    ((ArrayList)object4).add(((ERElement)object).getName());
                }
            }
            if (((ERColumn)object).hasCheckConstraint() && dialect.supportsColumnCheck()) {
                object5 = ((ERColumn)object).getCheckConstraint();
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" check(")).append(((String)object5).replaceAll(Pattern.quote("${name}"), (String)stringArray)).append(")");
            }
            if (this._ddlGenerator.getDdlOption().isGenerateCommment() && (object5 = ((ERColumn)object).getComment()) != null && ((String)object5).length() > 0) {
                stringBuffer.append(dialect.getColumnComment(((String)object5).replaceAll("'", "''")));
            }
            if ((object5 = ((ERColumn)object).getExtraDDLClause()) != null && ((String)object5).length() > 0) {
                stringBuffer.append(" ").append((String)object5);
            }
            if (!object3.hasNext()) continue;
            stringBuffer.append(", ");
            if (!this._ddlGenerator.isFormattedSQL()) continue;
            stringBuffer.append("\n  ");
        }
        if (!bl2 && !bl) {
            boolean bl6 = false;
            object2 = eREntity.elementIterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof ERColumn) || !(stringArray = object).isPrimaryKey()) continue;
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                if (!bl6) {
                    String string4 = eREntity.getPkConstraintName();
                    if (dialect.supportConstraintName() && string4 != null) {
                        stringBuffer.append(this._ddlGenerator.convertKeywordCase("constraint "));
                        stringBuffer.append(DDLGeneratorUtil.quoteName(string4, dialect, n2));
                        stringBuffer.append(" ");
                        if (this._ddlGenerator.isFormattedSQL()) {
                            stringBuffer.append("\n    ");
                        }
                    }
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase("primary key"));
                    if (dialect instanceof SQLServerDialect) {
                        int n5 = eREntity.getPkClustered();
                        switch (n5) {
                            case 1: {
                                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" clustered"));
                                break;
                            }
                            case 2: {
                                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" nonclustered"));
                            }
                        }
                    }
                    stringBuffer.append(" (");
                    bl6 = true;
                }
                stringBuffer.append(DDLGeneratorUtil.quoteName(stringArray.getName(), dialect, n2));
            }
            if (bl6) {
                stringBuffer.append(")");
                object2 = eREntity.getPkTablespace();
                if (dialect.supportPrimaryKeyTablespace() && object2 != null && ((String)object2).length() > 0) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase(" using index tablespace ")).append(DDLGeneratorUtil.quoteName((String)object2, dialect, n2));
                }
                if ((object = eREntity.getPkDdlClauses()) != null && ((String)object).length() > 0) {
                    stringBuffer.append(" ").append((String)object);
                }
            }
            bl2 = true;
        }
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            Iterator<String> iterator3 = eREntity.uniqueKeysIterator();
            while (iterator3.hasNext()) {
                object2 = iterator3.next();
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                if (dialect.supportConstraintName()) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase("constraint "));
                    stringBuffer.append(DDLGeneratorUtil.quoteName((String)object2, dialect, n2));
                    stringBuffer.append(" ");
                    if (this._ddlGenerator.isFormattedSQL()) {
                        stringBuffer.append("\n    ");
                    }
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("unique ("));
                object = eREntity.uniqueKeyColumnsIterator((String)object2);
                while (object.hasNext()) {
                    ERColumn eRColumn;
                    stringArray = (String)object.next();
                    if (DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName()) == 1024 && (eRColumn = eREntity.getColumnByName((String)stringArray)) != null && eRColumn.isNullable()) {
                        throw new MappingException("DB2 unique constraint \"" + (String)object2 + "\" column \"" + (String)stringArray + "\" cannot nullable.");
                    }
                    stringBuffer.append(DDLGeneratorUtil.quoteName((String)stringArray, dialect, n2));
                    if (!object.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
            }
            iterator3 = ((ArrayList)object4).iterator();
            while (iterator3.hasNext()) {
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("unique ("));
                stringBuffer.append(DDLGeneratorUtil.quoteName(iterator3.next(), dialect, n2));
                stringBuffer.append(")");
            }
        }
        if (dialect.supportsIndexConstraintInCreateAlterTable()) {
            Iterator<ERElement> iterator4 = eREntity.elementIterator();
            while (iterator4.hasNext()) {
                object2 = iterator4.next();
                if (!(object2 instanceof ERColumn) || !((ERColumn)(object = (ERColumn)object2)).isIndex()) continue;
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                if (((ERColumn)object).isUnique()) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase("unique "));
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("index ("));
                stringBuffer.append(DDLGeneratorUtil.quoteName(((ERElement)object).getName(), dialect, n2));
                stringBuffer.append(")");
            }
        }
        if (dialect.createForeignKeyInCreateTable() && eRForeignKeyArray != null) {
            for (int i = 0; i < eRForeignKeyArray.length; ++i) {
                object2 = eRForeignKeyArray[i];
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("foreign key("));
                object = ((ERForeignKey)object2).getColumns();
                for (int j = 0; j < ((String[])object).length; ++j) {
                    stringBuffer.append(DDLGeneratorUtil.quoteName(object[j], dialect, n2));
                    if (j >= ((Object)object).length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(") ");
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("references "));
                stringBuffer.append(DDLGeneratorUtil.quoteName(((ERForeignKey)object2).getReferencedTable(), dialect, n2));
                stringBuffer.append("(");
                stringArray = ((ERForeignKey)object2).getRefColumns();
                for (int j = 0; j < stringArray.length; ++j) {
                    stringBuffer.append(DDLGeneratorUtil.quoteName(stringArray[j], dialect, n2));
                    if (j >= stringArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                stringBuffer.append(ForeignKeyDDLGenerator.convertForeignKeyConstraintCase(dialect.getReferenceOnUpdateDeleteString(((ERForeignKey)object2).getOnUpdate(), ((ERForeignKey)object2).getOnDelete()), this._ddlGenerator));
            }
        }
        if (dialect.supportsTableCheck()) {
            Iterator<String> iterator5 = eREntity.checkConstraintKeysIterator();
            while (iterator5.hasNext()) {
                object2 = iterator5.next();
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                if (dialect.supportConstraintName()) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase("constraint "));
                    stringBuffer.append(DDLGeneratorUtil.quoteName((String)object2, dialect, n2));
                    stringBuffer.append(" ");
                    if (this._ddlGenerator.isFormattedSQL()) {
                        stringBuffer.append("\n    ");
                    }
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("check (")).append(eREntity.getCheckConstraints((String)object2)).append(")");
            }
        }
        stringBuffer.append(")");
        if (this._ddlGenerator.getDdlOption().isGenerateCommment() && eREntity.getComment() != null && eREntity.getComment().length() > 0) {
            stringBuffer.append(dialect.getTableComment(eREntity.getComment().replaceAll("'", "''")));
        }
        stringBuffer.append(dialect.getTableTypeString());
        if (dialect instanceof MySQLDialect && (string = eREntity.getModel().getTableCharset()) != null && string.trim().length() > 0) {
            stringBuffer.append(" CHARACTER SET ").append(string);
        }
        String string5 = eREntity.getTablespace();
        object2 = dialect.getCreateTableInTablespaceKeyword();
        if (object2 != null && string5 != null && string5.length() > 0) {
            stringBuffer.append(" ").append(this._ddlGenerator.convertKeywordCase((String)object2)).append(" ").append(string5);
        }
        if (eREntity.getExtraDDLClause() != null && eREntity.getExtraDDLClause().length() > 0) {
            stringBuffer.append(" ").append(eREntity.getExtraDDLClause());
        }
        dDLStatementCollection.addTableStatement(stringBuffer.toString());
        if (bl) {
            object = new StringBuffer();
            boolean bl7 = false;
            Object object6 = eREntity.elementIterator();
            while (object6.hasNext()) {
                ERColumn eRColumn;
                ERElement eRElement = object6.next();
                if (!(eRElement instanceof ERColumn) || !(eRColumn = (ERColumn)eRElement).isPrimaryKey()) continue;
                if (!bl7) {
                    boolean bl8;
                    String string6 = eREntity.getPkConstraintName();
                    ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("alter table "));
                    ((StringBuffer)object).append(string2);
                    ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase(" add "));
                    boolean bl9 = bl8 = dialect.supportConstraintName() && string6 != null;
                    if (dialect instanceof InformixDialect || bl8) {
                        ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("constraint "));
                    }
                    if (bl8) {
                        ((StringBuffer)object).append(DDLGeneratorUtil.quoteName(string6, dialect, n2));
                        ((StringBuffer)object).append(" ");
                    }
                    ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("primary key"));
                    if (dialect instanceof SQLServerDialect) {
                        int n6 = eREntity.getPkClustered();
                        switch (n6) {
                            case 1: {
                                ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase(" clustered"));
                                break;
                            }
                            case 2: {
                                ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase(" nonclustered"));
                            }
                        }
                    }
                    ((StringBuffer)object).append(" (");
                    ((StringBuffer)object).append(DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n2));
                    bl7 = true;
                    continue;
                }
                ((StringBuffer)object).append(", ");
                ((StringBuffer)object).append(DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n2));
            }
            if (bl7) {
                ((StringBuffer)object).append(")");
                object6 = eREntity.getPkTablespace();
                if (dialect.supportPrimaryKeyTablespace() && object6 != null && ((String)object6).length() > 0) {
                    ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase(" using index tablespace ")).append(DDLGeneratorUtil.quoteName((String)object6, dialect, n2));
                }
                dDLStatementCollection.addPKStatement(((StringBuffer)object).toString());
            }
        }
    }

    private String getColumnTypeStringWithCollation(ERColumn eRColumn, int n, Dialect dialect) {
        String string;
        String string2 = this.getColumnTypeString(eRColumn, n, dialect);
        if ((n == 8 || n == 0x200000 || n == 2 || n == 0x100000 || n == 256) && (string = eRColumn.getCollation()) != null && string.length() > 0) {
            string2 = string2 + this._ddlGenerator.convertKeywordCase(" collate ") + string;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getColumnTypeString(ERColumn eRColumn, int n, Dialect dialect) {
        String string;
        String string2;
        String string3 = eRColumn.getUserType(n);
        if (string3 != null) {
            return string3;
        }
        DBType dBType = DBTypeUtil.getDBTypeByID(eRColumn.getType());
        String string4 = dBType.getDBType(n);
        if (n == 64) {
            if (this.isSybaseIdentityColumn(eRColumn, n, dialect)) {
                return "numeric(19,0)";
            }
        } else if (n == 2048 && string4.equals("informix_float")) {
            string4 = "float";
        }
        if (!DBTypeUtil.hasLengthSpecifier(n, dBType)) return string4;
        int n2 = eRColumn.getLength();
        boolean bl = false;
        if (n2 == 0 && !(bl = DBTypeUtil.isAllowZeroLength(n, dBType))) {
            n2 = DBTypeUtil.generateDefaultLength(n, dBType);
        }
        if (n2 == 0) {
            if (!bl) return string4.replaceFirst("\\(\\$l\\)", "");
        }
        if (n2 == -1) {
            string2 = dBType.getDBTypeName(n);
            if (!("varchar".equals(string2) || "varchar2".equals(string2) || "nvarchar".equals(string2) || "nvarchar2".equals(string2))) {
                if (!"varbinary".equals(string2)) return string4;
            }
            string = n == 8 ? "max" : (n == 0x200000 ? "max" : "255");
        } else {
            string = (n == 8 || n == 0x200000) && "float".equals(string4) && n2 > 53 ? "53" : String.valueOf(n2);
        }
        string2 = "(";
        string2 = string2 + string;
        if (dBType.isDecimal()) {
            string2 = string2 + ", " + eRColumn.getScale();
        }
        string2 = string2 + ")";
        if (string4.indexOf("($l)") <= 0) return string4 + string2;
        return string4.replaceFirst("\\(\\$l\\)", string2);
    }

    private boolean isSybaseIdentityColumn(ERColumn eRColumn, int n, Dialect dialect) {
        ERColumn eRColumn2;
        DBType dBType = DBTypeUtil.getDBTypeByID(eRColumn.getType());
        String string = dBType.getDBType(n);
        if (eRColumn.isPrimaryKey() && !string.equals("numeric") && this.isIdentityColumn(eRColumn, dialect)) {
            return true;
        }
        if (eRColumn.isForeignKey() && (eRColumn2 = eRColumn.getModel().getColumnByFullName(eRColumn.getReferencedColumn())) != null) {
            return this.isSybaseIdentityColumn(eRColumn2, n, dialect);
        }
        return false;
    }

    private boolean isIdentityColumn(ERColumn eRColumn, Dialect dialect) {
        String string = DDLGeneratorUtil.getIDGenerator(eRColumn.getIdGenerator(), dialect, DBTypeUtil.isIntType(eRColumn.getType()));
        return string != null && string.equals("identity");
    }

    private int getPKCount(EREntity eREntity) {
        int n = 0;
        Iterator<ERElement> iterator = eREntity.elementIterator();
        while (iterator.hasNext()) {
            ERColumn eRColumn = (ERColumn)iterator.next();
            if (!eRColumn.isPrimaryKey()) continue;
            ++n;
        }
        return n;
    }

    public String generateDropSQL(EREntity eREntity, Dialect dialect) {
        int n = eREntity.getModel().getQuoteSQLIdentifier();
        StringBuffer stringBuffer = new StringBuffer(this._ddlGenerator.convertKeywordCase("drop table "));
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append(this._ddlGenerator.convertKeywordCase("if exists "));
        }
        stringBuffer.append(DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, n)).append(this._ddlGenerator.convertKeywordCase(dialect.getCascadeConstraintsString()));
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(this._ddlGenerator.convertKeywordCase(" if exists"));
        }
        return stringBuffer.toString();
    }

    public String convertDefaultValue(ERColumn eRColumn, int n, Dialect dialect) {
        String string = eRColumn.getDefaultValue();
        if (string != null && string.length() > 0) {
            Object object;
            if (n == 256 && (object = eRColumn.getUserType(n)) != null && ("smallserial".equalsIgnoreCase((String)object) || "serial".equalsIgnoreCase((String)object) || "bigserial".equalsIgnoreCase((String)object))) {
                return "";
            }
            object = DBTypeUtil.getDBTypeByID(eRColumn.getType());
            int n2 = ((DBType)object).getTypeGroup();
            if (n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6 && n2 != 7 && n2 != 2 && n2 != 1) {
                String string2 = ((DBType)object).getDBType(n);
                if (("uniqueidentifier".equals(string2) || "uuid".equals(string2)) && string.endsWith("()")) {
                    return string;
                }
                if (n2 == 0 && (n == 2 || n == 0x100000 || n == 0x1000000)) {
                    return string;
                }
                if (n2 == 0 && (n == 8 || n == 1024) && ("0".equals(string) || "1".equals(string))) {
                    return string;
                }
                if (!(n2 != 9 && n2 != 15 && n2 != 10 || Character.isDigit(string.charAt(0)))) {
                    return string;
                }
                if (n2 == 0 && (n == 512 || n == 16)) {
                    if (string.toLowerCase().equals("true")) {
                        return "1";
                    }
                    if (string.toLowerCase().equals("false")) {
                        return "0";
                    }
                    return string;
                }
                String string3 = this.removeBracket(string);
                if (string3.startsWith("'") || string3.endsWith("'")) {
                    return string;
                }
                String string4 = string.toLowerCase();
                if (string4.lastIndexOf(46) > 0) {
                    string4 = string4.substring(string4.lastIndexOf(46) + 1);
                }
                if (string4.indexOf(40) > 0) {
                    string4 = string4.substring(0, string4.indexOf(40));
                }
                if (dialect.getFunctions().containsKey(string4.trim()) || this.isFunction(dialect, string4.trim())) {
                    return string;
                }
                boolean bl = string.trim().startsWith("'");
                boolean bl2 = string.trim().endsWith("'");
                if (!bl) {
                    string = "'" + string;
                }
                if (!bl2) {
                    string = string + "'";
                }
            }
        }
        return string;
    }

    private boolean isFunction(Dialect dialect, String string) {
        if (dialect instanceof PostgreSQL81Dialect) {
            return "gen_random_uuid".equals(string) || "uuid_generate_v4".equals(string);
        }
        return false;
    }

    private String removeBracket(String string) {
        if (string == null || string.length() < 2) {
            return string;
        }
        String string2 = string;
        while (string2.startsWith("(") && string2.endsWith(")")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    private String removeExtraCharFromDBDefaultValue(String string, Dialect dialect) {
        String string2 = string;
        if (string2 != null && string2.length() > 0) {
            if (dialect instanceof PostgreSQLDialect) {
                if (string2.endsWith("::character varying")) {
                    string2 = string2.replaceAll("::character varying", "");
                    string2 = string2.replaceAll("\\\\'", "'");
                    string2 = string2.substring(1, string2.length() - 1);
                }
            } else if (dialect instanceof SQLServerDialect) {
                if (string2.startsWith("('") && string2.endsWith("')")) {
                    string2 = string2.substring(2, string2.length() - 2);
                    string2 = string2.replaceAll("''", "'");
                } else if (string2.startsWith("((") && string2.endsWith("))")) {
                    string2 = string2.substring(2, string2.length() - 2);
                } else if (string2.startsWith("(") && string2.endsWith(")")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
            } else if ((dialect instanceof DB2Dialect || dialect instanceof HSQLDialect || dialect instanceof Oracle9Dialect || dialect instanceof Oracle8iDialect || dialect instanceof SybaseDialect) && string2.startsWith("'") && string2.endsWith("'")) {
                string2 = string2.substring(1, string2.length() - 1);
                string2 = string2.replaceAll("''", "'");
            }
        }
        return string2;
    }

    public String[] generateComment(EREntity eREntity, Dialect dialect, Connection connection, boolean bl, TableMetadata tableMetadata) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._ddlGenerator.getDdlOption().isGenerateCommment() && dialect.supportsCommentOn() || bl && dialect instanceof MySQLDialect) {
            Object object;
            int n = eREntity.getModel().getQuoteSQLIdentifier();
            String string = DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, n);
            String string2 = eREntity.getComment();
            if (!(string2 == null || string2.length() <= 0 || tableMetadata != null && tableMetadata.getRemarks() != null && tableMetadata.getRemarks().trim().equals(string2.trim()))) {
                string2 = string2.replaceAll("'", "''");
                if (dialect instanceof SQLServerDialect) {
                    arrayList.add(this.generateSqlServerComment(string2, eREntity.getSchema(), eREntity.getName(), null, connection));
                } else if (dialect instanceof MySQLDialect) {
                    object = new StringBuffer().append(this._ddlGenerator.convertKeywordCase("alter table ")).append(string).append(this._ddlGenerator.convertKeywordCase(" comment = '")).append(string2).append("'");
                    arrayList.add(((StringBuffer)object).toString());
                } else {
                    object = new StringBuffer().append(this._ddlGenerator.convertKeywordCase("comment on table ")).append(string).append(this._ddlGenerator.convertKeywordCase(" is '")).append(string2).append("'");
                    arrayList.add(((StringBuffer)object).toString());
                }
            }
            object = eREntity.elementIterator();
            while (object.hasNext()) {
                ColumnMetadata columnMetadata;
                ERElement eRElement = object.next();
                if (!(eRElement instanceof ERColumn)) continue;
                ERColumn eRColumn = (ERColumn)eRElement;
                String string3 = eRColumn.getComment();
                ColumnMetadata columnMetadata2 = columnMetadata = tableMetadata == null ? null : tableMetadata.getColumnMetadata(eRColumn.getName());
                if (string3 == null || string3.length() <= 0 || columnMetadata != null && columnMetadata.getRemarks() != null && columnMetadata.getRemarks().trim().equals(string3.trim())) continue;
                string3 = string3.replaceAll("'", "''");
                if (dialect instanceof SQLServerDialect) {
                    arrayList.add(this.generateSqlServerComment(string3, eREntity.getSchema(), eREntity.getName(), eRColumn.getName(), connection));
                    continue;
                }
                if (dialect instanceof MySQLDialect) {
                    int n2 = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
                    StringBuffer stringBuffer = new StringBuffer().append(this._ddlGenerator.convertKeywordCase("alter table ")).append(string).append(" ").append(dialect.getAlterColumnDefinitionString(DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n), this.getColumnDefinition(eRColumn, eRColumn.getName(), n2, dialect, this.getPKCount(eREntity), true, null)));
                    arrayList.add(stringBuffer.toString());
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer().append(this._ddlGenerator.convertKeywordCase("comment on column ")).append(string).append('.').append(DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n)).append(this._ddlGenerator.convertKeywordCase(" is '")).append(string3).append("'");
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String generateSqlServerComment(String string, String string2, String string3, String string4, Connection connection) {
        Object object;
        if (string2 == null || string2.length() == 0) {
            string2 = "dbo";
        }
        boolean bl = false;
        if (connection != null) {
            try {
                ResultSet resultSet;
                object = connection.createStatement();
                String string5 = "NULL";
                String string6 = "NULL";
                if (string4 != null) {
                    string5 = "N'column'";
                    string6 = "N'" + string4 + "'";
                }
                if ((resultSet = object.executeQuery("select count(*) from fn_listextendedproperty (N'MS_Description', N'schema', N'" + string2 + "', N'table', '" + string3 + "', " + string5 + ", " + string6 + ");")).next() && resultSet.getInt(1) > 0) {
                    bl = true;
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        object = new StringBuffer().append(this._ddlGenerator.convertKeywordCase("exec "));
        if (bl) {
            ((StringBuffer)object).append("sp_updateextendedproperty ");
        } else {
            ((StringBuffer)object).append("sp_addextendedproperty ");
        }
        if (this._ddlGenerator.isFormattedSQL()) {
            ((StringBuffer)object).append("\n  ");
        }
        ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("@name = ")).append("N'MS_Description', ").append(this._ddlGenerator.convertKeywordCase("@value = ")).append("N'").append(string.replaceAll("\n", "\r\n")).append("', ");
        if (this._ddlGenerator.isFormattedSQL()) {
            ((StringBuffer)object).append("\n  ");
        }
        ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("@level0type = ")).append("N'Schema', ").append(this._ddlGenerator.convertKeywordCase("@level0name = ")).append("N'").append(string2).append("', ");
        if (this._ddlGenerator.isFormattedSQL()) {
            ((StringBuffer)object).append("\n  ");
        }
        ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("@level1type = ")).append("N'Table', ").append(this._ddlGenerator.convertKeywordCase("@level1name = ")).append("N'").append(string3).append("'");
        if (string4 != null) {
            ((StringBuffer)object).append(", ");
            if (this._ddlGenerator.isFormattedSQL()) {
                ((StringBuffer)object).append("\n  ");
            }
            ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("@level2type = ")).append("N'Column', ").append(this._ddlGenerator.convertKeywordCase("@level2name = ")).append("N'").append(string4).append("'");
        }
        return ((StringBuffer)object).toString();
    }
}

