/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import java.util.Arrays;

public class SQLReservedWordChecker {
    private static SQLReservedWordChecker _checker = null;
    private final String[] reservedWords = new String[]{"add", "all", "alter", "and", "any", "as", "asc", "authorization", "backup", "begin", "between", "binary", "break", "browse", "bulk", "by", "cascade", "case", "check", "checkpoint", "close", "clustered", "coalesce", "collate", "column", "commit", "compute", "condition", "constraint", "contains", "containstable", "continue", "convert", "create", "cross", "current", "current_date", "current_time", "current_timestamp", "current_user", "cursor", "database", "date", "dbcc", "deallocate", "declare", "default", "delete", "deny", "desc", "disk", "distinct", "distributed", "double", "drop", "dump", "else", "end", "errlvl", "escape", "except", "exec", "execute", "exists", "exit", "external", "fetch", "file", "fillfactor", "for", "foreign", "freetext", "freetexttable", "from", "full", "fulltext", "function", "goto", "grant", "group", "having", "holdlock", "identity", "identity_insert", "identitycol", "if", "ignore", "in", "index", "inner", "insert", "intersect", "into", "is", "join", "key", "kill", "left", "like", "lineno", "load", "merge", "national", "nocheck", "nonclustered", "not", "null", "nullif", "of", "off", "offsets", "on", "open", "opendatasource", "openquery", "openrowset", "openxml", "option", "or", "order", "outer", "over", "percent", "pivot", "plan", "precision", "primary", "print", "proc", "procedure", "public", "purge", "raiserror", "read", "readtext", "reconfigure", "references", "replication", "restore", "restrict", "return", "revert", "revoke", "right", "rollback", "rowcount", "rowguidcol", "rowid", "rule", "save", "schema", "securityaudit", "select", "semantickeyphrasetable", "semanticsimilaritydetailstable", "semanticsimilaritytable", "session", "session_user", "set", "setuser", "shutdown", "size", "some", "start", "statistics", "system_user", "table", "tablesample", "tag", "textsize", "then", "to", "top", "tran", "transaction", "trigger", "truncate", "try_convert", "tsequal", "union", "unique", "unpivot", "update", "updatetext", "use", "user", "values", "varying", "view", "waitfor", "when", "where", "while", "with", "writetext", "xor"};

    private SQLReservedWordChecker() {
        Arrays.sort(this.reservedWords);
    }

    public static synchronized SQLReservedWordChecker getInstance() {
        if (_checker == null) {
            _checker = new SQLReservedWordChecker();
        }
        return _checker;
    }

    public boolean isReservedWord(String string) {
        return Arrays.binarySearch(this.reservedWords, string.toLowerCase()) >= 0;
    }
}

