/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import java.util.Vector;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseDialect;
import org.orm.ermodel.ERProcedure;
import org.orm.ertodb.DDLGenerator;
import org.orm.ertodb.decorator.Decorator;
import org.orm.ertodb.decorator.MSSQLDecorator;
import org.orm.ertodb.decorator.MySQLDecorator;
import org.orm.ertodb.decorator.OracleDecorator;
import org.orm.ertodb.decorator.PostgreSQLDecorator;
import org.orm.ertodb.decorator.StandardDecorator;
import org.orm.ertodb.decorator.SybaseDecorator;

public class ProcedureDDLGenerator {
    protected Dialect _dialect;
    protected Decorator _decorator;
    protected final DDLGenerator _generator;

    public ProcedureDDLGenerator(DDLGenerator dDLGenerator) {
        this._generator = dDLGenerator;
    }

    public Dialect getDialect() {
        return this._dialect;
    }

    public void setDialect(Dialect dialect) {
        this._dialect = dialect;
        this._decorator = ProcedureDDLGenerator.getSQLDecorator(this._dialect, this._generator.isUpperCaseSQL());
    }

    public String[] generateCreateDDL(ERProcedure[] eRProcedureArray, int n) {
        return this._decorator.decorateCreateSQL(ProcedureDDLGenerator.filterProcedures(eRProcedureArray), this._dialect, n);
    }

    public String[] generateDropDDL(ERProcedure[] eRProcedureArray, int n) {
        return this._decorator.decorateDropSQL(ProcedureDDLGenerator.filterProcedures(eRProcedureArray), this._dialect, n);
    }

    public String[] generateUpdateDDL(ERProcedure[] eRProcedureArray, int n) {
        return this._decorator.decorateAlterSQL(ProcedureDDLGenerator.filterProcedures(eRProcedureArray), this._dialect, n);
    }

    protected static ERProcedure[] filterProcedures(ERProcedure[] eRProcedureArray) {
        Vector<ERProcedure> vector = new Vector<ERProcedure>(eRProcedureArray.length);
        int n = eRProcedureArray.length;
        for (int i = 0; i < n; ++i) {
            if (eRProcedureArray[i] == null || eRProcedureArray[i].getStatements() == null || "".equals(eRProcedureArray[i].getStatements().trim())) continue;
            vector.add(eRProcedureArray[i]);
        }
        return vector.toArray(new ERProcedure[vector.size()]);
    }

    public static Decorator getSQLDecorator(Dialect dialect, boolean bl) {
        if (dialect instanceof MySQLDialect) {
            return new MySQLDecorator(bl);
        }
        if (dialect instanceof Oracle9Dialect || dialect instanceof Oracle8iDialect) {
            return new OracleDecorator(bl);
        }
        if (dialect instanceof SQLServerDialect) {
            return new MSSQLDecorator(bl);
        }
        if (dialect instanceof SybaseDialect) {
            return new SybaseDecorator(bl);
        }
        if (dialect instanceof PostgreSQLDialect) {
            return new PostgreSQLDecorator(bl);
        }
        return new StandardDecorator(bl);
    }
}

