/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import java.util.HashSet;
import java.util.Set;
import org.orm.ertodb.metadata.ColumnMetadata;
import org.orm.ertodb.metadata.ForeignKeyMetadata;
import org.orm.ertodb.metadata.TableMetadata;

public class DropSchemaContext {
    private Set<String> _droppedFK;
    private Set<String> _recreateFK;
    private Set<String> _droppedPK;

    public void droppedFK(String string) {
        if (this._droppedFK == null) {
            this._droppedFK = new HashSet<String>();
        }
        this._droppedFK.add(string);
    }

    public boolean isFKDropped(String string) {
        if (this._droppedFK != null) {
            return this._droppedFK.contains(string);
        }
        return false;
    }

    public void droppedPK(String string) {
        if (this._droppedPK == null) {
            this._droppedPK = new HashSet<String>();
        }
        this._droppedPK.add(string);
    }

    public boolean isPKDropped(String string) {
        if (this._droppedPK != null) {
            return this._droppedPK.contains(string);
        }
        return false;
    }

    public void markRecreateFK(String string) {
        if (this._recreateFK == null) {
            this._recreateFK = new HashSet<String>();
        }
        this._recreateFK.add(string);
    }

    public void unmarkRecreateFK(String string) {
        if (this._recreateFK != null) {
            this._recreateFK.remove(string);
        }
    }

    public boolean shouldRecreateFK(String string) {
        if (this._recreateFK != null) {
            return this._recreateFK.contains(string.toLowerCase());
        }
        return false;
    }

    public static String getFKKey(ForeignKeyMetadata foreignKeyMetadata) {
        ColumnMetadata[] columnMetadataArray;
        String string = foreignKeyMetadata.getName();
        if (string != null) {
            return string.toLowerCase();
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = foreignKeyMetadata.getPkTableSchema();
        if (string2 != null) {
            stringBuffer.append(string2).append(".");
        }
        stringBuffer.append(foreignKeyMetadata.getPkTable()).append(".");
        for (ColumnMetadata columnMetadata : columnMetadataArray = foreignKeyMetadata.getColumns()) {
            stringBuffer.append(columnMetadata.getName()).append(",");
        }
        return stringBuffer.toString();
    }

    public static String getPKKey(TableMetadata tableMetadata) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = tableMetadata.getSchema();
        if (string != null && string.length() > 0) {
            stringBuffer.append(string).append(".");
        }
        stringBuffer.append(tableMetadata.getName());
        return stringBuffer.toString();
    }
}

