/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.hibernate.dialect.Cache71Dialect;
import org.hibernate.dialect.DB2390Dialect;
import org.hibernate.dialect.DB2400Dialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.FirebirdDialect;
import org.hibernate.dialect.FrontBaseDialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.Ingres10Dialect;
import org.hibernate.dialect.Ingres9Dialect;
import org.hibernate.dialect.IngresDialect;
import org.hibernate.dialect.MySQL5Dialect;
import org.hibernate.dialect.MySQL5InnoDBDialect;
import org.hibernate.dialect.MySQL5MyISAMDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.MySQLInnoDBDialect;
import org.hibernate.dialect.MySQLMyISAMDialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.Oracle9iDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.ProgressDialect;
import org.hibernate.dialect.RedshiftDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SQLiteDialect;
import org.hibernate.dialect.Sybase11Dialect;
import org.hibernate.dialect.SybaseAnywhereDialect;
import org.hibernate.dialect.SybaseDialect;

public class DialectDBTypeMapper {
    private static DialectDBTypeMapper _instance = null;
    private Map<String, Integer> _dialectDBMap;
    private Map<Integer, Integer> _versionMap = new HashMap<Integer, Integer>();

    private DialectDBTypeMapper() {
        this._dialectDBMap = new Hashtable<String, Integer>();
        this._dialectDBMap.put(OracleDialect.class.getName(), new Integer(16));
        this._dialectDBMap.put(Oracle9Dialect.class.getName(), new Integer(16));
        this._dialectDBMap.put(Oracle8iDialect.class.getName(), new Integer(16));
        this._dialectDBMap.put(Oracle9iDialect.class.getName(), new Integer(16));
        this._dialectDBMap.put(Oracle10gDialect.class.getName(), new Integer(16));
        this._dialectDBMap.put(HSQLDialect.class.getName(), new Integer(32));
        this._dialectDBMap.put(MySQLDialect.class.getName(), new Integer(2));
        this._dialectDBMap.put(MySQLInnoDBDialect.class.getName(), new Integer(2));
        this._dialectDBMap.put(MySQL5Dialect.class.getName(), new Integer(2));
        this._dialectDBMap.put(MySQL5InnoDBDialect.class.getName(), new Integer(2));
        this._dialectDBMap.put(MySQLMyISAMDialect.class.getName(), new Integer(2));
        this._dialectDBMap.put(MySQL5MyISAMDialect.class.getName(), new Integer(2));
        this._dialectDBMap.put(SQLServerDialect.class.getName(), new Integer(8));
        this._dialectDBMap.put(Sybase11Dialect.class.getName(), new Integer(64));
        this._dialectDBMap.put(SybaseDialect.class.getName(), new Integer(64));
        this._dialectDBMap.put(SybaseAnywhereDialect.class.getName(), new Integer(128));
        this._dialectDBMap.put(DerbyDialect.class.getName(), new Integer(512));
        this._dialectDBMap.put(DB2Dialect.class.getName(), new Integer(1024));
        this._dialectDBMap.put(DB2400Dialect.class.getName(), new Integer(1024));
        this._dialectDBMap.put(DB2390Dialect.class.getName(), new Integer(1024));
        this._dialectDBMap.put(PostgreSQLDialect.class.getName(), new Integer(256));
        this._dialectDBMap.put(InformixDialect.class.getName(), new Integer(2048));
        this._dialectDBMap.put(IngresDialect.class.getName(), new Integer(4096));
        this._dialectDBMap.put(Ingres9Dialect.class.getName(), new Integer(4096));
        this._dialectDBMap.put(Ingres10Dialect.class.getName(), new Integer(0x800000));
        this._dialectDBMap.put(ProgressDialect.class.getName(), new Integer(8192));
        this._dialectDBMap.put(FirebirdDialect.class.getName(), new Integer(16384));
        this._dialectDBMap.put(FrontBaseDialect.class.getName(), new Integer(65536));
        this._dialectDBMap.put(Cache71Dialect.class.getName(), new Integer(131072));
        this._dialectDBMap.put(SQLiteDialect.class.getName(), new Integer(262144));
        this._dialectDBMap.put(H2Dialect.class.getName(), new Integer(524288));
        this._dialectDBMap.put(RedshiftDialect.class.getName(), new Integer(0x2000000));
    }

    public static synchronized DialectDBTypeMapper instance() {
        if (_instance == null) {
            _instance = new DialectDBTypeMapper();
        }
        return _instance;
    }

    public void mapVersion(int n, int n2) {
        this._versionMap.put(new Integer(n), new Integer(n2));
    }

    public int getDBType(String string) {
        Integer n = this._dialectDBMap.get(string);
        Integer n2 = this._versionMap.get(n);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public int getDBType(String string, String string2) {
        if ("org.mariadb.jdbc.Driver".equals(string2)) {
            return 0x1000000;
        }
        return this.getDBType(string);
    }
}

