/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import org.hibernate.dialect.Dialect;
import org.orm.ertodb.SQLReservedWordChecker;

public class DDLGeneratorUtil {
    private DDLGeneratorUtil() {
    }

    public static String getQualifiedName(String string, String string2, Dialect dialect, int n) {
        String string3 = DDLGeneratorUtil.quoteName(string, dialect, n);
        String string4 = DDLGeneratorUtil.quoteName(string2, dialect, n);
        if (string3 == null || string3.length() == 0) {
            return string4;
        }
        return string3 + "." + string4;
    }

    public static String quoteName(String string, Dialect dialect, int n) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (n == 2 || n == 1 && (SQLReservedWordChecker.getInstance().isReservedWord(string) || !DDLGeneratorUtil.isValidSQLName(string))) {
            return dialect.openQuote() + string + dialect.closeQuote();
        }
        return string;
    }

    public static boolean isValidSQLName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            boolean bl;
            char c = string.charAt(i);
            boolean bl2 = bl = Character.isLetterOrDigit(c) || c == '_';
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static String getIDGeneratorKey(String string, String string2, String string3, String string4) {
        if (string4 != null && string4.length() > 0) {
            return string4;
        }
        if (string3.equals("sequence") || string3.equals("seqhilo")) {
            if (string != null && string.length() > 0) {
                return string + ".seq_" + string2.replaceAll(" ", "_");
            }
            return "seq_" + string2.replaceAll(" ", "_");
        }
        if (string3.equals("hilo")) {
            if (string != null && string.length() > 0) {
                return string + ".id_" + string2.replaceAll(" ", "_");
            }
            return "id_" + string2.replaceAll(" ", "_");
        }
        return null;
    }

    public static String getIDGenerator(String string, Dialect dialect, boolean bl) {
        if (string.equals("native")) {
            if (bl) {
                if (dialect.supportsIdentityColumns()) {
                    return "identity";
                }
                if (dialect.supportsSequences()) {
                    return "sequence";
                }
                return "hilo";
            }
            return "assigned";
        }
        return string;
    }

    public static String getDefaultIDTableColumnName() {
        return "next_hi";
    }
}

