/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.internal.util.StringHelper;
import org.orm.ProgressMonitor;
import org.orm.ermodel.ERColumn;
import org.orm.ermodel.ERElement;
import org.orm.ermodel.EREntity;
import org.orm.ermodel.ERForeignKey;
import org.orm.ermodel.ERFullTextIndex;
import org.orm.ermodel.ERFullTextIndexColumn;
import org.orm.ermodel.ERIndex;
import org.orm.ermodel.ERIndexColumn;
import org.orm.ermodel.ERModel;
import org.orm.ermodel.ERProcedure;
import org.orm.ermodel.ERSequence;
import org.orm.ermodel.ERTrigger;
import org.orm.ermodel.ERView;
import org.orm.ertodb.DDLGeneratorUtil;
import org.orm.ertodb.DDLOptions;
import org.orm.ertodb.DDLStatementCollection;
import org.orm.ertodb.DialectDBTypeMapper;
import org.orm.ertodb.DropSchemaContext;
import org.orm.ertodb.ForeignKeyDDLGenerator;
import org.orm.ertodb.IndexInfo;
import org.orm.ertodb.ProcedureDDLGenerator;
import org.orm.ertodb.SQLReservedWordChecker;
import org.orm.ertodb.SequenceDDLGenerator;
import org.orm.ertodb.TableDDLGenerator;
import org.orm.ertodb.TriggerDDLGenerator;
import org.orm.ertodb.UniqueKeyInfo;
import org.orm.ertodb.ViewDDLGenerator;
import org.orm.ertodb.ViewDependencyAnalyzer;
import org.orm.ertodb.metadata.ColumnMetadata;
import org.orm.ertodb.metadata.DatabaseMetadata;
import org.orm.ertodb.metadata.ForeignKeyMetadata;
import org.orm.ertodb.metadata.IndexMetadata;
import org.orm.ertodb.metadata.TableMetadata;
import org.orm.ertodb.metadata.UniqueConstraintMetadata;
import org.orm.ormtypemapper.DBTypeUtil;

public class DDLGenerator {
    private TableDDLGenerator _tableDDLGenerator;
    private ForeignKeyDDLGenerator _foreignKeyDDLGenerator;
    private ViewDDLGenerator _viewDDLGenerator;
    private ProcedureDDLGenerator _procedureDDLGenerator;
    private TriggerDDLGenerator _triggerDDLGenerator;
    private SequenceDDLGenerator _sequenceDDLGenerator;
    private final DDLOptions _ddlOption;
    private boolean _upperCaseSQL;
    private boolean _formattedSQL;

    public DDLGenerator(DDLOptions dDLOptions) {
        this._ddlOption = dDLOptions;
        this._tableDDLGenerator = new TableDDLGenerator(this);
        this._foreignKeyDDLGenerator = new ForeignKeyDDLGenerator(this);
        this._procedureDDLGenerator = new ProcedureDDLGenerator(this);
        this._viewDDLGenerator = new ViewDDLGenerator(this);
        this._triggerDDLGenerator = new TriggerDDLGenerator(this);
        this._sequenceDDLGenerator = new SequenceDDLGenerator(this);
    }

    public DDLGenerator() {
        this(new DDLOptions(true, false));
    }

    DDLOptions getDdlOption() {
        return this._ddlOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSchema(String[] stringArray, String string) throws IOException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().toLowerCase().equals("go")) {
                    printWriter.println(stringArray[i]);
                    continue;
                }
                printWriter.println(stringArray[i] + ";");
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSchema(String[] stringArray, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().toLowerCase().equals("go")) continue;
                statement.executeUpdate(stringArray[i]);
            }
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createProcedures(ERModel eRModel, Dialect dialect) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<String[]> vector = new Vector<String[]>(5);
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            if (!(stringArray instanceof ERProcedure)) continue;
            vector.add(stringArray);
        }
        int n = eRModel.getQuoteSQLIdentifier();
        this._procedureDDLGenerator.setDialect(dialect);
        stringArray = this._procedureDDLGenerator.generateCreateDDL(vector.toArray(new ERProcedure[vector.size()]), n);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createTriggers(ERModel eRModel, Dialect dialect) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<String[]> vector = new Vector<String[]>(5);
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            if (!(stringArray instanceof ERTrigger)) continue;
            vector.add(stringArray);
        }
        int n = eRModel.getQuoteSQLIdentifier();
        this._triggerDDLGenerator.setDialect(dialect);
        stringArray = this._triggerDDLGenerator.generateCreateDDL(vector.toArray(new ERTrigger[vector.size()]), n);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createSequences(ERModel eRModel, Dialect dialect) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<String[]> vector = new Vector<String[]>(5);
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            if (!(stringArray instanceof ERSequence)) continue;
            vector.add(stringArray);
        }
        int n = eRModel.getQuoteSQLIdentifier();
        this._sequenceDDLGenerator.setDialect(dialect);
        stringArray = this._sequenceDDLGenerator.generateCreateDDL(vector.toArray(new ERSequence[vector.size()]), n);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public DDLStatementCollection createSchema(ERModel eRModel, Dialect dialect) throws HibernateException, SQLException {
        return this.createSchema(eRModel, dialect, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDLStatementCollection createSchema(ERModel eRModel, Dialect dialect, ProgressMonitor progressMonitor) throws HibernateException, SQLException {
        ERIndexColumn[] eRIndexColumnArray2;
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String[] stringArray2;
        int n = 0;
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            ERElement eRElement = iterator.next();
            if (!(eRElement instanceof EREntity) && !(eRElement instanceof ERView) && !(eRElement instanceof ERForeignKey)) continue;
            ++n;
        }
        progressMonitor.maxProgressCalculated(n);
        int n2 = 0;
        boolean bl = dialect instanceof PostgreSQLDialect;
        DDLStatementCollection dDLStatementCollection = new DDLStatementCollection();
        if (bl) {
            stringArray2 = this.generateTablesForIDGenerator(eRModel, dialect, null, eRModel.getQuoteSQLIdentifier());
            for (int i = 0; i < stringArray2.length; ++i) {
                dDLStatementCollection.addUnknownStatement(stringArray2[i]);
            }
        }
        stringArray2 = new HashMap();
        if (dialect.createForeignKeyInCreateTable()) {
            Iterator<ERElement> iterator2 = eRModel.elementIterator();
            while (iterator2.hasNext()) {
                object5 = iterator2.next();
                if (!(object5 instanceof ERForeignKey)) continue;
                object4 = ((ERForeignKey)object5).getReferenceTable();
                object3 = (ArrayList)stringArray2.get(object4);
                if (object3 == null) {
                    object3 = new ArrayList();
                    stringArray2.put(object4, object3);
                }
                object3.add(object5);
            }
        }
        Object object6 = eRModel.elementIterator();
        while (object6.hasNext()) {
            object5 = object6.next();
            if (!(object5 instanceof EREntity)) continue;
            object4 = (ArrayList)stringArray2.get(((ERElement)object5).getName());
            this._tableDDLGenerator.generateCreateDDL(dDLStatementCollection, (EREntity)object5, dialect, object4 == null ? null : ((ArrayList)object4).toArray(new ERForeignKey[((ArrayList)object4).size()]));
            object3 = this._tableDDLGenerator.generateComment((EREntity)object5, dialect, null, false, null);
            for (int i = 0; i < ((String[])object3).length; ++i) {
                dDLStatementCollection.addTableStatement(object3[i]);
            }
            progressMonitor.progressUpdate(++n2);
        }
        object6 = new ArrayList();
        object5 = eRModel.elementIterator();
        while (object5.hasNext()) {
            object4 = (ERElement)object5.next();
            if (!(object4 instanceof ERView) || ((ERView)object4).getCreateStmt() == null) continue;
            object6.add(object4);
        }
        ViewDependencyAnalyzer.reorder((List<ERElement>)object6, dialect);
        object5 = object6.iterator();
        while (object5.hasNext()) {
            object4 = (ERView)object5.next();
            object3 = ((ERView)object4).getCreateStmt();
            dDLStatementCollection.addViewStatement((String)object3);
            progressMonitor.progressUpdate(++n2);
        }
        int n3 = eRModel.getQuoteSQLIdentifier();
        object4 = new ArrayList<Object>();
        object3 = eRModel.elementIterator();
        while (object3.hasNext()) {
            Object object7;
            Object object8;
            Object object9;
            ERElement eRElement = (ERElement)object3.next();
            if (!(eRElement instanceof EREntity)) continue;
            object2 = (EREntity)eRElement;
            if (!dialect.supportsUniqueConstraintInCreateAlterTable()) {
                object = ((EREntity)object2).uniqueKeysIterator();
                while (object.hasNext()) {
                    stringArray = (String)object.next();
                    object9 = new StringBuffer(this.convertKeywordCase("create unique index "));
                    ((StringBuffer)object9).append((String)(dialect.qualifyIndexName() && !(dialect instanceof PostgreSQLDialect) ? stringArray : StringHelper.unqualify((String)stringArray))).append(this.convertKeywordCase(" on ")).append(DDLGeneratorUtil.getQualifiedName(((EREntity)object2).getSchema(), ((ERElement)object2).getName(), dialect, n3)).append(" (");
                    object8 = ((EREntity)object2).uniqueKeyColumnsIterator((String)stringArray);
                    while (object8.hasNext()) {
                        ((StringBuffer)object9).append(DDLGeneratorUtil.quoteName((String)object8.next(), dialect, n3));
                        if (!object8.hasNext()) continue;
                        ((StringBuffer)object9).append(", ");
                    }
                    ((StringBuffer)object9).append(")");
                    dDLStatementCollection.addIndexStatement(((StringBuffer)object9).toString());
                }
            }
            object = new HashSet();
            stringArray = ((EREntity)object2).indicesIterator();
            while (stringArray.hasNext()) {
                object9 = (ERIndex)stringArray.next();
                object8 = ((ERIndex)object9).getName();
                if (((HashSet)object).contains(object8)) continue;
                ((HashSet)object).add(object8);
                eRIndexColumnArray2 = new IndexInfo((String)object8, ((ERIndex)object9).isUnique(), ((ERIndex)object9).isFullText(), ((ERIndex)object9).isBitmap(), ((ERElement)object2).getName(), ((EREntity)object2).getSchema(), ((ERIndex)object9).getTablespace(), ((ERIndex)object9).getFunction(), ((ERIndex)object9).getClustered(), ((ERIndex)object9).getCriteria(), ((ERIndex)object9).getDdlClauses(), ((ERIndex)object9).getComment());
                object7 = ((ERIndex)object9).columnIterator();
                while (object7.hasNext()) {
                    eRIndexColumnArray2.addColumn((ERIndexColumn)object7.next());
                }
                object4.add(eRIndexColumnArray2);
            }
            if (dialect.supportsIndexConstraintInCreateAlterTable()) continue;
            object9 = ((EREntity)object2).elementIterator();
            while (object9.hasNext()) {
                object8 = object9.next();
                if (!(object8 instanceof ERColumn) || !(eRIndexColumnArray2 = (ERColumn)object8).isIndex() || ((HashSet)object).contains(object7 = this._ddlOption.getUnnamedIndexName(((ERElement)object2).getName(), eRIndexColumnArray2.getName()))) continue;
                ((HashSet)object).add(object7);
                IndexInfo indexInfo = new IndexInfo((String)object7, eRIndexColumnArray2.isUnique(), false, false, ((ERElement)object2).getName(), ((EREntity)object2).getSchema(), null, null, 0, null, null, null);
                indexInfo.addColumn(new ERIndexColumn(eRIndexColumnArray2.getName()));
                object4.add(indexInfo);
            }
        }
        int n4 = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
        if (n4 != 0x2000000) {
            Iterator iterator3 = object4.iterator();
            while (iterator3.hasNext()) {
                object2 = (IndexInfo)iterator3.next();
                object = this.generateCreateIndex(dialect, n3, (IndexInfo)object2);
                for (ERIndexColumn[] eRIndexColumnArray2 : object) {
                    dDLStatementCollection.addIndexStatement((String)eRIndexColumnArray2);
                }
            }
        }
        if (n4 == 8 || n4 == 0x200000) {
            Iterator<ERElement> iterator4 = eRModel.elementIterator();
            while (iterator4.hasNext()) {
                object2 = iterator4.next();
                if (!(object2 instanceof EREntity) || (object = ((EREntity)object2).getFullTextIndex()) == null) continue;
                dDLStatementCollection.addIndexStatement(this.generateCreateFullTextIndex(dialect, n3, (EREntity)object2, (ERFullTextIndex)object));
            }
        }
        if (!bl) {
            String[] stringArray3 = this.generateTablesForIDGenerator(eRModel, dialect, null, n3);
            for (int i = 0; i < stringArray3.length; ++i) {
                dDLStatementCollection.addUnknownStatement(stringArray3[i]);
            }
        }
        Object object10 = eRModel.elementIterator();
        block19: while (object10.hasNext()) {
            ERElement eRElement = object10.next();
            if (!(eRElement instanceof ERForeignKey) || !dialect.hasAlterTable()) continue;
            object = this._foreignKeyDDLGenerator.generateDDL((ERForeignKey)eRElement, dialect);
            if (object != null) {
                dDLStatementCollection.addFKStatement((String)object);
            }
            progressMonitor.progressUpdate(++n2);
            if (!(dialect instanceof MySQLDialect)) continue;
            stringArray = ((ERForeignKey)eRElement).getColumns();
            Iterator iterator5 = object4.iterator();
            while (iterator5.hasNext()) {
                IndexInfo indexInfo = (IndexInfo)iterator5.next();
                if (indexInfo.isUnique() || stringArray.length != (eRIndexColumnArray2 = indexInfo.getColumns()).length) continue;
                boolean bl2 = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals(eRIndexColumnArray2[i].getColumnName()) && eRIndexColumnArray2[i].getOrder() != 2) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                object4.remove(indexInfo);
                continue block19;
            }
        }
        object10 = dDLStatementCollection;
        return object10;
    }

    private String generateCreateFullTextIndex(Dialect dialect, int n, EREntity eREntity, ERFullTextIndex eRFullTextIndex) {
        String string;
        Object object;
        StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("create fulltext index on "));
        stringBuffer.append(DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, n));
        Iterator<ERFullTextIndexColumn> iterator = eRFullTextIndex.columnIterator();
        if (iterator.hasNext()) {
            stringBuffer.append(" (");
            while (iterator.hasNext()) {
                object = iterator.next();
                stringBuffer.append(DDLGeneratorUtil.quoteName(((ERFullTextIndexColumn)object).getColumnName(), dialect, n));
                string = ((ERFullTextIndexColumn)object).getOption();
                if (string != null && string.length() > 0) {
                    stringBuffer.append(" ").append(string);
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(this.convertKeywordCase(" key index "));
        stringBuffer.append(eRFullTextIndex.getKeyIndex());
        object = eRFullTextIndex.getFulltextCatalogName();
        string = eRFullTextIndex.getFilegroup();
        if (string == null || string.length() == 0) {
            if (object != null && ((String)object).length() > 0) {
                stringBuffer.append(this.convertKeywordCase(" on "));
                stringBuffer.append((String)object);
            }
        } else if (object == null || ((String)object).length() == 0) {
            stringBuffer.append(this.convertKeywordCase(" on (filegroup "));
            stringBuffer.append(DDLGeneratorUtil.quoteName(string, dialect, n));
            stringBuffer.append(")");
        } else {
            stringBuffer.append(this.convertKeywordCase(" on ("));
            stringBuffer.append((String)object);
            stringBuffer.append(this.convertKeywordCase(", filegroup "));
            stringBuffer.append(DDLGeneratorUtil.quoteName(string, dialect, n));
            stringBuffer.append(")");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = eRFullTextIndex.getChangeTracking();
        String string3 = eRFullTextIndex.getStoplist();
        String string4 = eRFullTextIndex.getSearchPropertyList();
        if (string2 != null && string2.length() > 0) {
            stringBuffer2.append(this.convertKeywordCase("change_tracking = "));
            stringBuffer2.append(string2);
        }
        if (string3 != null && string3.length() > 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append(this.convertKeywordCase("stoplist = "));
            stringBuffer2.append(string3);
        }
        if (string4 != null && string4.length() > 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append(this.convertKeywordCase("search property list = "));
            stringBuffer2.append(string4);
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(this.convertKeywordCase(" with "));
            stringBuffer.append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    private String[] generateCreateIndex(Dialect dialect, int n, IndexInfo indexInfo) {
        String string;
        String string2;
        Object object;
        Object object2;
        int n2 = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
        String string3 = indexInfo.getFunction();
        if (string3 != null && string3.length() > 0 && !(n2 == 16 || n2 == 256 || n2 == 64)) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("create "));
        if (indexInfo.isUnique()) {
            stringBuffer.append(this.convertKeywordCase("unique "));
        } else if (indexInfo.isFulltext() && (n2 == 2 || n2 == 0x100000 || n2 == 0x1000000)) {
            stringBuffer.append(this.convertKeywordCase("fulltext "));
        } else if (indexInfo.isBitmap() && n2 == 16) {
            stringBuffer.append(this.convertKeywordCase("bitmap "));
        }
        int n3 = indexInfo.getClustered();
        if (n3 != 0) {
            if (n2 == 8 || n2 == 0x200000 || n2 == 64 || n2 == 128) {
                if (n3 == 1) {
                    stringBuffer.append(this.convertKeywordCase("clustered "));
                } else if (n3 == 2) {
                    stringBuffer.append(this.convertKeywordCase("nonclustered "));
                }
            } else if (n2 == 2048 && n3 == 1) {
                stringBuffer.append(this.convertKeywordCase("cluster "));
            }
        }
        stringBuffer.append(this.convertKeywordCase("index "));
        String string4 = indexInfo.getName();
        String string5 = dialect.qualifyIndexName() && !(dialect instanceof PostgreSQLDialect) ? DDLGeneratorUtil.getQualifiedName(indexInfo.getSchema(), StringHelper.unqualify(string4), dialect, n) : DDLGeneratorUtil.getQualifiedName(null, StringHelper.unqualify(string4), dialect, n);
        stringBuffer.append(string5);
        stringBuffer.append(" ");
        if (this._formattedSQL) {
            stringBuffer.append("\n  ");
        }
        stringBuffer.append(this.convertKeywordCase("on ")).append(DDLGeneratorUtil.getQualifiedName(indexInfo.getSchema(), indexInfo.getEntity(), dialect, n)).append(" (");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(string3);
        } else {
            object2 = indexInfo.columnIterator();
            while (object2.hasNext()) {
                object = object2.next();
                stringBuffer.append(DDLGeneratorUtil.quoteName(((ERIndexColumn)object).getColumnName(), dialect, n));
                if (((ERIndexColumn)object).getOrder() == 1) {
                    stringBuffer.append(" asc");
                } else if (((ERIndexColumn)object).getOrder() == 2) {
                    stringBuffer.append(" desc");
                }
                if (!object2.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(")");
        if ((n2 == 8 || n2 == 0x200000 || n2 == 256) && (object2 = indexInfo.getCriteria()) != null && ((String)object2).length() > 0) {
            stringBuffer.append(this.convertKeywordCase(" where "));
            stringBuffer.append((String)object2);
        }
        object2 = indexInfo.getTablespace();
        object = dialect.getCreateTableInTablespaceKeyword();
        if (object != null && object2 != null && ((String)object2).length() > 0) {
            stringBuffer.append(" ").append(this.convertKeywordCase((String)object)).append(" ").append((String)object2);
        }
        if (n3 != 0 && n2 == 1024 && n3 == 1) {
            stringBuffer.append(this.convertKeywordCase(" cluster"));
        }
        if ((string2 = indexInfo.getDdlClauses()) != null && string2.length() > 0) {
            stringBuffer.append(" ").append(string2);
        }
        arrayList.add(stringBuffer.toString());
        if (this._ddlOption.isGenerateCommment() && dialect.supportsCommentOn() && dialect instanceof PostgreSQL81Dialect && (string = indexInfo.getComment()) != null && string.length() > 0) {
            string = string.replaceAll("'", "''");
            StringBuffer stringBuffer2 = new StringBuffer().append(this.convertKeywordCase("comment on index ")).append(DDLGeneratorUtil.quoteName(indexInfo.getName(), dialect, n)).append(this.convertKeywordCase(" is '")).append(string).append("'");
            arrayList.add(stringBuffer2.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] dropProcedures(ERModel eRModel, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERProcedure)) continue;
            vector.add(eRElement);
        }
        this._procedureDDLGenerator.setDialect(dialect);
        stringArray = this._procedureDDLGenerator.generateDropDDL(vector.toArray(new ERProcedure[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] dropTriggers(ERModel eRModel, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERTrigger)) continue;
            vector.add(eRElement);
        }
        this._triggerDDLGenerator.setDialect(dialect);
        stringArray = this._triggerDDLGenerator.generateDropDDL(vector.toArray(new ERTrigger[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] dropSequences(ERModel eRModel, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERSequence)) continue;
            vector.add(eRElement);
        }
        this._sequenceDDLGenerator.setDialect(dialect);
        stringArray = this._sequenceDDLGenerator.generateDropDDL(vector.toArray(new ERSequence[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public DDLStatementCollection dropSchema(ERModel eRModel, Dialect dialect) {
        return this.dropSchema(eRModel, dialect, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDLStatementCollection dropSchema(ERModel eRModel, Dialect dialect, ProgressMonitor progressMonitor) {
        int n = 0;
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            ERElement eRElement = iterator.next();
            if (!(eRElement instanceof EREntity) && !(eRElement instanceof ERView) && !(eRElement instanceof ERForeignKey)) continue;
            ++n;
        }
        progressMonitor.maxProgressCalculated(n + 10);
        int n2 = 0;
        boolean bl = dialect instanceof PostgreSQLDialect;
        DDLStatementCollection dDLStatementCollection = new DDLStatementCollection();
        try {
            Object object;
            Object object2;
            if (!bl) {
                object2 = this.dropTablesForIDGenerator(eRModel, dialect);
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    dDLStatementCollection.addTableStatement((String)object2[i]);
                }
                progressMonitor.progressUpdate(n2 += 10);
            }
            if (dialect.dropConstraints()) {
                object2 = eRModel.elementIterator();
                while (object2.hasNext()) {
                    ERElement eRElement = (ERElement)object2.next();
                    if (!(eRElement instanceof ERForeignKey)) continue;
                    object = this._foreignKeyDDLGenerator.generateDropSQL((ERForeignKey)eRElement, dialect, eRElement.getName());
                    if (object != null) {
                        dDLStatementCollection.addFKStatement((String)object);
                    }
                    progressMonitor.progressUpdate(++n2);
                }
            }
            object2 = new ArrayList();
            String[] stringArray = eRModel.elementIterator();
            while (stringArray.hasNext()) {
                object = stringArray.next();
                if (!(object instanceof ERView)) continue;
                object2.add(object);
            }
            ViewDependencyAnalyzer.reorder((List<ERElement>)object2, dialect);
            Collections.reverse(object2);
            stringArray = object2.iterator();
            while (stringArray.hasNext()) {
                object = stringArray.next();
                dDLStatementCollection.addTableStatement(this._viewDDLGenerator.generateDropSQL((ERView)object, dialect));
                progressMonitor.progressUpdate(++n2);
            }
            stringArray = eRModel.elementIterator();
            while (stringArray.hasNext()) {
                object = stringArray.next();
                if (!(object instanceof EREntity)) continue;
                dDLStatementCollection.addTableStatement(this._tableDDLGenerator.generateDropSQL((EREntity)object, dialect));
                progressMonitor.progressUpdate(++n2);
            }
            if (bl) {
                stringArray = this.dropTablesForIDGenerator(eRModel, dialect);
                for (int i = 0; i < stringArray.length; ++i) {
                    dDLStatementCollection.addTableStatement(stringArray[i]);
                }
                progressMonitor.progressUpdate(n2 += 10);
            }
            stringArray = dDLStatementCollection;
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DDLStatementCollection dDLStatementCollection2 = null;
            return dDLStatementCollection2;
        }
    }

    private String[] dropTablesForIDGenerator(ERModel eRModel, Dialect dialect) {
        Object object;
        ERElement eRElement;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            eRElement = iterator.next();
            if (!(eRElement instanceof ERSequence)) continue;
            object = (ERSequence)eRElement;
            if (((ERSequence)object).getSchema() != null && ((ERSequence)object).getSchema().length() > 0) {
                hashSet.add(((ERSequence)object).getSchema() + "." + ((ERElement)object).getName());
                continue;
            }
            hashSet.add(eRElement.getName());
        }
        iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            String string;
            String string2;
            int n;
            Object object2;
            eRElement = iterator.next();
            if (!(eRElement instanceof EREntity)) continue;
            object = new ArrayList();
            Object object3 = ((EREntity)eRElement).elementIterator();
            while (object3.hasNext()) {
                ERColumn eRColumn;
                object2 = object3.next();
                if (!(object2 instanceof ERColumn) || !(eRColumn = (ERColumn)object2).isPrimaryKey() || eRColumn.isForeignKey()) continue;
                ((ArrayList)object).add(eRColumn);
            }
            if (((ArrayList)object).size() != 1 || !this.needTableForGenerator((String)(object2 = DDLGeneratorUtil.getIDGenerator(((ERColumn)(object3 = (ERColumn)((ArrayList)object).get(0))).getIdGenerator(), dialect, DBTypeUtil.isIntType(((ERColumn)object3).getType()))), dialect) || (n = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName())) == 256 && (string2 = ((ERColumn)object3).getUserType(256)) != null && ("smallserial".equalsIgnoreCase(string2) || "serial".equalsIgnoreCase(string2) || "bigserial".equalsIgnoreCase(string2)) || hashSet.contains(string = DDLGeneratorUtil.getIDGeneratorKey(string2 = ((ERColumn)object3).getEntity().getSchema(), ((ERColumn)object3).getEntity().getName(), (String)object2, ((ERColumn)object3).getIdGeneratorKey()))) continue;
            String string3 = string;
            if (string2 != null && string2.length() > 0 && (((ERColumn)object3).getIdGeneratorKey() == null || ((ERColumn)object3).getIdGeneratorKey().length() == 0)) {
                string3 = string3.substring(string2.length() + 1);
            } else {
                int n2 = string.indexOf(46);
                if (n2 > 0) {
                    string2 = string.substring(0, n2);
                    string3 = string.substring(n2 + 1);
                }
            }
            String string4 = DDLGeneratorUtil.quoteName(string3, dialect, eRModel.getQuoteSQLIdentifier());
            if (string2 != null && string2.length() > 0) {
                string4 = DDLGeneratorUtil.quoteName(string2, dialect, eRModel.getQuoteSQLIdentifier()) + "." + string4;
            }
            if ((stringArray = this.dropTableForIDGenerator((String)object2, string4, DDLGeneratorUtil.getDefaultIDTableColumnName(), dialect)) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
            }
            hashSet.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] updateProcedures(ERModel eRModel, Connection connection, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERProcedure)) continue;
            vector.add(eRElement);
        }
        this._procedureDDLGenerator.setDialect(dialect);
        stringArray = this._procedureDDLGenerator.generateUpdateDDL(vector.toArray(new ERProcedure[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] updateTriggers(ERModel eRModel, Connection connection, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERTrigger)) continue;
            vector.add(eRElement);
        }
        this._triggerDDLGenerator.setDialect(dialect);
        stringArray = this._triggerDDLGenerator.generateUpdateDDL(vector.toArray(new ERTrigger[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] updateSequences(ERModel eRModel, Connection connection, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERSequence)) continue;
            vector.add(eRElement);
        }
        this._sequenceDDLGenerator.setDialect(dialect);
        stringArray = this._sequenceDDLGenerator.generateUpdateDDL(vector.toArray(new ERSequence[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public DDLStatementCollection updateSchema(ERModel eRModel, Connection connection, Dialect dialect, String string, boolean bl, String string2, ERModel eRModel2) throws HibernateException, SQLException {
        return this.updateSchema(eRModel, connection, dialect, string, bl, string2, eRModel2, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public DDLStatementCollection updateSchema(ERModel eRModel, Connection connection, Dialect dialect, String string, boolean bl, String string2, ERModel eRModel2, ProgressMonitor progressMonitor) throws HibernateException, SQLException {
        int n;
        Object object;
        Object object2;
        String[] stringArray;
        Object object5;
        int n2 = 0;
        if (bl) {
            n2 += 50;
        }
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            object5 = iterator.next();
            if (!(object5 instanceof EREntity) && !(object5 instanceof ERView) && !(object5 instanceof ERForeignKey)) continue;
            ++n2;
        }
        progressMonitor.maxProgressCalculated(n2);
        int n3 = 0;
        object5 = new DDLStatementCollection();
        DropSchemaContext dropSchemaContext = null;
        if (bl) {
            dropSchemaContext = this.updateDropSchema((DDLStatementCollection)object5, eRModel2, string2, connection, dialect, string);
            progressMonitor.progressUpdate(n3 += 50);
        } else {
            dropSchemaContext = new DropSchemaContext();
        }
        int n4 = eRModel.getQuoteSQLIdentifier();
        int n5 = ((DDLStatementCollection)object5).size();
        boolean bl2 = dialect instanceof PostgreSQLDialect;
        DatabaseMetadata databaseMetadata = new DatabaseMetadata(connection, dialect);
        if (bl2) {
            stringArray = this.generateTablesForIDGenerator(eRModel, dialect, databaseMetadata, n4);
            for (int i = 0; i < stringArray.length; ++i) {
                ((DDLStatementCollection)object5).addUnknownStatement(stringArray[i]);
            }
        }
        stringArray = new ArrayList();
        ArrayList<EREntity> arrayList = new ArrayList<EREntity>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Iterator<ERElement> iterator2 = eRModel.elementIterator();
        while (iterator2.hasNext()) {
            ERElement object42 = iterator2.next();
            if (object42 instanceof EREntity) {
                Object object3;
                Object object4;
                Object object6;
                int n6;
                Object object7;
                Object object8;
                Iterator<ERElement> iterator3;
                Object object9;
                EREntity eREntity = (EREntity)object42;
                object2 = eREntity.getSchema();
                if (object2 == null && (dialect instanceof Oracle9Dialect || dialect instanceof Oracle8iDialect)) {
                    object2 = string;
                }
                if ((object = databaseMetadata.getTableMetadata((String)object2, object42.getName(), eRModel.getQuoteSQLIdentifier() == 2)) == null) {
                    object9 = new ArrayList();
                    if (dialect.createForeignKeyInCreateTable()) {
                        iterator3 = eRModel.elementIterator();
                        while (iterator3.hasNext()) {
                            object8 = iterator3.next();
                            if (!(object8 instanceof ERForeignKey) || !((String)(object7 = ((ERForeignKey)object8).getReferenceTable())).equals(object42.getName())) continue;
                            ((ArrayList)object9).add(object8);
                        }
                    }
                    this._tableDDLGenerator.generateCreateDDL((DDLStatementCollection)object5, eREntity, dialect, ((ArrayList)object9).toArray(new ERForeignKey[((ArrayList)object9).size()]));
                } else {
                    object9 = this._tableDDLGenerator.generateAlterDDL(eREntity, (TableMetadata)object, bl, dialect, dropSchemaContext);
                    for (n6 = 0; n6 < ((String[])object9).length; ++n6) {
                        ((DDLStatementCollection)object5).addTableStatement(object9[n6]);
                    }
                }
                object9 = eREntity.indicesIterator();
                while (object9.hasNext()) {
                    iterator3 = (ERIndex)object9.next();
                    object8 = ((ERIndex)((Object)iterator3)).getName();
                    if (object != null && (!((TableMetadata)object).isCanGetIndex() || ((TableMetadata)object).getIndexMetadata((String)object8) != null)) continue;
                    object7 = new IndexInfo((String)object8, ((ERIndex)((Object)iterator3)).isUnique(), ((ERIndex)((Object)iterator3)).isFullText(), ((ERIndex)((Object)iterator3)).isBitmap(), eREntity.getName(), eREntity.getSchema(), ((ERIndex)((Object)iterator3)).getTablespace(), ((ERIndex)((Object)iterator3)).getFunction(), ((ERIndex)((Object)iterator3)).getClustered(), ((ERIndex)((Object)iterator3)).getCriteria(), ((ERIndex)((Object)iterator3)).getDdlClauses(), ((ERIndex)((Object)iterator3)).getComment());
                    object6 = ((ERIndex)((Object)iterator3)).columnIterator();
                    while (object6.hasNext()) {
                        ((IndexInfo)object7).addColumn((ERIndexColumn)object6.next());
                    }
                    stringArray.add(object7);
                }
                if (!(object != null && ((TableMetadata)object).hasFullTextIndex() || eREntity.getFullTextIndex() == null)) {
                    arrayList.add(eREntity);
                }
                if (object != null || !dialect.supportsIndexConstraintInCreateAlterTable()) {
                    iterator3 = eREntity.elementIterator();
                    while (iterator3.hasNext()) {
                        Object object10;
                        object8 = iterator3.next();
                        if (!(object8 instanceof ERColumn) || !((ERColumn)(object7 = (ERColumn)object8)).isIndex()) continue;
                        object6 = this._ddlOption.getUnnamedIndexName(eREntity.getName(), ((ERElement)object7).getName());
                        if (object != null && (!((TableMetadata)object).isCanGetIndex() || ((TableMetadata)object).getIndexMetadata((String)object6) != null)) continue;
                        boolean bl3 = false;
                        if (object != null && ((TableMetadata)object).isCanGetIndex() && (object10 = ((TableMetadata)object).getIndexNames()) != null) {
                            object4 = object10.iterator();
                            while (object4.hasNext()) {
                                String string3 = object4.next();
                                object3 = ((TableMetadata)object).getIndexMetadata(string3);
                                if (object3 == null || ((IndexMetadata)object3).getColumns() == null || ((IndexMetadata)object3).getColumns().length != 1 || !((IndexMetadata)object3).getColumns()[0].getName().equals(((ERElement)object7).getName())) continue;
                                bl3 = true;
                                break;
                            }
                        }
                        if (bl3) continue;
                        object10 = new IndexInfo((String)object6, ((ERColumn)object7).isUnique(), false, false, eREntity.getName(), eREntity.getSchema(), null, null, 0, null, null, null);
                        ((IndexInfo)object10).addColumn(new ERIndexColumn(((ERElement)object7).getName()));
                        stringArray.add(object10);
                    }
                }
                object9 = eREntity.uniqueKeysIterator();
                while (object9.hasNext()) {
                    Object object11;
                    iterator3 = (String)object9.next();
                    boolean bl4 = false;
                    if (object == null || !((TableMetadata)object).isCanGetIndex()) continue;
                    object7 = ((TableMetadata)object).getIndexMetadata((String)((Object)iterator3));
                    if (object7 != null) {
                        int n7;
                        object6 = ((IndexMetadata)object7).getColumns();
                        object11 = new ArrayList<String>();
                        for (n7 = 0; n7 < ((Object)object6).length; ++n7) {
                            object11.add(((ColumnMetadata)object6[n7]).getName());
                        }
                        n7 = 1;
                        object4 = eREntity.uniqueKeyColumnsIterator((String)((Object)iterator3));
                        while (object4.hasNext()) {
                            void var33_75;
                            String string4 = object4.next();
                            if (eRModel.getQuoteSQLIdentifier() != 2 && !SQLReservedWordChecker.getInstance().isReservedWord(string4)) {
                                if (databaseMetadata.getMeta().storesUpperCaseIdentifiers()) {
                                    String string5 = string4.toUpperCase();
                                } else if (databaseMetadata.getMeta().storesLowerCaseIdentifiers()) {
                                    String string6 = string4.toLowerCase();
                                }
                            }
                            if (object11.remove(var33_75)) continue;
                            n7 = 0;
                            break;
                        }
                        if (n7 != 0) {
                            n7 = object11.isEmpty() ? 1 : 0;
                        }
                        if (n7 != 0) continue;
                        bl4 = true;
                    }
                    object6 = new UniqueKeyInfo((String)((Object)iterator3), eREntity.getName(), eREntity.getSchema());
                    ((UniqueKeyInfo)object6).setRecreate(bl4);
                    object11 = eREntity.uniqueKeyColumnsIterator((String)((Object)iterator3));
                    while (object11.hasNext()) {
                        ((UniqueKeyInfo)object6).addColumn((String)object11.next());
                    }
                    arrayList2.add(object6);
                }
                if (object != null) {
                    iterator3 = eREntity.elementIterator();
                    while (iterator3.hasNext()) {
                        Object object12;
                        ERElement eRElement = iterator3.next();
                        if (!(eRElement instanceof ERColumn) || !((ERColumn)(object7 = (ERColumn)eRElement)).isUnique() || ((ERColumn)object7).isIndex()) continue;
                        object6 = ((ERElement)object7).getName();
                        if (eRModel.getQuoteSQLIdentifier() != 2 && !SQLReservedWordChecker.getInstance().isReservedWord((String)object6)) {
                            if (databaseMetadata.getMeta().storesUpperCaseIdentifiers()) {
                                object6 = ((String)object6).toUpperCase();
                            } else if (databaseMetadata.getMeta().storesLowerCaseIdentifiers()) {
                                object6 = ((String)object6).toLowerCase();
                            }
                        }
                        boolean bl5 = true;
                        List<String> list = ((TableMetadata)object).getIndexNames();
                        for (String string7 : list) {
                            object3 = ((TableMetadata)object).getIndexMetadata(string7);
                            object12 = ((IndexMetadata)object3).getColumns();
                            if (object12 == null || ((ColumnMetadata[])object12).length != 1 || !object12[0].getName().equals(object6)) continue;
                            bl5 = false;
                            break;
                        }
                        object4 = ((TableMetadata)object).getUniqueConstraintNames();
                        Iterator iterator4 = object4.iterator();
                        while (iterator4.hasNext()) {
                            ColumnMetadata[] columnMetadataArray;
                            object3 = (String)iterator4.next();
                            object12 = ((TableMetadata)object).getUniqueConstraintMetadata((String)object3);
                            if (object12 == null || (columnMetadataArray = ((UniqueConstraintMetadata)object12).getColumns()) == null || columnMetadataArray.length != 1 || !columnMetadataArray[0].getName().equals(object6)) continue;
                            bl5 = false;
                            break;
                        }
                        if (!bl5) continue;
                        UniqueKeyInfo uniqueKeyInfo = new UniqueKeyInfo(null, eREntity.getName(), eREntity.getSchema());
                        uniqueKeyInfo.addColumn(((ERElement)object7).getName());
                        arrayList2.add(uniqueKeyInfo);
                    }
                }
                object9 = this._tableDDLGenerator.generateComment(eREntity, dialect, connection, true, (TableMetadata)object);
                for (n6 = 0; n6 < ((Object)object9).length; ++n6) {
                    ((DDLStatementCollection)object5).addTableStatement((String)object9[n6]);
                }
                progressMonitor.progressUpdate(++n3);
                continue;
            }
            if (!(object42 instanceof ERView)) continue;
            TableMetadata tableMetadata = databaseMetadata.getViewMetadata(object42.getName());
            object2 = ((ERView)object42).getCreateStmt();
            if (tableMetadata == null && object2 != null) {
                ((DDLStatementCollection)object5).addTableStatement((String)object2);
            }
            progressMonitor.progressUpdate(++n3);
        }
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            for (UniqueKeyInfo uniqueKeyInfo : arrayList2) {
                if (uniqueKeyInfo.isRecreate()) {
                    int n8 = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
                    if (n8 == 2 || n8 == 0x100000 || n8 == 0x1000000) {
                        object2 = new StringBuffer(this.convertKeywordCase("drop index ")).append(DDLGeneratorUtil.quoteName(uniqueKeyInfo.getName(), dialect, n4));
                        ((StringBuffer)object2).append(this.convertKeywordCase(" on ")).append(DDLGeneratorUtil.getQualifiedName(uniqueKeyInfo.getSchema(), uniqueKeyInfo.getEntity(), dialect, n4));
                        ((DDLStatementCollection)object5).addIndexStatement(n5, ((StringBuffer)object2).toString());
                    } else {
                        object2 = new StringBuffer(this.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(uniqueKeyInfo.getSchema(), uniqueKeyInfo.getEntity(), dialect, n4)).append(' ');
                        if (this.isFormattedSQL()) {
                            ((StringBuffer)object2).append("\n  ");
                        }
                        ((StringBuffer)object2).append(this.convertKeywordCase("drop constraint "));
                        ((StringBuffer)object2).append(DDLGeneratorUtil.quoteName(uniqueKeyInfo.getName(), dialect, n4));
                        ((DDLStatementCollection)object5).addIndexStatement(n5, ((StringBuffer)object2).toString());
                    }
                }
                StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(uniqueKeyInfo.getSchema(), uniqueKeyInfo.getEntity(), dialect, n4)).append(' ');
                if (this.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                stringBuffer.append(this.convertKeywordCase("add "));
                if (dialect.supportConstraintName() && uniqueKeyInfo.getName() != null) {
                    stringBuffer.append(this.convertKeywordCase("constraint "));
                    stringBuffer.append(DDLGeneratorUtil.quoteName(uniqueKeyInfo.getName(), dialect, n4));
                    stringBuffer.append(" ");
                    if (this.isFormattedSQL()) {
                        stringBuffer.append("\n    ");
                    }
                }
                stringBuffer.append(this.convertKeywordCase("unique ("));
                object2 = uniqueKeyInfo.columnIterator();
                while (object2.hasNext()) {
                    stringBuffer.append(DDLGeneratorUtil.quoteName((String)object2.next(), dialect, n4));
                    if (!object2.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                ((DDLStatementCollection)object5).addIndexStatement(stringBuffer.toString());
            }
        }
        if ((n = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName())) != 0x2000000) {
            for (IndexInfo indexInfo : stringArray) {
                for (String string8 : object2 = this.generateCreateIndex(dialect, n4, indexInfo)) {
                    ((DDLStatementCollection)object5).addIndexStatement(string8);
                }
            }
        }
        if (n == 8 || n == 0x200000) {
            for (EREntity eREntity : arrayList) {
                object2 = eREntity.getFullTextIndex();
                if (object2 == null) continue;
                ((DDLStatementCollection)object5).addIndexStatement(this.generateCreateFullTextIndex(dialect, n4, eREntity, (ERFullTextIndex)object2));
            }
        }
        Iterator<ERElement> iterator5 = eRModel.elementIterator();
        while (iterator5.hasNext()) {
            String string9;
            ERElement eRElement = iterator5.next();
            if (!(eRElement instanceof ERForeignKey)) continue;
            object2 = (ERForeignKey)eRElement;
            object = databaseMetadata.getTableMetadata(((ERForeignKey)object2).getReferenceSchema(), ((ERForeignKey)object2).getReferenceTable(), eRModel.getQuoteSQLIdentifier() == 2);
            if (dialect.hasAlterTable() && (object == null || ((TableMetadata)object).getForeignKeyMetadata(((ERElement)object2).getName()) == null || ((ERElement)object2).getName() != null && dropSchemaContext.shouldRecreateFK(((ERElement)object2).getName())) && (string9 = this._foreignKeyDDLGenerator.generateDDL((ERForeignKey)object2, dialect)) != null) {
                ((DDLStatementCollection)object5).addFKStatement(string9);
            }
            progressMonitor.progressUpdate(++n3);
        }
        if (!bl2) {
            void var22_48;
            String[] stringArray2 = this.generateTablesForIDGenerator(eRModel, dialect, databaseMetadata, n4);
            boolean bl6 = false;
            while (var22_48 < stringArray2.length) {
                ((DDLStatementCollection)object5).addUnknownStatement(stringArray2[var22_48]);
                ++var22_48;
            }
        }
        Object object13 = object5;
        return object13;
    }

    public DDLStatementCollection updateDropSchema(ERModel eRModel, Connection connection, Dialect dialect, String string) throws HibernateException, SQLException {
        DDLStatementCollection dDLStatementCollection = new DDLStatementCollection();
        this.updateDropSchema(dDLStatementCollection, eRModel, null, connection, dialect, string);
        return dDLStatementCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DropSchemaContext updateDropSchema(DDLStatementCollection dDLStatementCollection, ERModel eRModel, String string, Connection connection, Dialect dialect, String string2) throws HibernateException, SQLException {
        Object object;
        Object object2;
        Object object3;
        List<String> list;
        Object object4;
        String string3;
        EREntity eREntity;
        Object object5;
        DropSchemaContext dropSchemaContext = new DropSchemaContext();
        DatabaseMetadata databaseMetadata = new DatabaseMetadata(connection, dialect);
        Object object6 = eRModel.elementIterator();
        while (object6.hasNext()) {
            object5 = object6.next();
            if (!(object5 instanceof EREntity)) continue;
            eREntity = (EREntity)object5;
            string3 = eREntity.getSchema();
            if (string3 == null && DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName()) == 16) {
                string3 = string2;
            }
            if ((object4 = databaseMetadata.getTableMetadata(string3, object5.getName(), eRModel.getQuoteSQLIdentifier() == 2)) == null) continue;
            list = new StringBuffer(this.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, eRModel.getQuoteSQLIdentifier())).append(' ');
            if (this.isFormattedSQL()) {
                ((StringBuffer)((Object)list)).append("\n  ");
            }
            String[] stringArray = ((TableMetadata)object4).getAllColumnsName();
            object3 = new HashSet<String>(Arrays.asList(((TableMetadata)object4).getPrimaryKeyColumns()));
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                boolean bl = false;
                object2 = eREntity.elementIterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (!(object instanceof ERColumn) || !stringArray[i].equals(((ERColumn)object).getName().toLowerCase())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                object = ((TableMetadata)object4).getForeignKeys();
                block5: for (int j = 0; j < ((String[])object).length; ++j) {
                    String[] stringArray3 = ((TableMetadata)object4).getForeignKeyMetadata(object[j]);
                    ColumnMetadata[] columnMetadataArray = stringArray3.getColumns();
                    for (int k = 0; k < columnMetadataArray.length; ++k) {
                        if (!stringArray[i].equals(columnMetadataArray[k].getName().toLowerCase())) continue;
                        String string4 = DropSchemaContext.getFKKey((ForeignKeyMetadata)stringArray3);
                        if (!dropSchemaContext.isFKDropped(string4)) {
                            if (dialect.getDropForeignKeyString() != null) {
                                StringBuffer stringBuffer = new StringBuffer(((StringBuffer)((Object)list)).toString().trim());
                                stringBuffer.append(this.convertKeywordCase(dialect.getDropForeignKeyString())).append(DDLGeneratorUtil.quoteName(stringArray3.getName(), dialect, eRModel.getQuoteSQLIdentifier()));
                                dDLStatementCollection.addFKStatement(stringBuffer.toString());
                            }
                            dropSchemaContext.droppedFK(string4);
                        }
                        dropSchemaContext.unmarkRecreateFK(string4);
                        continue block5;
                    }
                }
                if (object3.contains(stringArray[i]) && (stringArray2 = this._tableDDLGenerator.generateDropPrimaryKey((TableMetadata)object4, eREntity, dialect, eRModel.getQuoteSQLIdentifier(), dropSchemaContext)) != null) {
                    for (String string4 : stringArray2) {
                        dDLStatementCollection.addTableStatement(string4);
                    }
                }
                StringBuffer stringBuffer = new StringBuffer(((StringBuffer)((Object)list)).toString());
                stringBuffer.append(this.convertKeywordCase(dialect.getDropColumnString())).append(' ').append(DDLGeneratorUtil.quoteName(stringArray[i], dialect, eRModel.getQuoteSQLIdentifier()));
                dDLStatementCollection.addTableStatement(stringBuffer.toString());
            }
        }
        object6 = eRModel.elementIterator();
        while (object6.hasNext()) {
            int n;
            CharSequence charSequence;
            object5 = object6.next();
            if (!(object5 instanceof EREntity)) continue;
            eREntity = (EREntity)object5;
            string3 = eREntity.getSchema();
            if (string3 == null && (dialect instanceof Oracle9Dialect || dialect instanceof Oracle8iDialect)) {
                string3 = string2;
            }
            if ((object4 = databaseMetadata.getTableMetadata(string3, object5.getName(), eRModel.getQuoteSQLIdentifier() == 2)) == null || !((TableMetadata)object4).isCanGetIndex()) continue;
            list = ((TableMetadata)object4).getUniqueConstraintNames();
            if (!list.isEmpty()) {
                Iterator<String> iterator = eREntity.uniqueKeysIterator();
                block9: while (iterator.hasNext()) {
                    object3 = iterator.next();
                    if (list.remove(object3)) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String string5 = (String)list.get(i);
                        if (!string5.equalsIgnoreCase((String)object3)) continue;
                        list.remove(i);
                        continue block9;
                    }
                }
            }
            if (!list.isEmpty()) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    ERColumn eRColumn;
                    object3 = (String)list.get(i);
                    UniqueConstraintMetadata uniqueConstraintMetadata = ((TableMetadata)object4).getUniqueConstraintMetadata((String)object3);
                    if (uniqueConstraintMetadata == null || uniqueConstraintMetadata.getColumns().length != 1 || (eRColumn = eREntity.getColumnByName(uniqueConstraintMetadata.getColumns()[0].getName())) == null || !eRColumn.isUnique()) continue;
                    list.remove(object3);
                }
            }
            if (!list.isEmpty()) {
                Iterator<ERIndex> iterator = eREntity.indicesIterator();
                block12: while (iterator.hasNext()) {
                    object3 = iterator.next();
                    if (list.remove(((ERIndex)object3).getName())) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        charSequence = (String)list.get(i);
                        if (!((String)charSequence).equalsIgnoreCase(((ERIndex)object3).getName())) continue;
                        list.remove(i);
                        continue block12;
                    }
                }
            }
            if ((n = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName())) == 2 || n == 0x100000 || n == 0x1000000) {
                for (String string6 : list) {
                    charSequence = new StringBuffer(this.convertKeywordCase("drop index ")).append(DDLGeneratorUtil.quoteName(string6, dialect, eRModel.getQuoteSQLIdentifier()));
                    ((StringBuffer)charSequence).append(this.convertKeywordCase(" on ")).append(DDLGeneratorUtil.getQualifiedName(string3, eREntity.getName(), dialect, eRModel.getQuoteSQLIdentifier()));
                    dDLStatementCollection.addIndexStatement(((StringBuffer)charSequence).toString());
                }
                continue;
            }
            for (String string7 : list) {
                charSequence = new StringBuffer(this.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(string3, eREntity.getName(), dialect, eRModel.getQuoteSQLIdentifier())).append(' ');
                if (this.isFormattedSQL()) {
                    ((StringBuffer)charSequence).append("\n  ");
                }
                ((StringBuffer)charSequence).append(this.convertKeywordCase("drop constraint "));
                ((StringBuffer)charSequence).append(DDLGeneratorUtil.quoteName(string7, dialect, eRModel.getQuoteSQLIdentifier()));
                dDLStatementCollection.addIndexStatement(((StringBuffer)charSequence).toString());
            }
        }
        object6 = new ArrayList();
        if (string == null && DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName()) == 16) {
            string = string2;
        }
        object5 = databaseMetadata.getAllTables(string);
        for (int i = 0; i < ((TableMetadata[])object5).length; ++i) {
            String[] stringArray;
            boolean bl = false;
            object4 = object5[i].getName().toLowerCase();
            Iterator<ERElement> iterator = eRModel.elementIterator();
            while (iterator.hasNext()) {
                stringArray = iterator.next();
                if (!(stringArray instanceof EREntity) || !((String)object4).equals(stringArray.getName().toLowerCase())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            for (int j = 0; j < ((TableMetadata[])object5).length; ++j) {
                if (i == j) continue;
                stringArray = object5[j].getForeignKeys();
                for (int k = 0; k < stringArray.length; ++k) {
                    String string8;
                    ForeignKeyMetadata foreignKeyMetadata = object5[j].getForeignKeyMetadata(stringArray[k]);
                    if (!foreignKeyMetadata.getPkTable().toLowerCase().equals(object5[i].getName().toLowerCase()) || dropSchemaContext.isFKDropped(string8 = DropSchemaContext.getFKKey(foreignKeyMetadata))) continue;
                    object2 = dialect.getDropForeignKeyString();
                    if (object2 != null && !dDLStatementCollection.contains((String)(object = this.convertKeywordCase("alter table ") + DDLGeneratorUtil.getQualifiedName(object5[j].getSchema(), object5[j].getName(), dialect, eRModel.getQuoteSQLIdentifier()) + this.convertKeywordCase((String)object2) + DDLGeneratorUtil.quoteName(foreignKeyMetadata.getName(), dialect, eRModel.getQuoteSQLIdentifier())))) {
                        dDLStatementCollection.addFKStatement((String)object);
                    }
                    dropSchemaContext.droppedFK(string8);
                    dropSchemaContext.unmarkRecreateFK(string8);
                }
            }
            object6.add(object5[i]);
        }
        Iterator iterator = object6.iterator();
        while (iterator.hasNext()) {
            TableMetadata tableMetadata = (TableMetadata)iterator.next();
            object4 = new StringBuffer(this.convertKeywordCase("drop table ")).append(DDLGeneratorUtil.getQualifiedName(tableMetadata.getSchema(), tableMetadata.getName(), dialect, eRModel.getQuoteSQLIdentifier()));
            dDLStatementCollection.addTableStatement(((StringBuffer)object4).toString());
        }
        return dropSchemaContext;
    }

    private String[] generateTablesForIDGenerator(ERModel eRModel, Dialect dialect, DatabaseMetadata databaseMetadata, int n) throws HibernateException, SQLException {
        Object object;
        ERElement eRElement;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            eRElement = iterator.next();
            if (!(eRElement instanceof ERSequence)) continue;
            object = (ERSequence)eRElement;
            if (((ERSequence)object).getSchema() != null && ((ERSequence)object).getSchema().length() > 0) {
                hashSet.add(((ERSequence)object).getSchema() + "." + ((ERElement)object).getName());
                continue;
            }
            hashSet.add(eRElement.getName());
        }
        iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            int n2;
            Object object2;
            eRElement = iterator.next();
            if (!(eRElement instanceof EREntity)) continue;
            object = new ArrayList();
            Object object3 = ((EREntity)eRElement).elementIterator();
            while (object3.hasNext()) {
                ERColumn eRColumn;
                object2 = object3.next();
                if (!(object2 instanceof ERColumn) || !(eRColumn = (ERColumn)object2).isPrimaryKey() || eRColumn.isForeignKey()) continue;
                ((ArrayList)object).add(eRColumn);
            }
            if (((ArrayList)object).size() != 1 || !this.needTableForGenerator((String)(object2 = DDLGeneratorUtil.getIDGenerator(((ERColumn)(object3 = (ERColumn)((ArrayList)object).get(0))).getIdGenerator(), dialect, DBTypeUtil.isIntType(((ERColumn)object3).getType()))), dialect) || (n2 = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName())) == 256 && (string2 = ((ERColumn)object3).getUserType(256)) != null && ("smallserial".equalsIgnoreCase(string2) || "serial".equalsIgnoreCase(string2) || "bigserial".equalsIgnoreCase(string2)) || hashSet.contains(string = DDLGeneratorUtil.getIDGeneratorKey(string2 = ((ERColumn)object3).getEntity().getSchema(), ((ERColumn)object3).getEntity().getName(), (String)object2, ((ERColumn)object3).getIdGeneratorKey()))) continue;
            String string3 = string;
            if (string2 != null && string2.length() > 0 && (((ERColumn)object3).getIdGeneratorKey() == null || ((ERColumn)object3).getIdGeneratorKey().length() == 0)) {
                string3 = string3.substring(string2.length() + 1);
            } else {
                int n3 = string.indexOf(46);
                if (n3 > 0) {
                    string2 = string.substring(0, n3);
                    string3 = string.substring(n3 + 1);
                }
            }
            if (databaseMetadata != null && (databaseMetadata.isSequence(string3) || databaseMetadata.isTable(string))) continue;
            try {
                String[] stringArray;
                String string4 = DDLGeneratorUtil.quoteName(string3, dialect, n);
                if (string2 != null && string2.length() > 0) {
                    string4 = DDLGeneratorUtil.quoteName(string2, dialect, n) + "." + string4;
                }
                if ((stringArray = this.generateTableForIDGenerator((String)object2, string4, DDLGeneratorUtil.getDefaultIDTableColumnName(), dialect)) != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        arrayList.add(stringArray[i]);
                    }
                }
                hashSet.add(string);
            }
            catch (HibernateException hibernateException) {
                throw new HibernateException("Error generating table/sequence for ID generator of table " + eRElement.getName(), hibernateException);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean needTableForGenerator(String string, Dialect dialect) {
        return string.equals("hilo") || string.equals("sequence") || string.equals("seqhilo");
    }

    private String[] generateTableForIDGenerator(String string, String string2, String string3, Dialect dialect) throws HibernateException {
        if (string.equals("sequence")) {
            if (dialect.supportsSequences() || dialect instanceof DerbyDialect) {
                String[] stringArray = dialect.getCreateSequenceStrings(string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.convertKeywordCase(stringArray[i]);
                    stringArray[i] = stringArray[i].replaceAll(this.convertKeywordCase(string2), string2);
                }
                return stringArray;
            }
            throw new MappingException("Database does not support sequence");
        }
        if (string.equals("hilo") || string.equals("seqhilo")) {
            return new String[]{this.convertKeywordCase("create table ") + string2 + " (" + string3 + " " + dialect.getTypeName(4) + ")", this.convertKeywordCase("insert into ") + string2 + this.convertKeywordCase(" values (0)")};
        }
        return null;
    }

    private String[] dropTableForIDGenerator(String string, String string2, String string3, Dialect dialect) {
        if (string.equals("sequence")) {
            String[] stringArray = dialect.getDropSequenceStrings(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.convertKeywordCase(stringArray[i]);
                stringArray[i] = stringArray[i].replaceAll(this.convertKeywordCase(string2), string2);
            }
            return stringArray;
        }
        if (string.equals("hilo") || string.equals("seqhilo")) {
            StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("drop table "));
            if (dialect.supportsIfExistsBeforeTableName()) {
                stringBuffer.append(this.convertKeywordCase("if exists "));
            }
            stringBuffer.append(string2).append(dialect.getCascadeConstraintsString());
            if (dialect.supportsIfExistsAfterTableName()) {
                stringBuffer.append(this.convertKeywordCase(" if exists"));
            }
            return new String[]{stringBuffer.toString()};
        }
        return null;
    }

    public String convertKeywordCase(String string) {
        if (this._upperCaseSQL) {
            return string.toUpperCase();
        }
        return string.toLowerCase();
    }

    public void setUpperCaseSQL(boolean bl) {
        this._upperCaseSQL = bl;
    }

    public boolean isUpperCaseSQL() {
        return this._upperCaseSQL;
    }

    public boolean isFormattedSQL() {
        return this._formattedSQL;
    }

    public void setFormattedSQL(boolean bl) {
        this._formattedSQL = bl;
    }
}

