/*
 * Decompiled with CFR 0.152.
 */
package org.orm.criteria;

import java.util.Iterator;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Order;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.List;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.orm.PersistentManager;

public class OrderByListIndex
extends Order {
    private final String _entityName;
    private final String _propertyName;
    private boolean _ignoreCase;
    private final boolean _ascending;
    private final PersistentManager _manager;

    public OrderByListIndex(PersistentManager persistentManager, Class clazz, String string, boolean bl) {
        this(persistentManager, clazz.getName(), string, bl);
    }

    public OrderByListIndex(PersistentManager persistentManager, String string, String string2, boolean bl) {
        super(string2, bl);
        this._manager = persistentManager;
        this._entityName = string;
        this._propertyName = string2;
        this._ascending = bl;
    }

    public Order ignoreCase() {
        this._ignoreCase = true;
        return this;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        PersistentClass persistentClass = this._manager.getConfiguration().getClassMapping(this._entityName);
        if (persistentClass == null) {
            throw new HibernateException("Invalid entity name :" + this._entityName);
        }
        Property property = persistentClass.getProperty(this._propertyName);
        if (property == null) {
            throw new HibernateException("Invalid property :" + this._propertyName);
        }
        Value value = property.getValue();
        if (!(value instanceof List)) {
            throw new HibernateException("Property not a list");
        }
        List list = (List)value;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = list.getIndex().getColumnIterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            Column column = (Column)iterator.next();
            String string = column.getName();
            if (column.isQuoted()) {
                string = "`" + string + "`";
            }
            SessionFactoryImplementor sessionFactoryImplementor = criteriaQuery.getFactory();
            boolean bl2 = this._ignoreCase;
            if (bl2) {
                stringBuffer.append(sessionFactoryImplementor.getDialect().getLowercaseFunction()).append('(');
            }
            stringBuffer.append(sessionFactoryImplementor.getDialect().quote(string));
            if (bl2) {
                stringBuffer.append(')');
            }
            stringBuffer.append(this._ascending ? " asc" : " desc");
        }
        return stringBuffer.toString();
    }
}

