/*
 * Decompiled with CFR 0.152.
 */
package org.orm.cfg;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.orm.cfg.JDBCConnectionSetting;
import org.orm.util.EncryptionUtil;

public class JDBCSettings {
    public static final String DEFAULT_FILENAME = "database.cfg.xml";
    private static final String ELEM_DATABASE = "Database";
    private static final String ELEM_SETTING = "Setting";
    private static final String ELEM_ATTR_TYPE = "type";
    private static final String ELEM_DIALECT = "Dialect";
    private static final String ELEM_DRIVER = "Driver";
    private static final String ELEM_DRIVER_FILES = "DriverFiles";
    private static final String ELEM_DRIVER_CLASS = "DriverClass";
    private static final String ELEM_URL = "URL";
    private static final String ELEM_USERNAME = "UserName";
    private static final String ELEM_PASSWORD = "Password";
    private static final String ELEM_ENCRYPTED_PASSWORD = "EncryptedPassword";
    private static final String ELEM_HOSTNAME = "HostName";
    private static final String ELEM_PORTNO = "PortNO";
    private static final String ELEM_DATABASENAME = "DBName";
    private static final String ELEM_SERVICENAME = "ServiceName";
    private static final String ELEM_SERVERNAME = "ServerName";
    private static final String ELEM_SELECT_FORM = "SelectedForm";
    private static final String SELECTED_FORM = "true";
    private static final String SELECTED_URL = "false";
    public static final int DBTYPE_MY_SQL = 2;
    public static final int DBTYPE_MS_SQL = 8;
    public static final int DBTYPE_ORACLE = 16;
    public static final int DBTYPE_HSQL = 32;
    public static final int DBTYPE_SYBASE = 64;
    public static final int DBTYPE_SYBASE_ANYWHERE = 128;
    public static final int DBTYPE_POSTGRESQL = 256;
    public static final int DBTYPE_DERBY = 512;
    public static final int DBTYPE_DB2 = 1024;
    public static final int DBTYPE_INFORMIX = 2048;
    public static final int DBTYPE_INGRES = 4096;
    public static final int DBTYPE_INGRES_10 = 0x800000;
    public static final int DBTYPE_OPENEDGE = 8192;
    public static final int DBTYPE_FIREBIRD = 16384;
    public static final int DBTYPE_FRONTBASE = 65536;
    public static final int DBTYPE_H2 = 524288;
    public static final int DBTYPE_MY_SQL_505 = 0x100000;
    public static final int DBTYPE_MS_SQL_2008 = 0x200000;
    public static final int DBTYPE_MARIA_DB = 0x1000000;
    private static byte[] ENCRYPTION_KEY = new byte[]{85, 89, -92, 47, -106, 87, -112, 30, -59, 57, -29, -43, -113, -35, 14, -51};
    private Map<Integer, JDBCConnectionSetting> _jdbcConnectionSettings = new Hashtable<Integer, JDBCConnectionSetting>();

    public JDBCSettings() {
        this.load();
    }

    public JDBCSettings(String string) {
        this.load(string);
    }

    public void load() {
        this.load("/ormmapping/database.cfg.xml");
    }

    public void load(String string) {
        InputStream inputStream = JDBCSettings.class.getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        this.load(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        SAXReader sAXReader = new SAXReader();
        sAXReader.setMergeAdjacentText(true);
        try {
            Document document = sAXReader.read(inputStream);
            Element element = document.getRootElement();
            Iterator iterator = element.elementIterator(ELEM_SETTING);
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                int n = Integer.parseInt(element2.attribute(ELEM_ATTR_TYPE).getValue());
                JDBCConnectionSetting jDBCConnectionSetting = this.getDefaultJDBCConnectionSetting(n);
                Iterator iterator2 = element2.elementIterator();
                while (iterator2.hasNext()) {
                    Element element3 = (Element)iterator2.next();
                    if (element3.getName().equals(ELEM_DIALECT)) {
                        if (element3.nodeCount() <= 0) continue;
                        jDBCConnectionSetting.setDialect(JDBCSettings.getText(element3));
                        continue;
                    }
                    if (element3.getName().equals(ELEM_DRIVER)) {
                        if (element3.nodeCount() <= 0) continue;
                        jDBCConnectionSetting.setDriver(JDBCSettings.getText(element3));
                        continue;
                    }
                    if (element3.getName().equals(ELEM_DRIVER_FILES)) {
                        if (element3.nodeCount() <= 0) continue;
                        jDBCConnectionSetting.setDriverFiles(JDBCSettings.getText(element3));
                        continue;
                    }
                    if (element3.getName().equals(ELEM_DRIVER_CLASS)) {
                        if (element3.nodeCount() <= 0) continue;
                        jDBCConnectionSetting.setDriverClass(JDBCSettings.getText(element3));
                        continue;
                    }
                    if (element3.getName().equals(ELEM_URL)) {
                        if (element3.nodeCount() <= 0) continue;
                        jDBCConnectionSetting.setConnectionURL(JDBCSettings.getText(element3));
                        continue;
                    }
                    if (element3.getName().equals(ELEM_USERNAME)) {
                        if (element3.nodeCount() <= 0) continue;
                        jDBCConnectionSetting.setUserName(JDBCSettings.getText(element3));
                        continue;
                    }
                    if (element3.getName().equals(ELEM_PASSWORD)) {
                        jDBCConnectionSetting.setPassword(element3.nodeCount() > 0 ? JDBCSettings.getText(element3) : "");
                        continue;
                    }
                    if (element3.getName().equals(ELEM_ENCRYPTED_PASSWORD)) {
                        jDBCConnectionSetting.setPassword(element3.nodeCount() > 0 ? EncryptionUtil.decryptText(ENCRYPTION_KEY, JDBCSettings.getText(element3)) : "");
                        continue;
                    }
                    if (element3.getName().equals(ELEM_HOSTNAME)) {
                        jDBCConnectionSetting.setHostName(element3.nodeCount() > 0 ? JDBCSettings.getText(element3) : "");
                        continue;
                    }
                    if (element3.getName().equals(ELEM_PORTNO)) {
                        jDBCConnectionSetting.setPortNo(element3.nodeCount() > 0 ? JDBCSettings.getText(element3) : "");
                        continue;
                    }
                    if (element3.getName().equals(ELEM_DATABASENAME)) {
                        jDBCConnectionSetting.setDatabaseName(element3.nodeCount() > 0 ? JDBCSettings.getText(element3) : "");
                        continue;
                    }
                    if (element3.getName().equals(ELEM_SERVICENAME)) {
                        jDBCConnectionSetting.setServiceName(element3.nodeCount() > 0 ? JDBCSettings.getText(element3) : "");
                        continue;
                    }
                    if (element3.getName().equals(ELEM_SERVERNAME)) {
                        jDBCConnectionSetting.setServerName(element3.nodeCount() > 0 ? JDBCSettings.getText(element3) : "");
                        continue;
                    }
                    if (!element3.getName().equals(ELEM_SELECT_FORM)) continue;
                    String string = JDBCSettings.getText(element3);
                    if (string.equals(SELECTED_FORM)) {
                        jDBCConnectionSetting.setSelectForm(true);
                        continue;
                    }
                    jDBCConnectionSetting.setSelectForm(false);
                }
            }
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            this.save(fileOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream outputStream) {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement(ELEM_DATABASE);
        for (Map.Entry<Integer, JDBCConnectionSetting> entry : this._jdbcConnectionSettings.entrySet()) {
            int n = entry.getKey();
            JDBCConnectionSetting jDBCConnectionSetting = entry.getValue();
            Element element2 = element.addElement(ELEM_SETTING).addAttribute(ELEM_ATTR_TYPE, String.valueOf(n));
            element2.addElement(ELEM_DRIVER).addText(jDBCConnectionSetting.getDriver());
            element2.addElement(ELEM_DRIVER_FILES).addText(jDBCConnectionSetting.getDriverFiles());
            element2.addElement(ELEM_DIALECT).addText(jDBCConnectionSetting.getDialect());
            element2.addElement(ELEM_DRIVER_CLASS).addText(jDBCConnectionSetting.getDriverClass());
            element2.addElement(ELEM_URL).addText(jDBCConnectionSetting.getConnectionURL());
            element2.addElement(ELEM_USERNAME).addText(jDBCConnectionSetting.getUserName());
            element2.addElement(ELEM_ENCRYPTED_PASSWORD).addText(EncryptionUtil.encryptText(ENCRYPTION_KEY, jDBCConnectionSetting.getPassword()));
            element2.addElement(ELEM_HOSTNAME).addText(jDBCConnectionSetting.getHostName());
            element2.addElement(ELEM_PORTNO).addText(jDBCConnectionSetting.getPortNo());
            element2.addElement(ELEM_DATABASENAME).addText(jDBCConnectionSetting.getDatabaseName());
            element2.addElement(ELEM_SERVICENAME).addText(jDBCConnectionSetting.getServiceName());
            element2.addElement(ELEM_SERVERNAME).addText(jDBCConnectionSetting.getServerName());
            if (jDBCConnectionSetting.isSelectForm()) {
                element2.addElement(ELEM_SELECT_FORM).addText(SELECTED_FORM);
                continue;
            }
            element2.addElement(ELEM_SELECT_FORM).addText(SELECTED_URL);
        }
        Object object = null;
        try {
            object = new XMLWriter(outputStream, OutputFormat.createPrettyPrint());
            ((XMLWriter)object).write(document);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                ((XMLWriter)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean hasDefaultJDBCConnectionSetting(int n) {
        return this._jdbcConnectionSettings.containsKey(new Integer(n));
    }

    public JDBCConnectionSetting getDefaultJDBCConnectionSetting(int n) {
        JDBCConnectionSetting jDBCConnectionSetting = this._jdbcConnectionSettings.get(new Integer(n));
        if (jDBCConnectionSetting == null) {
            jDBCConnectionSetting = new JDBCConnectionSetting();
            this._jdbcConnectionSettings.put(new Integer(n), jDBCConnectionSetting);
        }
        return jDBCConnectionSetting;
    }

    public void remapDatabase(int n, int n2) {
        JDBCConnectionSetting jDBCConnectionSetting = this._jdbcConnectionSettings.remove(n);
        if (jDBCConnectionSetting != null) {
            this._jdbcConnectionSettings.put(n2, jDBCConnectionSetting);
        }
    }

    private static String getText(Element element) {
        if (element.nodeCount() == 1) {
            return element.node(0).getText();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = element.nodeIterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Node)iterator.next()).getText());
        }
        return stringBuffer.toString();
    }
}

