/*
 * Decompiled with CFR 0.152.
 */
package org.orm;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Transaction;
import org.hibernate.TypeHelper;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.stat.SessionStatistics;
import org.orm.PersistentException;
import org.orm.PersistentTransaction;
import org.orm.util.ORMCollection;
import org.orm.util.ORMList;
import org.orm.util.ORMMap;
import org.orm.util.ORMSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSession {
    private final Session _session;
    private boolean _transaction = false;

    public PersistentSession(Session session, Configuration configuration) {
        this._session = session;
        this.Initialize(configuration);
    }

    protected void Initialize(Configuration configuration) {
        String string;
        String string2 = configuration.getProperty("dialect");
        if (string2 != null && "org.hibernate.dialect.SQLServerDialect".equals(string2) && "false".equals(string = configuration.getProperty("mssql.nocount"))) {
            this._session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    connection.createStatement().execute("set nocount off");
                }
            });
        }
    }

    public PersistentTransaction beginTransaction() throws PersistentException {
        try {
            PersistentTransaction persistentTransaction = new PersistentTransaction(this._session.beginTransaction(), this);
            this.setTransaction(true);
            return persistentTransaction;
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void cancelQuery() throws PersistentException {
        try {
            this._session.cancelQuery();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void clear() {
        this._session.clear();
    }

    public Connection close() throws PersistentException {
        try {
            return this._session.close();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public boolean contains(Object object) {
        return this._session.contains(object);
    }

    public Criteria createCriteria(Class clazz) {
        return this._session.createCriteria(clazz);
    }

    public Criteria createCriteria(String string) {
        return this._session.createCriteria(string);
    }

    public Criteria createCriteria(Class clazz, String string) {
        return this._session.createCriteria(clazz, string);
    }

    public Criteria createCriteria(String string, String string2) {
        return this._session.createCriteria(string, string2);
    }

    public Criteria createCriteria(DetachedCriteria detachedCriteria) {
        return detachedCriteria.getExecutableCriteria(this._session);
    }

    public Query createFilter(Object object, String string) throws PersistentException {
        try {
            return this._session.createFilter(object, string);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Query createFilter(ORMSet oRMSet, String string) throws PersistentException {
        return this.createFilter(oRMSet.getCollection(), string);
    }

    public Query createFilter(ORMCollection oRMCollection, String string) throws PersistentException {
        return this.createFilter(oRMCollection.getCollection(), string);
    }

    public Query createFilter(ORMList oRMList, String string) throws PersistentException {
        return this.createFilter(oRMList.getCollection(), string);
    }

    public Query createFilter(ORMMap oRMMap, String string) throws PersistentException {
        return this.createFilter(oRMMap.getCollection(), string);
    }

    public Query createQuery(String string) throws PersistentException {
        try {
            return this._session.createQuery(string);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public SQLQuery createSQLQuery(String string) throws PersistentException {
        try {
            return this._session.createSQLQuery(string);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void delete(Object object) throws PersistentException {
        try {
            this._session.delete(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void disableFilter(String string) {
        this._session.disableFilter(string);
    }

    public Connection disconnect() throws PersistentException {
        try {
            return this._session.disconnect();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Filter enableFilter(String string) {
        return this._session.enableFilter(string);
    }

    public boolean equals(Object object) {
        return this._session.equals(object);
    }

    public void evict(Object object) throws PersistentException {
        try {
            this._session.evict(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void flush() throws PersistentException {
        try {
            this._session.flush();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Object get(Class clazz, Serializable serializable) throws PersistentException {
        try {
            return this._session.get(clazz, serializable);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Object get(Class clazz, Serializable serializable, LockMode lockMode) throws PersistentException {
        try {
            return this._session.get(clazz, serializable, lockMode);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Object get(String string, Serializable serializable) throws PersistentException {
        try {
            return this._session.get(string, serializable);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Object get(String string, Serializable serializable, LockMode lockMode) throws PersistentException {
        try {
            return this._session.get(string, serializable, lockMode);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public LockMode getCurrentLockMode(Object object) throws PersistentException {
        try {
            return this._session.getCurrentLockMode(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Filter getEnabledFilter(String string) {
        return this._session.getEnabledFilter(string);
    }

    public String getEntityName(Object object) throws PersistentException {
        try {
            return this._session.getEntityName(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public FlushMode getFlushMode() {
        return this._session.getFlushMode();
    }

    public CacheMode getCacheMode() {
        return this._session.getCacheMode();
    }

    public Serializable getIdentifier(Object object) throws PersistentException {
        try {
            return this._session.getIdentifier(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Query getNamedQuery(String string) throws PersistentException {
        try {
            return this._session.getNamedQuery(string);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public SessionFactory getSessionFactory() {
        return this._session.getSessionFactory();
    }

    public int hashCode() {
        return this._session.hashCode();
    }

    public boolean isConnected() {
        return this._session.isConnected();
    }

    public boolean isDirty() throws PersistentException {
        try {
            return this._session.isDirty();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public boolean isOpen() {
        return this._session.isOpen();
    }

    public Object load(Class clazz, Serializable serializable) throws PersistentException {
        try {
            return this._session.load(clazz, serializable);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Object load(Class clazz, Serializable serializable, LockMode lockMode) throws PersistentException {
        try {
            return this._session.load(clazz, serializable, lockMode);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void load(Object object, Serializable serializable) throws PersistentException {
        try {
            this._session.load(object, serializable);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Object load(String string, Serializable serializable) throws PersistentException {
        try {
            return this._session.load(string, serializable);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Object load(String string, Serializable serializable, LockMode lockMode) throws PersistentException {
        try {
            return this._session.load(string, serializable, lockMode);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void lock(Object object, LockMode lockMode) throws PersistentException {
        try {
            this._session.lock(object, lockMode);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void lock(String string, Object object, LockMode lockMode) throws PersistentException {
        try {
            this._session.lock(string, object, lockMode);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Object merge(Object object) throws PersistentException {
        try {
            return this._session.merge(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Object merge(String string, Object object) throws PersistentException {
        try {
            return this._session.merge(string, object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void persist(Object object) throws PersistentException {
        try {
            this._session.persist(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void persist(String string, Object object) throws PersistentException {
        try {
            this._session.persist(string, object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void reconnect(Connection connection) throws PersistentException {
        try {
            this._session.reconnect(connection);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void refresh(Object object) throws PersistentException {
        try {
            this._session.refresh(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void refresh(Object object, LockMode lockMode) throws PersistentException {
        try {
            this._session.refresh(object, lockMode);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws PersistentException {
        try {
            this._session.replicate(object, replicationMode);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void replicate(String string, Object object, ReplicationMode replicationMode) throws PersistentException {
        try {
            this._session.replicate(string, object, replicationMode);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Serializable save(Object object) throws PersistentException {
        try {
            return this._session.save(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Serializable save(String string, Object object) throws PersistentException {
        try {
            return this._session.save(string, object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void saveOrUpdate(Object object) throws PersistentException {
        try {
            this._session.saveOrUpdate(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void saveOrUpdate(String string, Object object) throws PersistentException {
        try {
            this._session.saveOrUpdate(string, object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void setFlushMode(FlushMode flushMode) {
        this._session.setFlushMode(flushMode);
    }

    public void setCacheMode(CacheMode cacheMode) {
        this._session.setCacheMode(cacheMode);
    }

    public String toString() {
        return this._session.toString();
    }

    public void update(Object object) throws PersistentException {
        try {
            this._session.update(object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void update(String string, Object object) throws PersistentException {
        try {
            this._session.update(string, object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    void setTransaction(boolean bl) {
        this._transaction = bl;
    }

    boolean isTransaction() {
        return this._transaction;
    }

    public void delete(String string, Object object) throws PersistentException {
        try {
            this._session.delete(string, object);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public Transaction getTransaction() {
        return this._session.getTransaction();
    }

    public void setReadOnly(Object object, boolean bl) {
        this._session.setReadOnly(object, bl);
    }

    public Session getHibernateSession() {
        return this._session;
    }

    public LobHelper getLobHelper() {
        return this._session.getLobHelper();
    }

    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return this._session.buildLockRequest(lockOptions);
    }

    public void doWork(Work work) throws PersistentException {
        try {
            this._session.doWork(work);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public String getTenantIdentifier() {
        return this._session.getTenantIdentifier();
    }

    public SharedSessionBuilder sessionWithOptions() {
        return this._session.sessionWithOptions();
    }

    public boolean isDefaultReadOnly() {
        return this._session.isDefaultReadOnly();
    }

    public void setDefaultReadOnly(boolean bl) {
        this._session.setDefaultReadOnly(bl);
    }

    public Object load(Class clazz, Serializable serializable, LockOptions lockOptions) {
        return this._session.load(clazz, serializable, lockOptions);
    }

    public Object load(String string, Serializable serializable, LockOptions lockOptions) {
        return this._session.load(string, serializable, lockOptions);
    }

    public void refresh(String string, Object object) {
        this._session.refresh(string, object);
    }

    public void refresh(Object object, LockOptions lockOptions) {
        this._session.refresh(object, lockOptions);
    }

    public void refresh(String string, Object object, LockOptions lockOptions) {
        this._session.refresh(string, object, lockOptions);
    }

    public Object get(Class clazz, Serializable serializable, LockOptions lockOptions) {
        return this._session.get(clazz, serializable, lockOptions);
    }

    public Object get(String string, Serializable serializable, LockOptions lockOptions) {
        return this._session.get(string, serializable, lockOptions);
    }

    public IdentifierLoadAccess byId(String string) {
        return this._session.byId(string);
    }

    public IdentifierLoadAccess byId(Class clazz) {
        return this._session.byId(clazz);
    }

    public NaturalIdLoadAccess byNaturalId(String string) {
        return this._session.byNaturalId(string);
    }

    public NaturalIdLoadAccess byNaturalId(Class clazz) {
        return this._session.byNaturalId(clazz);
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(String string) {
        return this._session.bySimpleNaturalId(string);
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(Class clazz) {
        return this._session.bySimpleNaturalId(clazz);
    }

    public SessionStatistics getStatistics() {
        return this._session.getStatistics();
    }

    public boolean isReadOnly(Object object) {
        return this._session.isReadOnly(object);
    }

    public <T> T doReturningWork(ReturningWork<T> returningWork) throws PersistentException {
        try {
            return this._session.doReturningWork(returningWork);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public boolean isFetchProfileEnabled(String string) throws PersistentException {
        try {
            return this._session.isFetchProfileEnabled(string);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void enableFetchProfile(String string) throws PersistentException {
        try {
            this._session.enableFetchProfile(string);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public void disableFetchProfile(String string) throws PersistentException {
        try {
            this._session.disableFetchProfile(string);
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public TypeHelper getTypeHelper() {
        return this._session.getTypeHelper();
    }
}

