/*
 * Decompiled with CFR 0.152.
 */
package org.orm;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.Interceptor;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

public class ORMInterceptor
extends EmptyInterceptor {
    private int[] _lengthTable;
    private ORMPoolEntry[][] _objectTable;
    private final Map _classHierarchyMap;
    protected Interceptor _userInterceptor;

    public ORMInterceptor(Map map, String[] stringArray) {
        ArrayList arrayList;
        Integer n;
        this._classHierarchyMap = map;
        HashMap<Integer, ArrayList> hashMap = new HashMap<Integer, ArrayList>();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string = stringArray[i];
            n = new Integer(string.length());
            arrayList = (ArrayList)hashMap.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(n, arrayList);
            }
            arrayList.add(string);
        }
        this._lengthTable = new int[hashMap.size()];
        this._objectTable = new ORMPoolEntry[hashMap.size()][];
        Object[] objectArray = hashMap.keySet().toArray();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            n = (Integer)objectArray[i];
            this._lengthTable[i] = n;
            arrayList = (ArrayList)hashMap.get(n);
            this._objectTable[i] = new ORMPoolEntry[arrayList.size()];
            int n2 = 0;
            for (String string : arrayList) {
                this._objectTable[i][n2++] = new ORMPoolEntry(string);
            }
        }
    }

    protected ORMPoolEntry getORMPoolEntry(String string) {
        int n = string.length();
        int n2 = Arrays.binarySearch(this._lengthTable, n);
        if (n2 >= 0) {
            ORMPoolEntry[] oRMPoolEntryArray = this._objectTable[n2];
            for (int i = oRMPoolEntryArray.length - 1; i >= 0; --i) {
                ORMPoolEntry oRMPoolEntry = oRMPoolEntryArray[i];
                if (!this.stringEquals(oRMPoolEntry.getKey(), string)) continue;
                return oRMPoolEntry;
            }
        }
        return null;
    }

    protected boolean stringEquals(String string, String string2) {
        if (string == string2) {
            return true;
        }
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) == string2.charAt(n)) continue;
            return false;
        }
        return false;
    }

    public boolean onLoad(Object object, Serializable serializable, Object[] objectArray, String[] stringArray, Type[] typeArray) throws CallbackException {
        ORMPoolEntry oRMPoolEntry;
        String string = object.getClass().getName();
        String string2 = (String)this._classHierarchyMap.get(string);
        if (string2 == null) {
            string2 = string;
        }
        if ((oRMPoolEntry = this.getORMPoolEntry(string2)) != null) {
            oRMPoolEntry.addValue(serializable, object);
        }
        if (this._userInterceptor != null) {
            return this._userInterceptor.onLoad(object, serializable, objectArray, stringArray, typeArray);
        }
        return false;
    }

    public String getEntityName(Object object) throws CallbackException {
        if (this._userInterceptor != null) {
            return this._userInterceptor.getEntityName(object);
        }
        return object.getClass().getName();
    }

    public Object getEntity(String string, Serializable serializable) throws CallbackException {
        ORMPoolEntry oRMPoolEntry;
        Object object = null;
        String string2 = (String)this._classHierarchyMap.get(string);
        if (string2 == null) {
            string2 = string;
        }
        if ((oRMPoolEntry = this.getORMPoolEntry(string2)) != null) {
            object = oRMPoolEntry.getValue(serializable);
        }
        if (this._userInterceptor != null) {
            return this._userInterceptor.getEntity(string, serializable);
        }
        return object;
    }

    public Interceptor getUserInterceptor() {
        return this._userInterceptor;
    }

    public void setUserInterceptor(Interceptor interceptor) {
        this._userInterceptor = interceptor;
    }

    public void afterTransactionBegin(Transaction transaction) {
        if (this._userInterceptor != null) {
            this._userInterceptor.afterTransactionBegin(transaction);
        }
        super.afterTransactionBegin(transaction);
    }

    public void afterTransactionCompletion(Transaction transaction) {
        if (this._userInterceptor != null) {
            this._userInterceptor.afterTransactionCompletion(transaction);
        }
        super.afterTransactionCompletion(transaction);
    }

    public void beforeTransactionCompletion(Transaction transaction) {
        if (this._userInterceptor != null) {
            this._userInterceptor.beforeTransactionCompletion(transaction);
        }
        super.beforeTransactionCompletion(transaction);
    }

    public int[] findDirty(Object object, Serializable serializable, Object[] objectArray, Object[] objectArray2, String[] stringArray, Type[] typeArray) {
        if (this._userInterceptor != null) {
            return this._userInterceptor.findDirty(object, serializable, objectArray, objectArray2, stringArray, typeArray);
        }
        return super.findDirty(object, serializable, objectArray, objectArray2, stringArray, typeArray);
    }

    public Object instantiate(String string, EntityMode entityMode, Serializable serializable) {
        if (this._userInterceptor != null) {
            return this._userInterceptor.instantiate(string, entityMode, serializable);
        }
        return super.instantiate(string, entityMode, serializable);
    }

    public Boolean isTransient(Object object) {
        if (this._userInterceptor != null) {
            return this._userInterceptor.isTransient(object);
        }
        return super.isTransient(object);
    }

    public void onCollectionRecreate(Object object, Serializable serializable) throws CallbackException {
        if (this._userInterceptor != null) {
            this._userInterceptor.onCollectionRecreate(object, serializable);
        }
        super.onCollectionRecreate(object, serializable);
    }

    public void onCollectionRemove(Object object, Serializable serializable) throws CallbackException {
        if (this._userInterceptor != null) {
            this._userInterceptor.onCollectionRemove(object, serializable);
        }
        super.onCollectionRemove(object, serializable);
    }

    public void onCollectionUpdate(Object object, Serializable serializable) throws CallbackException {
        if (this._userInterceptor != null) {
            this._userInterceptor.onCollectionUpdate(object, serializable);
        }
        super.onCollectionUpdate(object, serializable);
    }

    public void onDelete(Object object, Serializable serializable, Object[] objectArray, String[] stringArray, Type[] typeArray) {
        if (this._userInterceptor != null) {
            this._userInterceptor.onDelete(object, serializable, objectArray, stringArray, typeArray);
        }
        super.onDelete(object, serializable, objectArray, stringArray, typeArray);
    }

    public boolean onFlushDirty(Object object, Serializable serializable, Object[] objectArray, Object[] objectArray2, String[] stringArray, Type[] typeArray) {
        if (this._userInterceptor != null) {
            return this._userInterceptor.onFlushDirty(object, serializable, objectArray, objectArray2, stringArray, typeArray);
        }
        return super.onFlushDirty(object, serializable, objectArray, objectArray2, stringArray, typeArray);
    }

    public String onPrepareStatement(String string) {
        if (this._userInterceptor != null) {
            return this._userInterceptor.onPrepareStatement(string);
        }
        return super.onPrepareStatement(string);
    }

    public boolean onSave(Object object, Serializable serializable, Object[] objectArray, String[] stringArray, Type[] typeArray) {
        if (this._userInterceptor != null) {
            return this._userInterceptor.onSave(object, serializable, objectArray, stringArray, typeArray);
        }
        return super.onSave(object, serializable, objectArray, stringArray, typeArray);
    }

    public void postFlush(Iterator iterator) {
        if (this._userInterceptor != null) {
            this._userInterceptor.postFlush(iterator);
        }
        super.postFlush(iterator);
    }

    public void preFlush(Iterator iterator) {
        if (this._userInterceptor != null) {
            this._userInterceptor.preFlush(iterator);
        }
        super.preFlush(iterator);
    }

    protected static class ORMPoolEntry {
        private final String _key;
        private Map _values;

        public ORMPoolEntry(String string) {
            this._key = string;
            this._values = new HashMap();
        }

        public String getKey() {
            return this._key;
        }

        public Object getValue(Object object) {
            WeakReference weakReference = (WeakReference)this._values.get(object);
            return weakReference == null ? null : weakReference.get();
        }

        public void addValue(Object object, Object object2) {
            this._values.put(object, new WeakReference<Object>(object2));
        }

        public int count() {
            return this._values.size();
        }
    }
}

