/*
 * Decompiled with CFR 0.152.
 */
package org.orm;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.hibernate.dialect.Dialect;
import org.hibernate.jdbc.Work;
import org.jboss.logging.Logger;
import org.orm.PersistentException;
import org.orm.PersistentManager;
import org.orm.PersistentSession;
import org.orm.ermodel.ERModel;
import org.orm.ermodel.handler.ERModelHandler;
import org.orm.ertodb.DDLGenerator;
import org.orm.ertodb.DDLStatementCollection;

public class ORMDatabaseInitiator {
    private static final Logger LOG = Logger.getLogger(ORMDatabaseInitiator.class.getName());

    private ORMDatabaseInitiator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSchema(PersistentManager persistentManager) throws SQLException, PersistentException {
        ERModel eRModel = ORMDatabaseInitiator.loadERModel(persistentManager);
        DDLGenerator dDLGenerator = new DDLGenerator();
        final DDLStatementCollection dDLStatementCollection = dDLGenerator.createSchema(eRModel, Dialect.getDialect(persistentManager.getConfiguration().getProperties()));
        PersistentSession persistentSession = persistentManager.getSession();
        try {
            persistentSession.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    ORMDatabaseInitiator.executeStatements(dDLStatementCollection.getAllStatements(), connection);
                }
            });
        }
        finally {
            persistentSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropSchema(PersistentManager persistentManager) throws SQLException, PersistentException {
        ERModel eRModel = ORMDatabaseInitiator.loadERModel(persistentManager);
        DDLGenerator dDLGenerator = new DDLGenerator();
        final String[] stringArray = dDLGenerator.dropSchema(eRModel, Dialect.getDialect(persistentManager.getConfiguration().getProperties())).getAllStatements();
        PersistentSession persistentSession = persistentManager.getSession();
        try {
            persistentSession.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    ORMDatabaseInitiator.executeStatements(stringArray, connection);
                }
            });
        }
        finally {
            persistentSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSchema(final PersistentManager persistentManager) throws SQLException, PersistentException {
        final ERModel eRModel = ORMDatabaseInitiator.loadERModel(persistentManager);
        final DDLGenerator dDLGenerator = new DDLGenerator();
        PersistentSession persistentSession = persistentManager.getSession();
        try {
            persistentSession.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    Properties properties = persistentManager.getConfiguration().getProperties();
                    String string = properties.getProperty("hibernate.connection.username");
                    DDLStatementCollection dDLStatementCollection = dDLGenerator.updateSchema(eRModel, connection, Dialect.getDialect(properties), string, false, null, null);
                    ORMDatabaseInitiator.executeStatements(dDLStatementCollection.getAllStatements(), connection);
                }
            });
        }
        finally {
            persistentSession.close();
        }
    }

    private static void executeStatements(String[] stringArray, Connection connection) throws SQLException {
        if (!connection.getAutoCommit()) {
            connection.commit();
            connection.setAutoCommit(true);
        }
        Statement statement = connection.createStatement();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                LOG.debug("Executing: " + stringArray[i]);
                statement.executeUpdate(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                LOG.warn((Object)"Error executing script", exception);
            }
        }
        statement.close();
    }

    private static ERModel loadERModel(PersistentManager persistentManager) {
        ERModelHandler eRModelHandler = new ERModelHandler();
        ERModel eRModel = eRModelHandler.load("/ormmapping/" + persistentManager.getProjectName() + ".erd.xml");
        return eRModel;
    }
}

