/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClobTypeDescriptor
implements SqlTypeDescriptor {
    public static final ClobTypeDescriptor DEFAULT = new ClobTypeDescriptor(){

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement preparedStatement, X x, int n, WrapperOptions wrapperOptions) throws SQLException {
                    if (wrapperOptions.useStreamForLobBinding()) {
                        STREAM_BINDING.getClobBinder(javaTypeDescriptor).doBind(preparedStatement, x, n, wrapperOptions);
                    } else {
                        CLOB_BINDING.getClobBinder(javaTypeDescriptor).doBind(preparedStatement, x, n, wrapperOptions);
                    }
                }
            };
        }
    };
    public static final ClobTypeDescriptor CLOB_BINDING = new ClobTypeDescriptor(){

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement preparedStatement, X x, int n, WrapperOptions wrapperOptions) throws SQLException {
                    preparedStatement.setClob(n, javaTypeDescriptor.unwrap(x, Clob.class, wrapperOptions));
                }
            };
        }
    };
    public static final ClobTypeDescriptor STREAM_BINDING = new ClobTypeDescriptor(){

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement preparedStatement, X x, int n, WrapperOptions wrapperOptions) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(x, CharacterStream.class, wrapperOptions);
                    preparedStatement.setCharacterStream(n, characterStream.asReader(), characterStream.getLength());
                }
            };
        }
    };
    public static final ClobTypeDescriptor STREAM_BINDING_EXTRACTING = new ClobTypeDescriptor(){

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement preparedStatement, X x, int n, WrapperOptions wrapperOptions) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(x, CharacterStream.class, wrapperOptions);
                    preparedStatement.setCharacterStream(n, characterStream.asReader(), characterStream.getLength());
                }
            };
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicExtractor<X>(javaTypeDescriptor, this){

                @Override
                protected X doExtract(ResultSet resultSet, String string, WrapperOptions wrapperOptions) throws SQLException {
                    return javaTypeDescriptor.wrap(resultSet.getCharacterStream(string), wrapperOptions);
                }
            };
        }
    };

    @Override
    public int getSqlType() {
        return 2005;
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet resultSet, String string, WrapperOptions wrapperOptions) throws SQLException {
                return javaTypeDescriptor.wrap(resultSet.getClob(string), wrapperOptions);
            }
        };
    }

    protected abstract <X> BasicBinder<X> getClobBinder(JavaTypeDescriptor<X> var1);

    @Override
    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return this.getClobBinder(javaTypeDescriptor);
    }
}

