/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanTypeDescriptor
implements SqlTypeDescriptor {
    public static final BooleanTypeDescriptor INSTANCE = new BooleanTypeDescriptor();

    @Override
    public int getSqlType() {
        return 16;
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement preparedStatement, X x, int n, WrapperOptions wrapperOptions) throws SQLException {
                preparedStatement.setBoolean(n, javaTypeDescriptor.unwrap(x, Boolean.class, wrapperOptions));
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet resultSet, String string, WrapperOptions wrapperOptions) throws SQLException {
                return javaTypeDescriptor.wrap(resultSet.getBoolean(string), wrapperOptions);
            }
        };
    }
}

