/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlobTypeDescriptor
implements SqlTypeDescriptor {
    public static final BlobTypeDescriptor DEFAULT = new BlobTypeDescriptor(){

        @Override
        public <X> BasicBinder<X> getBlobBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement preparedStatement, X x, int n, WrapperOptions wrapperOptions) throws SQLException {
                    BlobTypeDescriptor blobTypeDescriptor = BLOB_BINDING;
                    if (byte[].class.isInstance(x)) {
                        blobTypeDescriptor = PRIMITIVE_ARRAY_BINDING;
                    } else if (wrapperOptions.useStreamForLobBinding()) {
                        blobTypeDescriptor = STREAM_BINDING;
                    }
                    blobTypeDescriptor.getBlobBinder(javaTypeDescriptor).doBind(preparedStatement, x, n, wrapperOptions);
                }
            };
        }
    };
    public static final BlobTypeDescriptor PRIMITIVE_ARRAY_BINDING = new BlobTypeDescriptor(){

        @Override
        public <X> BasicBinder<X> getBlobBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                public void doBind(PreparedStatement preparedStatement, X x, int n, WrapperOptions wrapperOptions) throws SQLException {
                    preparedStatement.setBytes(n, javaTypeDescriptor.unwrap(x, byte[].class, wrapperOptions));
                }
            };
        }
    };
    public static final BlobTypeDescriptor BLOB_BINDING = new BlobTypeDescriptor(){

        @Override
        public <X> BasicBinder<X> getBlobBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement preparedStatement, X x, int n, WrapperOptions wrapperOptions) throws SQLException {
                    preparedStatement.setBlob(n, javaTypeDescriptor.unwrap(x, Blob.class, wrapperOptions));
                }
            };
        }
    };
    public static final BlobTypeDescriptor STREAM_BINDING = new BlobTypeDescriptor(){

        @Override
        public <X> BasicBinder<X> getBlobBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement preparedStatement, X x, int n, WrapperOptions wrapperOptions) throws SQLException {
                    BinaryStream binaryStream = javaTypeDescriptor.unwrap(x, BinaryStream.class, wrapperOptions);
                    preparedStatement.setBinaryStream(n, binaryStream.getInputStream(), binaryStream.getLength());
                }
            };
        }
    };

    private BlobTypeDescriptor() {
    }

    @Override
    public int getSqlType() {
        return 2004;
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet resultSet, String string, WrapperOptions wrapperOptions) throws SQLException {
                return javaTypeDescriptor.wrap(resultSet.getBlob(string), wrapperOptions);
            }
        };
    }

    protected abstract <X> BasicBinder<X> getBlobBinder(JavaTypeDescriptor<X> var1);

    public <X> BasicBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return this.getBlobBinder(javaTypeDescriptor);
    }
}

