/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.util.UUID;
import org.hibernate.internal.util.BytesHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUIDTypeDescriptor
extends AbstractTypeDescriptor<UUID> {
    public static final UUIDTypeDescriptor INSTANCE = new UUIDTypeDescriptor();

    public UUIDTypeDescriptor() {
        super(UUID.class);
    }

    @Override
    public String toString(UUID uUID) {
        return ToStringTransformer.INSTANCE.transform(uUID);
    }

    @Override
    public UUID fromString(String string) {
        return ToStringTransformer.INSTANCE.parse(string);
    }

    @Override
    public <X> X unwrap(UUID uUID, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (uUID == null) {
            return null;
        }
        if (UUID.class.isAssignableFrom(clazz)) {
            return (X)PassThroughTransformer.INSTANCE.transform(uUID);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)ToStringTransformer.INSTANCE.transform(uUID);
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return (X)ToBytesTransformer.INSTANCE.transform(uUID);
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> UUID wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (UUID.class.isInstance(x)) {
            return PassThroughTransformer.INSTANCE.parse(x);
        }
        if (String.class.isInstance(x)) {
            return ToStringTransformer.INSTANCE.parse(x);
        }
        if (byte[].class.isInstance(x)) {
            return ToBytesTransformer.INSTANCE.parse(x);
        }
        throw this.unknownWrap(x.getClass());
    }

    public static class ToBytesTransformer
    implements ValueTransformer {
        public static final ToBytesTransformer INSTANCE = new ToBytesTransformer();

        public byte[] transform(UUID uUID) {
            byte[] byArray = new byte[16];
            System.arraycopy(BytesHelper.fromLong(uUID.getMostSignificantBits()), 0, byArray, 0, 8);
            System.arraycopy(BytesHelper.fromLong(uUID.getLeastSignificantBits()), 0, byArray, 8, 8);
            return byArray;
        }

        public UUID parse(Object object) {
            byte[] byArray = new byte[8];
            byte[] byArray2 = new byte[8];
            System.arraycopy(object, 0, byArray, 0, 8);
            System.arraycopy(object, 8, byArray2, 0, 8);
            return new UUID(BytesHelper.asLong(byArray), BytesHelper.asLong(byArray2));
        }
    }

    public static class ToStringTransformer
    implements ValueTransformer {
        public static final ToStringTransformer INSTANCE = new ToStringTransformer();

        public String transform(UUID uUID) {
            return uUID.toString();
        }

        public UUID parse(Object object) {
            return UUID.fromString((String)object);
        }
    }

    public static class PassThroughTransformer
    implements ValueTransformer {
        public static final PassThroughTransformer INSTANCE = new PassThroughTransformer();

        public UUID transform(UUID uUID) {
            return uUID;
        }

        public UUID parse(Object object) {
            return (UUID)object;
        }
    }

    public static interface ValueTransformer {
        public Serializable transform(UUID var1);

        public UUID parse(Object var1);
    }
}

