/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.util.Comparator;
import java.util.TimeZone;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeZoneTypeDescriptor
extends AbstractTypeDescriptor<TimeZone> {
    public static final TimeZoneTypeDescriptor INSTANCE = new TimeZoneTypeDescriptor();

    public TimeZoneTypeDescriptor() {
        super(TimeZone.class);
    }

    @Override
    public String toString(TimeZone timeZone) {
        return timeZone.getID();
    }

    @Override
    public TimeZone fromString(String string) {
        return TimeZone.getTimeZone(string);
    }

    @Override
    public Comparator<TimeZone> getComparator() {
        return TimeZoneComparator.INSTANCE;
    }

    @Override
    public <X> X unwrap(TimeZone timeZone, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (timeZone == null) {
            return null;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)this.toString(timeZone);
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> TimeZone wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (String.class.isInstance(x)) {
            return this.fromString((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimeZoneComparator
    implements Comparator<TimeZone> {
        public static final TimeZoneComparator INSTANCE = new TimeZoneComparator();

        @Override
        public int compare(TimeZone timeZone, TimeZone timeZone2) {
            return timeZone.getID().compareTo(timeZone2.getID());
        }
    }
}

