/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableTypeDescriptor<T extends Serializable>
extends AbstractTypeDescriptor<T> {
    public SerializableTypeDescriptor(Class<T> clazz) {
        super(clazz, Serializable.class.equals(clazz) ? SerializableMutabilityPlan.INSTANCE : new SerializableMutabilityPlan<T>(clazz));
    }

    @Override
    public String toString(T t) {
        return PrimitiveByteArrayTypeDescriptor.INSTANCE.toString(this.toBytes(t));
    }

    @Override
    public T fromString(String string) {
        return this.fromBytes(PrimitiveByteArrayTypeDescriptor.INSTANCE.fromString(string));
    }

    @Override
    public boolean areEqual(T t, T t2) {
        if (t == t2) {
            return true;
        }
        if (t == null || t2 == null) {
            return false;
        }
        return t.equals(t2) || PrimitiveByteArrayTypeDescriptor.INSTANCE.areEqual(this.toBytes(t), this.toBytes(t2));
    }

    @Override
    public int extractHashCode(T t) {
        return PrimitiveByteArrayTypeDescriptor.INSTANCE.extractHashCode(this.toBytes(t));
    }

    @Override
    public <X> X unwrap(T t, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (t == null) {
            return null;
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return (X)this.toBytes(t);
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return (X)new ByteArrayInputStream(this.toBytes(t));
        }
        if (BinaryStream.class.isAssignableFrom(clazz)) {
            return (X)new BinaryStreamImpl(this.toBytes(t));
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return (X)wrapperOptions.getLobCreator().createBlob(this.toBytes(t));
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> T wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (byte[].class.isInstance(x)) {
            return this.fromBytes((byte[])x);
        }
        if (InputStream.class.isInstance(x)) {
            return this.fromBytes(DataHelper.extractBytes((InputStream)x));
        }
        if (Blob.class.isInstance(x)) {
            try {
                return this.fromBytes(DataHelper.extractBytes(((Blob)x).getBinaryStream()));
            }
            catch (SQLException sQLException) {
                throw new HibernateException(sQLException);
            }
        }
        throw this.unknownWrap(x.getClass());
    }

    protected byte[] toBytes(T t) {
        return SerializationHelper.serialize(t);
    }

    protected T fromBytes(byte[] byArray) {
        return (T)((Serializable)SerializationHelper.deserialize(byArray, this.getJavaTypeClass().getClassLoader()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializableMutabilityPlan<S extends Serializable>
    extends MutableMutabilityPlan<S> {
        private final Class<S> type;
        public static final SerializableMutabilityPlan<Serializable> INSTANCE = new SerializableMutabilityPlan<Serializable>(Serializable.class);

        public SerializableMutabilityPlan(Class<S> clazz) {
            this.type = clazz;
        }

        @Override
        public S deepCopyNotNull(S s) {
            return (S)((Serializable)SerializationHelper.clone(s));
        }
    }
}

