/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.ArrayMutabilityPlan;
import org.hibernate.type.descriptor.java.DataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveByteArrayTypeDescriptor
extends AbstractTypeDescriptor<byte[]> {
    public static final PrimitiveByteArrayTypeDescriptor INSTANCE = new PrimitiveByteArrayTypeDescriptor();

    public PrimitiveByteArrayTypeDescriptor() {
        super(byte[].class, ArrayMutabilityPlan.INSTANCE);
    }

    @Override
    public boolean areEqual(byte[] byArray, byte[] byArray2) {
        return byArray == byArray2 || byArray != null && byArray2 != null && Arrays.equals(byArray, byArray2);
    }

    @Override
    public int extractHashCode(byte[] byArray) {
        int n = 1;
        for (byte by : byArray) {
            n = 31 * n + by;
        }
        return n;
    }

    @Override
    public String toString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            String string = Integer.toHexString(by - -128);
            if (string.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public byte[] fromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("The string is not a valid string representation of a binary content.");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = string.substring(i * 2, (i + 1) * 2);
            byArray[i] = (byte)(Integer.parseInt(string2, 16) + -128);
        }
        return byArray;
    }

    @Override
    public <X> X unwrap(byte[] byArray, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (byArray == null) {
            return null;
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return (X)byArray;
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return (X)new ByteArrayInputStream(byArray);
        }
        if (BinaryStream.class.isAssignableFrom(clazz)) {
            return (X)new BinaryStreamImpl(byArray);
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return (X)wrapperOptions.getLobCreator().createBlob(byArray);
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> byte[] wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (byte[].class.isInstance(x)) {
            return (byte[])x;
        }
        if (InputStream.class.isInstance(x)) {
            return DataHelper.extractBytes((InputStream)x);
        }
        if (Blob.class.isInstance(x) || DataHelper.isNClob(x.getClass())) {
            try {
                return DataHelper.extractBytes(((Blob)x).getBinaryStream());
            }
            catch (SQLException sQLException) {
                throw new HibernateException("Unable to access lob stream", sQLException);
            }
        }
        throw this.unknownWrap(x.getClass());
    }
}

