/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.Serializable;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.NClobImplementer;
import org.hibernate.engine.jdbc.NClobProxy;
import org.hibernate.engine.jdbc.WrappedNClob;
import org.hibernate.engine.jdbc.internal.CharacterStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NClobTypeDescriptor
extends AbstractTypeDescriptor<NClob> {
    public static final NClobTypeDescriptor INSTANCE = new NClobTypeDescriptor();

    public NClobTypeDescriptor() {
        super(NClob.class, NClobMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(NClob nClob) {
        return DataHelper.extractString(nClob);
    }

    @Override
    public NClob fromString(String string) {
        return NClobProxy.generateProxy(string);
    }

    @Override
    public Comparator<NClob> getComparator() {
        return IncomparableComparator.INSTANCE;
    }

    @Override
    public int extractHashCode(NClob nClob) {
        return System.identityHashCode(nClob);
    }

    @Override
    public boolean areEqual(NClob nClob, NClob nClob2) {
        return nClob == nClob2;
    }

    @Override
    public <X> X unwrap(NClob nClob, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (nClob == null) {
            return null;
        }
        try {
            if (CharacterStream.class.isAssignableFrom(clazz)) {
                if (NClobImplementer.class.isInstance(nClob)) {
                    return (X)((NClobImplementer)((Object)nClob)).getUnderlyingStream();
                }
                return (X)new CharacterStreamImpl(DataHelper.extractString(nClob.getCharacterStream()));
            }
            if (NClob.class.isAssignableFrom(clazz)) {
                NClob nClob2 = WrappedNClob.class.isInstance(nClob) ? ((WrappedNClob)((Object)nClob)).getWrappedNClob() : nClob;
                return (X)nClob2;
            }
        }
        catch (SQLException sQLException) {
            throw new HibernateException("Unable to access nclob stream", sQLException);
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> NClob wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (NClob.class.isAssignableFrom(x.getClass())) {
            return wrapperOptions.getLobCreator().wrap((NClob)x);
        }
        if (Reader.class.isAssignableFrom(x.getClass())) {
            Reader reader = (Reader)x;
            return wrapperOptions.getLobCreator().createNClob(DataHelper.extractString(reader));
        }
        throw this.unknownWrap(x.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NClobMutabilityPlan
    implements MutabilityPlan<NClob> {
        public static final NClobMutabilityPlan INSTANCE = new NClobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public NClob deepCopy(NClob nClob) {
            return nClob;
        }

        @Override
        public Serializable disassemble(NClob nClob) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }

        @Override
        public NClob assemble(Serializable serializable) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }
    }
}

