/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongTypeDescriptor
extends AbstractTypeDescriptor<Long> {
    public static final LongTypeDescriptor INSTANCE = new LongTypeDescriptor();

    public LongTypeDescriptor() {
        super(Long.class);
    }

    @Override
    public String toString(Long l) {
        return l == null ? null : l.toString();
    }

    @Override
    public Long fromString(String string) {
        return Long.valueOf(string);
    }

    @Override
    public <X> X unwrap(Long l, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (l == null) {
            return null;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)l;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (X)Byte.valueOf(l.byteValue());
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (X)Short.valueOf(l.shortValue());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (X)Integer.valueOf(l.intValue());
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (X)Double.valueOf(l.doubleValue());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (X)Float.valueOf(l.floatValue());
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return (X)BigInteger.valueOf(l);
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return (X)BigDecimal.valueOf(l);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)l.toString();
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Long wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Long.class.isInstance(x)) {
            return (Long)x;
        }
        if (Number.class.isInstance(x)) {
            return ((Number)x).longValue();
        }
        if (String.class.isInstance(x)) {
            return Long.valueOf((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }
}

