/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTimestampTypeDescriptor
extends AbstractTypeDescriptor<Date> {
    public static final JdbcTimestampTypeDescriptor INSTANCE = new JdbcTimestampTypeDescriptor();
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public JdbcTimestampTypeDescriptor() {
        super(Date.class, TimestampMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Date date) {
        return new SimpleDateFormat(TIMESTAMP_FORMAT).format(date);
    }

    @Override
    public Date fromString(String string) {
        try {
            return new Timestamp(new SimpleDateFormat(TIMESTAMP_FORMAT).parse(string).getTime());
        }
        catch (ParseException parseException) {
            throw new HibernateException("could not parse timestamp string" + string, parseException);
        }
    }

    @Override
    public boolean areEqual(Date date, Date date2) {
        int n;
        if (date == date2) {
            return true;
        }
        if (date == null || date2 == null) {
            return false;
        }
        long l = date.getTime();
        long l2 = date2.getTime();
        boolean bl = Timestamp.class.isInstance(date);
        boolean bl2 = Timestamp.class.isInstance(date2);
        int n2 = bl ? ((Timestamp)date).getNanos() : 0;
        int n3 = n = bl2 ? ((Timestamp)date2).getNanos() : 0;
        if (l != l2) {
            return false;
        }
        if (bl && bl2) {
            int n4 = n2 % 1000000;
            int n5 = n % 1000000;
            return n4 == n5;
        }
        return true;
    }

    @Override
    public int extractHashCode(Date date) {
        return Long.valueOf(date.getTime() / 1000L).hashCode();
    }

    @Override
    public <X> X unwrap(Date date, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (date == null) {
            return null;
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            Timestamp timestamp = Timestamp.class.isInstance(date) ? (Timestamp)date : new Timestamp(date.getTime());
            return (X)timestamp;
        }
        if (java.sql.Date.class.isAssignableFrom(clazz)) {
            java.sql.Date date2 = java.sql.Date.class.isInstance(date) ? (java.sql.Date)date : new java.sql.Date(date.getTime());
            return (X)date2;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            Time time = Time.class.isInstance(date) ? (Time)date : new Time(date.getTime());
            return (X)time;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return (X)date;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(date.getTime());
            return (X)gregorianCalendar;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)Long.valueOf(date.getTime());
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Date wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Timestamp.class.isInstance(x)) {
            return (Timestamp)x;
        }
        if (Long.class.isInstance(x)) {
            return new Timestamp((Long)x);
        }
        if (Calendar.class.isInstance(x)) {
            return new Timestamp(((Calendar)x).getTimeInMillis());
        }
        if (Date.class.isInstance(x)) {
            return (Date)x;
        }
        throw this.unknownWrap(x.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimestampMutabilityPlan
    extends MutableMutabilityPlan<Date> {
        public static final TimestampMutabilityPlan INSTANCE = new TimestampMutabilityPlan();

        @Override
        public Date deepCopyNotNull(Date date) {
            if (date instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)date;
                Timestamp timestamp2 = new Timestamp(timestamp.getTime());
                timestamp2.setNanos(timestamp.getNanos());
                return timestamp2;
            }
            Date date2 = date;
            return new Date(date2.getTime());
        }
    }
}

