/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerTypeDescriptor
extends AbstractTypeDescriptor<Integer> {
    public static final IntegerTypeDescriptor INSTANCE = new IntegerTypeDescriptor();

    public IntegerTypeDescriptor() {
        super(Integer.class);
    }

    @Override
    public String toString(Integer n) {
        return n == null ? null : n.toString();
    }

    @Override
    public Integer fromString(String string) {
        return string == null ? null : Integer.valueOf(string);
    }

    @Override
    public <X> X unwrap(Integer n, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (n == null) {
            return null;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (X)n;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (X)Byte.valueOf(n.byteValue());
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (X)Short.valueOf(n.shortValue());
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)Long.valueOf(n.longValue());
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (X)Double.valueOf(n.doubleValue());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (X)Float.valueOf(n.floatValue());
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return (X)BigInteger.valueOf(n.intValue());
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return (X)BigDecimal.valueOf(n.intValue());
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)n.toString();
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Integer wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Integer.class.isInstance(x)) {
            return (Integer)x;
        }
        if (Number.class.isInstance(x)) {
            return ((Number)x).intValue();
        }
        if (String.class.isInstance(x)) {
            return Integer.valueOf((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }
}

