/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleTypeDescriptor
extends AbstractTypeDescriptor<Double> {
    public static final DoubleTypeDescriptor INSTANCE = new DoubleTypeDescriptor();

    public DoubleTypeDescriptor() {
        super(Double.class);
    }

    @Override
    public String toString(Double d) {
        return d == null ? null : d.toString();
    }

    @Override
    public Double fromString(String string) {
        return Double.valueOf(string);
    }

    @Override
    public <X> X unwrap(Double d, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (d == null) {
            return null;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (X)d;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (X)Byte.valueOf(d.byteValue());
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (X)Short.valueOf(d.shortValue());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (X)Integer.valueOf(d.intValue());
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)Long.valueOf(d.longValue());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (X)Float.valueOf(d.floatValue());
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return (X)BigInteger.valueOf(d.longValue());
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return (X)BigDecimal.valueOf(d);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)d.toString();
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Double wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Double.class.isInstance(x)) {
            return (Double)x;
        }
        if (Number.class.isInstance(x)) {
            return ((Number)x).doubleValue();
        }
        if (String.class.isInstance(x)) {
            return Double.valueOf((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }
}

