/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class DataHelper {
    private static final int BUFFER_SIZE = 4096;
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DataHelper.class.getName());

    public static boolean isNClob(Class clazz) {
        return NClob.class.isAssignableFrom(clazz);
    }

    public static String extractString(Reader reader) {
        return DataHelper.extractString(reader, 4096);
    }

    public static String extractString(Reader reader, int n) {
        int n2 = DataHelper.getSuggestedBufferSize(n);
        StringBuilder stringBuilder = new StringBuilder(n2);
        try {
            int n3;
            char[] cArray = new char[n2];
            while ((n3 = reader.read(cArray, 0, n2)) != -1) {
                stringBuilder.append(cArray, 0, n3);
            }
        }
        catch (IOException iOException) {
            throw new HibernateException("IOException occurred reading text", iOException);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                LOG.unableToCloseStream(iOException);
            }
        }
        return stringBuilder.toString();
    }

    private static String extractString(Reader reader, long l, int n) {
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        try {
            int n2;
            long l2 = reader.skip(l);
            if (l2 != l) {
                throw new HibernateException("Unable to skip needed bytes");
            }
            int n3 = DataHelper.getSuggestedBufferSize(n);
            char[] cArray = new char[n3];
            int n4 = 0;
            while ((n2 = reader.read(cArray, 0, n3)) != -1) {
                stringBuilder.append(cArray, 0, n2);
                if (n2 >= n3 && (n4 += n2) < n) continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw new HibernateException("IOException occurred reading a binary value", iOException);
        }
        return stringBuilder.toString();
    }

    public static Object subStream(Reader reader, long l, int n) {
        return new StringReader(DataHelper.extractString(reader, l, n));
    }

    public static byte[] extractBytes(InputStream inputStream) {
        if (BinaryStream.class.isInstance(inputStream)) {
            return ((BinaryStream)((Object)inputStream)).getBytes();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new HibernateException("IOException occurred reading a binary value", iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.unableToCloseInputStream(iOException);
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                LOG.unableToCloseOutputStream(iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] extractBytes(InputStream inputStream, long l, int n) {
        if (BinaryStream.class.isInstance(inputStream) && Integer.MAX_VALUE > l) {
            byte[] byArray = ((BinaryStream)((Object)inputStream)).getBytes();
            int n2 = Math.min(n, byArray.length);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, (int)l, byArray2, 0, n2);
            return byArray2;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            int n3;
            long l2 = inputStream.skip(l);
            if (l2 != l) {
                throw new HibernateException("Unable to skip needed bytes");
            }
            byte[] byArray = new byte[4096];
            int n4 = 0;
            while ((n3 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n3);
                if (n3 >= byArray.length && (n4 += n3) < n) continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw new HibernateException("IOException occurred reading a binary value", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static InputStream subStream(InputStream inputStream, long l, int n) {
        return new BinaryStreamImpl(DataHelper.extractBytes(inputStream, l, n));
    }

    public static String extractString(Clob clob) {
        try {
            Reader reader = clob.getCharacterStream();
            long l = DataHelper.determineLengthForBufferSizing(clob);
            return l > Integer.MAX_VALUE ? DataHelper.extractString(reader, Integer.MAX_VALUE) : DataHelper.extractString(reader, (int)l);
        }
        catch (SQLException sQLException) {
            throw new HibernateException("Unable to access lob stream", sQLException);
        }
    }

    private static long determineLengthForBufferSizing(Clob clob) throws SQLException {
        try {
            return clob.length();
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            return 4096L;
        }
    }

    private static int getSuggestedBufferSize(int n) {
        return Math.max(1, Math.min(n, 4096));
    }
}

