/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.Serializable;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.ClobProxy;
import org.hibernate.engine.jdbc.WrappedClob;
import org.hibernate.engine.jdbc.internal.CharacterStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClobTypeDescriptor
extends AbstractTypeDescriptor<Clob> {
    public static final ClobTypeDescriptor INSTANCE = new ClobTypeDescriptor();

    public ClobTypeDescriptor() {
        super(Clob.class, ClobMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Clob clob) {
        return DataHelper.extractString(clob);
    }

    @Override
    public Clob fromString(String string) {
        return ClobProxy.generateProxy(string);
    }

    @Override
    public Comparator<Clob> getComparator() {
        return IncomparableComparator.INSTANCE;
    }

    @Override
    public int extractHashCode(Clob clob) {
        return System.identityHashCode(clob);
    }

    @Override
    public boolean areEqual(Clob clob, Clob clob2) {
        return clob == clob2;
    }

    @Override
    public <X> X unwrap(Clob clob, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (clob == null) {
            return null;
        }
        try {
            if (CharacterStream.class.isAssignableFrom(clazz)) {
                if (ClobImplementer.class.isInstance(clob)) {
                    return (X)((ClobImplementer)((Object)clob)).getUnderlyingStream();
                }
                return (X)new CharacterStreamImpl(DataHelper.extractString(clob.getCharacterStream()));
            }
            if (Clob.class.isAssignableFrom(clazz)) {
                Clob clob2 = WrappedClob.class.isInstance(clob) ? ((WrappedClob)((Object)clob)).getWrappedClob() : clob;
                return (X)clob2;
            }
        }
        catch (SQLException sQLException) {
            throw new HibernateException("Unable to access clob stream", sQLException);
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Clob wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Clob.class.isAssignableFrom(x.getClass())) {
            return wrapperOptions.getLobCreator().wrap((Clob)x);
        }
        if (Reader.class.isAssignableFrom(x.getClass())) {
            Reader reader = (Reader)x;
            return wrapperOptions.getLobCreator().createClob(DataHelper.extractString(reader));
        }
        throw this.unknownWrap(x.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClobMutabilityPlan
    implements MutabilityPlan<Clob> {
        public static final ClobMutabilityPlan INSTANCE = new ClobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public Clob deepCopy(Clob clob) {
            return clob;
        }

        @Override
        public Serializable disassemble(Clob clob) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }

        @Override
        public Clob assemble(Serializable serializable) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }
    }
}

