/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.HibernateException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTypeDescriptor
extends AbstractTypeDescriptor<Class> {
    public static final ClassTypeDescriptor INSTANCE = new ClassTypeDescriptor();

    public ClassTypeDescriptor() {
        super(Class.class);
    }

    @Override
    public String toString(Class clazz) {
        return clazz.getName();
    }

    @Override
    public Class fromString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return ReflectHelper.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Unable to locate named class " + string);
        }
    }

    @Override
    public <X> X unwrap(Class clazz, Class<X> clazz2, WrapperOptions wrapperOptions) {
        if (clazz == null) {
            return null;
        }
        if (Class.class.isAssignableFrom(clazz2)) {
            return (X)clazz;
        }
        if (String.class.isAssignableFrom(clazz2)) {
            return (X)this.toString(clazz);
        }
        throw this.unknownUnwrap(clazz2);
    }

    @Override
    public <X> Class wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Class.class.isInstance(x)) {
            return (Class)x;
        }
        if (String.class.isInstance(x)) {
            return this.fromString((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }
}

