/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterTypeDescriptor
extends AbstractTypeDescriptor<Character> {
    public static final CharacterTypeDescriptor INSTANCE = new CharacterTypeDescriptor();

    public CharacterTypeDescriptor() {
        super(Character.class);
    }

    @Override
    public String toString(Character c) {
        return c.toString();
    }

    @Override
    public Character fromString(String string) {
        if (string.length() != 1) {
            throw new HibernateException("multiple or zero characters found parsing string");
        }
        return Character.valueOf(string.charAt(0));
    }

    @Override
    public <X> X unwrap(Character c, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (c == null) {
            return null;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return (X)c;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)c.toString();
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return (X)Short.valueOf((short)c.charValue());
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Character wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Character.class.isInstance(x)) {
            return (Character)x;
        }
        if (String.class.isInstance(x)) {
            String string = (String)x;
            return Character.valueOf(string.charAt(0));
        }
        if (Number.class.isInstance(x)) {
            Number number = (Number)x;
            return Character.valueOf((char)number.shortValue());
        }
        throw this.unknownWrap(x.getClass());
    }
}

