/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.util.Arrays;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.internal.CharacterStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.ArrayMutabilityPlan;
import org.hibernate.type.descriptor.java.DataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterArrayTypeDescriptor
extends AbstractTypeDescriptor<Character[]> {
    public static final CharacterArrayTypeDescriptor INSTANCE = new CharacterArrayTypeDescriptor();

    public CharacterArrayTypeDescriptor() {
        super(Character[].class, ArrayMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Character[] characterArray) {
        return new String(this.unwrapChars(characterArray));
    }

    @Override
    public Character[] fromString(String string) {
        return this.wrapChars(string.toCharArray());
    }

    @Override
    public boolean areEqual(Character[] characterArray, Character[] characterArray2) {
        return characterArray == characterArray2 || characterArray != null && characterArray2 != null && Arrays.equals((Object[])characterArray, (Object[])characterArray2);
    }

    @Override
    public int extractHashCode(Character[] characterArray) {
        int n = 1;
        for (Character c : characterArray) {
            n = 31 * n + c.charValue();
        }
        return n;
    }

    @Override
    public <X> X unwrap(Character[] characterArray, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (characterArray == null) {
            return null;
        }
        if (Character[].class.isAssignableFrom(clazz)) {
            return (X)characterArray;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)new String(this.unwrapChars(characterArray));
        }
        if (Clob.class.isAssignableFrom(clazz)) {
            return (X)wrapperOptions.getLobCreator().createClob(new String(this.unwrapChars(characterArray)));
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            return (X)new StringReader(new String(this.unwrapChars(characterArray)));
        }
        if (CharacterStream.class.isAssignableFrom(clazz)) {
            return (X)new CharacterStreamImpl(new String(this.unwrapChars(characterArray)));
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Character[] wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Character[].class.isInstance(x)) {
            return (Character[])x;
        }
        if (String.class.isInstance(x)) {
            return this.wrapChars(((String)x).toCharArray());
        }
        if (Clob.class.isInstance(x)) {
            return this.wrapChars(DataHelper.extractString((Clob)x).toCharArray());
        }
        if (Reader.class.isInstance(x)) {
            return this.wrapChars(DataHelper.extractString((Reader)x).toCharArray());
        }
        throw this.unknownWrap(x.getClass());
    }

    private Character[] wrapChars(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        Character[] characterArray = new Character[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            characterArray[i] = Character.valueOf(cArray[i]);
        }
        return characterArray;
    }

    private char[] unwrapChars(Character[] characterArray) {
        if (characterArray == null) {
            return null;
        }
        char[] cArray = new char[characterArray.length];
        for (int i = 0; i < characterArray.length; ++i) {
            cArray[i] = characterArray[i].charValue();
        }
        return cArray;
    }
}

