/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.ArrayMutabilityPlan;
import org.hibernate.type.descriptor.java.DataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayTypeDescriptor
extends AbstractTypeDescriptor<Byte[]> {
    public static final ByteArrayTypeDescriptor INSTANCE = new ByteArrayTypeDescriptor();

    public ByteArrayTypeDescriptor() {
        super(Byte[].class, ArrayMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Byte[] byteArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Byte by : byteArray) {
            String string = Integer.toHexString(by - -128);
            if (string.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public Byte[] fromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("The string is not a valid string representation of a binary content.");
        }
        Byte[] byteArray = new Byte[string.length() / 2];
        for (int i = 0; i < byteArray.length; ++i) {
            String string2 = string.substring(i * 2, (i + 1) * 2);
            byteArray[i] = (byte)(Integer.parseInt(string2, 16) + -128);
        }
        return byteArray;
    }

    @Override
    public <X> X unwrap(Byte[] byteArray, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (byteArray == null) {
            return null;
        }
        if (Byte[].class.isAssignableFrom(clazz)) {
            return (X)byteArray;
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return (X)this.unwrapBytes(byteArray);
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return (X)new ByteArrayInputStream(this.unwrapBytes(byteArray));
        }
        if (BinaryStream.class.isAssignableFrom(clazz)) {
            return (X)new BinaryStreamImpl(this.unwrapBytes(byteArray));
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return (X)wrapperOptions.getLobCreator().createBlob(this.unwrapBytes(byteArray));
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Byte[] wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Byte[].class.isInstance(x)) {
            return (Byte[])x;
        }
        if (byte[].class.isInstance(x)) {
            return this.wrapBytes((byte[])x);
        }
        if (InputStream.class.isInstance(x)) {
            return this.wrapBytes(DataHelper.extractBytes((InputStream)x));
        }
        if (Blob.class.isInstance(x) || DataHelper.isNClob(x.getClass())) {
            try {
                return this.wrapBytes(DataHelper.extractBytes(((Blob)x).getBinaryStream()));
            }
            catch (SQLException sQLException) {
                throw new HibernateException("Unable to access lob stream", sQLException);
            }
        }
        throw this.unknownWrap(x.getClass());
    }

    private Byte[] wrapBytes(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    private byte[] unwrapBytes(Byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return byArray;
    }
}

